/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.types.proto;

import com.google.common.base.CaseFormat;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import com.google.template.soy.types.proto.JavaQualifiedNames;
import com.google.template.soy.types.proto.SafeStringTypes;

public final class ProtoUtils {
    private static final ImmutableSet<Descriptors.FieldDescriptor.Type> JS_TYPEABLE_FIELDS = Sets.immutableEnumSet((Enum)Descriptors.FieldDescriptor.Type.INT64, (Enum[])new Descriptors.FieldDescriptor.Type[]{Descriptors.FieldDescriptor.Type.SFIXED64, Descriptors.FieldDescriptor.Type.UINT64, Descriptors.FieldDescriptor.Type.FIXED64, Descriptors.FieldDescriptor.Type.SINT64});

    private ProtoUtils() {
    }

    public static boolean isSanitizedContentField(Descriptors.FieldDescriptor fieldDescriptor) {
        return fieldDescriptor.getType() == Descriptors.FieldDescriptor.Type.MESSAGE && SafeStringTypes.SAFE_PROTO_TO_SANITIZED_TYPE.containsKey((Object)fieldDescriptor.getMessageType().getFullName());
    }

    public static String getTofuExtensionImport(Descriptors.FieldDescriptor desc) {
        String extensionFieldName = JavaQualifiedNames.getFieldName(desc, false);
        String extensionFieldHolderClassName = desc.getExtensionScope() != null ? JavaQualifiedNames.getQualifiedName(desc.getExtensionScope()) : JavaQualifiedNames.getPackage(desc.getFile()) + "." + JavaQualifiedNames.getOuterClassname(desc.getFile());
        return extensionFieldHolderClassName + "." + extensionFieldName + ".getDescriptor()";
    }

    public static String getJsExtensionImport(Descriptors.FieldDescriptor desc) {
        Descriptors.Descriptor scope = desc.getExtensionScope();
        if (scope != null) {
            while (scope.getContainingType() != null) {
                scope = scope.getContainingType();
            }
            return ProtoUtils.calculateQualifiedJsName((Descriptors.GenericDescriptor)scope);
        }
        return ProtoUtils.getJsPackage(desc.getFile()) + "." + ProtoUtils.computeJsExtensionName(desc);
    }

    public static String getJsExtensionName(Descriptors.FieldDescriptor desc) {
        Descriptors.Descriptor scope = desc.getExtensionScope();
        if (scope != null) {
            return ProtoUtils.calculateQualifiedJsName((Descriptors.GenericDescriptor)scope) + "." + ProtoUtils.computeJsExtensionName(desc);
        }
        return ProtoUtils.getJsPackage(desc.getFile()) + "." + ProtoUtils.computeJsExtensionName(desc);
    }

    private static String computeJsExtensionName(Descriptors.FieldDescriptor field) {
        String name = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, field.getName());
        return field.isRepeated() ? name + "List" : name;
    }

    private static String getJsPackage(Descriptors.FileDescriptor file) {
        String protoPackage = file.getPackage();
        if (!protoPackage.isEmpty()) {
            return "proto." + protoPackage;
        }
        return "proto";
    }

    static boolean shouldJsIgnoreField(Descriptors.FieldDescriptor fieldDescriptor) {
        return false;
    }

    static boolean hasJsMapKey(Descriptors.FieldDescriptor fieldDescriptor) {
        return false;
    }

    static String getJsMapKeyFieldName(Descriptors.FieldDescriptor fieldDescriptor) {
        return null;
    }

    public static boolean hasJsType(Descriptors.FieldDescriptor fieldDescriptor) {
        if (!JS_TYPEABLE_FIELDS.contains((Object)fieldDescriptor.getType())) {
            return false;
        }
        return fieldDescriptor.getOptions().hasJstype();
    }

    public static boolean isUnsigned(Descriptors.FieldDescriptor descriptor) {
        switch (descriptor.getType()) {
            case FIXED32: 
            case FIXED64: 
            case UINT32: 
            case UINT64: {
                return true;
            }
        }
        return false;
    }

    public static DescriptorProtos.FieldOptions.JSType getJsType(Descriptors.FieldDescriptor fieldDescriptor) {
        boolean hasJstype = fieldDescriptor.getOptions().hasJstype();
        if (hasJstype) {
            return fieldDescriptor.getOptions().getJstype();
        }
        return null;
    }

    static String calculateJsEnumName(Descriptors.EnumDescriptor descriptor) {
        return ProtoUtils.calculateQualifiedJsName((Descriptors.GenericDescriptor)descriptor);
    }

    static String calculateQualifiedJsName(Descriptors.GenericDescriptor descriptor) {
        String protoPackage = descriptor.getFile().getPackage();
        String name = descriptor.getFullName();
        if (!name.startsWith(protoPackage)) {
            throw new AssertionError((Object)("Expected \"" + name + "\" to start with \"" + protoPackage + "\""));
        }
        String jsPackage = ProtoUtils.getJsPackage(descriptor.getFile());
        if (protoPackage.isEmpty()) {
            return jsPackage + "." + name;
        }
        return jsPackage + name.substring(protoPackage.length());
    }

    static boolean shouldCheckFieldPresenceToEmulateJspbNullability(Descriptors.FieldDescriptor desc) {
        boolean hasBrokenSemantics = false;
        if (desc.hasDefaultValue() || desc.isRepeated()) {
            return false;
        }
        if (desc.getFile().getSyntax() == Descriptors.FileDescriptor.Syntax.PROTO3 || !hasBrokenSemantics) {
            return desc.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE;
        }
        return true;
    }
}

