/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.parsepasses.contextautoesc;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.template.soy.internal.base.UnescapeUtils;
import com.google.template.soy.parsepasses.contextautoesc.Context;
import com.google.template.soy.parsepasses.contextautoesc.JsUtil;
import com.google.template.soy.parsepasses.contextautoesc.SoyAutoescapeException;
import com.google.template.soy.soytree.HtmlContext;
import com.google.template.soy.soytree.RawTextNode;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

final class RawTextContextUpdater {
    private int numCharsConsumed;
    private Context next;
    private static final Transition TRANSITION_TO_SELF = new Transition(){

        @Override
        Context computeNextContext(Context prior, Matcher matcher) {
            return prior;
        }
    };
    private static final Transition URI_PART_TRANSITION = new Transition(Pattern.compile("([:./&?=#])|\\z")){

        @Override
        boolean isApplicableTo(Context prior, Matcher matcher) {
            return true;
        }

        @Override
        Context computeNextContext(RawTextNode node, int offset, Context prior, Matcher matcher) {
            String match;
            Context.UriPart uriPart = prior.uriPart;
            if (uriPart == Context.UriPart.START) {
                uriPart = Context.UriPart.MAYBE_SCHEME;
            }
            if ((match = matcher.group(1)) != null) {
                uriPart = RawTextContextUpdater.getNextUriPart(node, offset, uriPart, match.charAt(0));
            }
            return prior.derive(uriPart);
        }
    };
    private static final Transition URI_START_TRANSITION = new Transition(Pattern.compile("(?i)^(javascript|data|blob|filesystem):")){

        @Override
        boolean isApplicableTo(Context prior, Matcher matcher) {
            return prior.uriPart == Context.UriPart.START;
        }

        @Override
        Context computeNextContext(Context prior, Matcher matcher) {
            return prior.derive(Context.UriPart.DANGEROUS_SCHEME);
        }
    };
    private static final String JS_LINEBREAKS = "\\r\\n\u2028\u2029";
    private static final ImmutableMap<HtmlContext, List<Transition>> TRANSITIONS = ImmutableMap.builder().put((Object)HtmlContext.HTML_PCDATA, (Object)ImmutableList.of((Object)TRANSITION_TO_SELF)).put((Object)HtmlContext.HTML_COMMENT, (Object)ImmutableList.of((Object)TRANSITION_TO_SELF)).put((Object)HtmlContext.HTML_NORMAL_ATTR_VALUE, (Object)ImmutableList.of((Object)TRANSITION_TO_SELF)).put((Object)HtmlContext.CSS, (Object)ImmutableList.of((Object)RawTextContextUpdater.makeTransitionToStateLiteral("/*", HtmlContext.CSS_COMMENT), (Object)RawTextContextUpdater.makeTransitionToStateLiteral("\"", HtmlContext.CSS_DQ_STRING), (Object)RawTextContextUpdater.makeTransitionToStateLiteral("'", HtmlContext.CSS_SQ_STRING), (Object)RawTextContextUpdater.makeCssUriTransition(Pattern.compile("(?i)(?:[^a-z0-9-]|^)\\s*(?:background|background-image|border-image|content|cursor|list-style|list-style-image)\\s*:\\s*url\\s*\\(\\s*(['\"]?)"), Context.UriType.MEDIA), (Object)RawTextContextUpdater.makeCssUriTransition(Pattern.compile("(?i)\\burl\\s*\\(\\s*(['\"]?)"), Context.UriType.NORMAL), (Object)TRANSITION_TO_SELF)).put((Object)HtmlContext.CSS_COMMENT, (Object)ImmutableList.of((Object)RawTextContextUpdater.makeTransitionToStateLiteral("*/", HtmlContext.CSS), (Object)TRANSITION_TO_SELF)).put((Object)HtmlContext.CSS_DQ_STRING, (Object)ImmutableList.of((Object)RawTextContextUpdater.makeTransitionToStateLiteral("\"", HtmlContext.CSS), (Object)RawTextContextUpdater.makeTransitionToSelf(Pattern.compile("\\\\(?:\r\n?|[\n\f\"])")), (Object)RawTextContextUpdater.makeTransitionToError(Pattern.compile("[\n\r\f]"), "Newlines not permitted in string literals."), (Object)TRANSITION_TO_SELF)).put((Object)HtmlContext.CSS_SQ_STRING, (Object)ImmutableList.of((Object)RawTextContextUpdater.makeTransitionToStateLiteral("'", HtmlContext.CSS), (Object)RawTextContextUpdater.makeTransitionToSelf(Pattern.compile("\\\\(?:\r\n?|[\n\f'])")), (Object)RawTextContextUpdater.makeTransitionToError(Pattern.compile("[\n\r\f]"), "Newlines not permitted in string literals."), (Object)TRANSITION_TO_SELF)).put((Object)HtmlContext.CSS_URI, (Object)ImmutableList.of((Object)RawTextContextUpdater.makeTransitionToState(Pattern.compile("[\\)\\s]"), HtmlContext.CSS), (Object)URI_PART_TRANSITION, (Object)URI_START_TRANSITION, (Object)RawTextContextUpdater.makeTransitionToError(Pattern.compile("[\"']"), "Quotes not permitted in CSS URIs."))).put((Object)HtmlContext.CSS_SQ_URI, (Object)ImmutableList.of((Object)RawTextContextUpdater.makeTransitionToStateLiteral("'", HtmlContext.CSS), (Object)URI_PART_TRANSITION, (Object)URI_START_TRANSITION, (Object)RawTextContextUpdater.makeTransitionToSelf(Pattern.compile("\\\\(?:\r\n?|[\n\f'])")), (Object)RawTextContextUpdater.makeTransitionToError(Pattern.compile("[\n\r\f]"), "Newlines not permitted in string literal."))).put((Object)HtmlContext.CSS_DQ_URI, (Object)ImmutableList.of((Object)RawTextContextUpdater.makeTransitionToStateLiteral("\"", HtmlContext.CSS), (Object)URI_PART_TRANSITION, (Object)URI_START_TRANSITION, (Object)RawTextContextUpdater.makeTransitionToSelf(Pattern.compile("\\\\(?:\r\n?|[\n\f\"])")), (Object)RawTextContextUpdater.makeTransitionToError(Pattern.compile("[\n\r\f]"), "Newlines not permitted in string literal."))).put((Object)HtmlContext.JS, (Object)ImmutableList.of((Object)RawTextContextUpdater.makeTransitionToStateLiteral("/*", HtmlContext.JS_BLOCK_COMMENT), (Object)RawTextContextUpdater.makeTransitionToStateLiteral("//", HtmlContext.JS_LINE_COMMENT), (Object)RawTextContextUpdater.makeTransitionToJsStringLiteral("\"", HtmlContext.JS_DQ_STRING), (Object)RawTextContextUpdater.makeTransitionToJsStringLiteral("'", HtmlContext.JS_SQ_STRING), (Object)new Transition("`"){

        @Override
        Context computeNextContext(Context prior, Matcher matcher) {
            return prior.toBuilder().withState(HtmlContext.JS_TEMPLATE_LITERAL).withJsTemplateLiteralNestDepth(prior.jsTemplateLiteralNestDepth + 1).build();
        }
    }, (Object)new Transition("}"){

        @Override
        Context computeNextContext(Context prior, Matcher matcher) {
            if (prior.jsTemplateLiteralNestDepth > 0) {
                return prior.toBuilder().withState(HtmlContext.JS_TEMPLATE_LITERAL).build();
            }
            return prior;
        }
    }, (Object)new Transition("/"){

        @Override
        Context computeNextContext(RawTextNode node, int offset, Context prior, Matcher matcher) {
            switch (prior.slashType) {
                case DIV_OP: {
                    return prior.toBuilder().withState(HtmlContext.JS).withSlashType(Context.JsFollowingSlash.REGEX).build();
                }
                case REGEX: {
                    return prior.toBuilder().withState(HtmlContext.JS_REGEX).withSlashType(Context.JsFollowingSlash.NONE).build();
                }
            }
            RawTextNode suffixNode = node.substring(Integer.MAX_VALUE, offset);
            throw SoyAutoescapeException.createWithNode("Slash (/) cannot follow the preceding branches since it is unclear whether the slash is a RegExp literal or division operator.  Please add parentheses in the branches leading to `" + suffixNode.getRawText() + "`", suffixNode);
        }
    }, (Object)new Transition(Pattern.compile("[^/\"'}`\\s\\\\]+")){

        @Override
        Context computeNextContext(Context prior, Matcher matcher) {
            return prior.derive(JsUtil.isRegexPreceder(matcher.group()) ? Context.JsFollowingSlash.REGEX : Context.JsFollowingSlash.DIV_OP);
        }
    }, (Object)RawTextContextUpdater.makeTransitionToSelf(Pattern.compile("\\s+")))).put((Object)HtmlContext.JS_BLOCK_COMMENT, (Object)ImmutableList.of((Object)RawTextContextUpdater.makeTransitionToStateLiteral("*/", HtmlContext.JS), (Object)TRANSITION_TO_SELF)).put((Object)HtmlContext.JS_LINE_COMMENT, (Object)ImmutableList.of((Object)RawTextContextUpdater.makeTransitionToState(Pattern.compile("[\\r\\n\u2028\u2029]"), HtmlContext.JS), (Object)TRANSITION_TO_SELF)).put((Object)HtmlContext.JS_DQ_STRING, (Object)ImmutableList.of((Object)RawTextContextUpdater.makeDivPreceder("\""), (Object)RawTextContextUpdater.makeTransitionToSelf(Pattern.compile("(?i)^(?:[^\"\\\\\\r\\n\u2028\u2029]++|\\\\(?:\\r\\n?|[^\\r]))++")))).put((Object)HtmlContext.JS_SQ_STRING, (Object)ImmutableList.of((Object)RawTextContextUpdater.makeDivPreceder("'"), (Object)RawTextContextUpdater.makeTransitionToSelf(Pattern.compile("(?i)^(?:[^'\\\\\\r\\n\u2028\u2029]++|\\\\(?:\\r\\n?|[^\\r]))++")))).put((Object)HtmlContext.JS_TEMPLATE_LITERAL, (Object)ImmutableList.of((Object)new Transition("`"){

        @Override
        Context computeNextContext(Context prior, Matcher matcher) {
            return prior.toBuilder().withState(HtmlContext.JS).withJsTemplateLiteralNestDepth(prior.jsTemplateLiteralNestDepth - 1).withSlashType(Context.JsFollowingSlash.REGEX).build();
        }
    }, (Object)RawTextContextUpdater.makeTransitionToSelf(Pattern.compile("\\\\[$`]")), (Object)RawTextContextUpdater.makeTransitionToStateLiteral("${", HtmlContext.JS), (Object)TRANSITION_TO_SELF)).put((Object)HtmlContext.JS_REGEX, (Object)ImmutableList.of((Object)RawTextContextUpdater.makeDivPreceder("/"), (Object)RawTextContextUpdater.makeTransitionToSelf(Pattern.compile("(?i)^(?:[^\\[\\\\/\\r\\n\u2028\u2029]++|\\\\[^\\r\\n\u2028\u2029]|\\[(?:[^\\]\\\\\\r\\n\u2028\u2029]|\\\\(?:[^\\r\\n\u2028\u2029]))*+\\])+")))).put((Object)HtmlContext.URI, (Object)ImmutableList.of((Object)URI_PART_TRANSITION, (Object)URI_START_TRANSITION)).put((Object)HtmlContext.HTML_RCDATA, (Object)ImmutableList.of((Object)TRANSITION_TO_SELF)).put((Object)HtmlContext.TEXT, (Object)ImmutableList.of((Object)TRANSITION_TO_SELF)).build();

    public static Context processRawText(RawTextNode rawTextNode, Context context) {
        String rawText = rawTextNode.getRawText();
        int offset = 0;
        int length = rawText.length();
        while (offset < length) {
            Context endContext;
            int endOffset;
            String unprocessedRawText = rawText.substring(offset);
            Context startContext = context;
            int attrValueEnd = RawTextContextUpdater.findEndOfAttributeValue(unprocessedRawText, context.delimType);
            if (attrValueEnd == -1) {
                RawTextContextUpdater cu = new RawTextContextUpdater();
                cu.processNextToken(rawTextNode, offset, unprocessedRawText, context);
                endOffset = offset + cu.numCharsConsumed;
                endContext = cu.next;
            } else {
                int unprocessedRawTextLen = unprocessedRawText.length();
                int attrEnd = attrValueEnd < unprocessedRawTextLen ? attrValueEnd + context.delimType.text.length() : -1;
                String attrValueTail = UnescapeUtils.unescapeHtml(unprocessedRawText.substring(0, attrValueEnd));
                RawTextContextUpdater cu = new RawTextContextUpdater();
                Context attrContext = startContext;
                while (attrValueTail.length() != 0) {
                    cu.processNextToken(rawTextNode, offset, attrValueTail, attrContext);
                    attrValueTail = attrValueTail.substring(cu.numCharsConsumed);
                    attrContext = cu.next;
                }
                if (attrEnd != -1) {
                    endOffset = offset + attrEnd;
                    endContext = context.toBuilder().withState(HtmlContext.HTML_TAG).withoutAttrContext().build();
                } else {
                    if (attrValueEnd != unprocessedRawTextLen) {
                        throw new IllegalStateException();
                    }
                    endOffset = length;
                    endContext = attrContext;
                }
            }
            context = endContext;
            offset = endOffset;
        }
        return context;
    }

    private static int findEndOfAttributeValue(String rawText, Context.AttributeEndDelimiter delim) {
        int rawTextLen = rawText.length();
        switch (delim) {
            case DOUBLE_QUOTE: 
            case SINGLE_QUOTE: {
                int quote = rawText.indexOf(delim.text.charAt(0));
                return quote >= 0 ? quote : rawTextLen;
            }
            case SPACE_OR_TAG_END: {
                for (int i = 0; i < rawTextLen; ++i) {
                    char ch = rawText.charAt(i);
                    if (ch != '>' && !Character.isWhitespace(ch)) continue;
                    return i;
                }
                return rawTextLen;
            }
            case NONE: {
                return -1;
            }
        }
        throw new AssertionError((Object)("Unrecognized delimiter " + (Object)((Object)delim)));
    }

    private RawTextContextUpdater() {
    }

    private void processNextToken(RawTextNode node, int offset, String text, Context context) {
        int transitionOffset;
        int earliestStart = Integer.MAX_VALUE;
        int earliestEnd = -1;
        Transition earliestTransition = null;
        Matcher earliestMatcher = null;
        List ts = (List)TRANSITIONS.get((Object)context.state);
        if (ts == null) {
            throw new NullPointerException("no transitions for state: " + (Object)((Object)context.state) + " @" + node.substringLocation(offset, offset + 1));
        }
        block2: for (Transition transition : ts) {
            if (transition.pattern != null) {
                Matcher matcher = transition.pattern.matcher(text);
                try {
                    while (matcher.find() && matcher.start() < earliestStart) {
                        int start = matcher.start();
                        int end = matcher.end();
                        if (!transition.isApplicableTo(context, matcher)) continue;
                        earliestStart = start;
                        earliestEnd = end;
                        earliestTransition = transition;
                        earliestMatcher = matcher;
                        continue block2;
                    }
                    continue;
                }
                catch (StackOverflowError soe) {
                    throw new RuntimeException(String.format("StackOverflow while trying to match: '%s' in context %s starting @ %s", transition.pattern, context, node.substringLocation(offset, offset + 1)), soe);
                }
            }
            if (transition.literal != null) {
                int index;
                int start = 0;
                String needle = transition.literal;
                while ((index = text.indexOf(needle, start)) != -1 && index < earliestStart) {
                    if (!transition.isApplicableTo(context, null)) continue;
                    earliestStart = index;
                    earliestEnd = index + needle.length();
                    earliestTransition = transition;
                    earliestMatcher = null;
                    continue block2;
                }
                continue;
            }
            if (text.length() >= earliestStart || !transition.isApplicableTo(context, null)) continue;
            earliestStart = text.length();
            earliestEnd = text.length();
            earliestTransition = transition;
            earliestMatcher = null;
        }
        if (earliestTransition != null) {
            transitionOffset = offset;
            if (earliestStart < text.length()) {
                transitionOffset += earliestStart;
            }
        } else {
            throw SoyAutoescapeException.createWithNode("Error determining next state when encountering \"" + text + "\" in " + context, node.substring(Integer.MAX_VALUE, offset));
        }
        this.next = earliestTransition.computeNextContext(node, transitionOffset, context, earliestMatcher);
        this.numCharsConsumed = earliestEnd;
        if (this.numCharsConsumed == 0 && this.next.state == context.state) {
            throw new IllegalStateException("Infinite loop at `" + text + "` / " + context);
        }
    }

    private static Transition makeTransitionToStateLiteral(String literal, final HtmlContext state) {
        return new Transition(literal){

            @Override
            Context computeNextContext(Context prior, Matcher matcher) {
                return prior.transitionToState(state);
            }
        };
    }

    private static Transition makeTransitionToState(Pattern regex, final HtmlContext state) {
        return new Transition(regex){

            @Override
            Context computeNextContext(Context prior, Matcher matcher) {
                return prior.transitionToState(state);
            }
        };
    }

    private static Transition makeTransitionToError(Pattern regex, final String message) {
        return new Transition(regex){

            @Override
            Context computeNextContext(RawTextNode node, int offset, Context prior, Matcher matcher) {
                throw SoyAutoescapeException.createWithNode(message, node.substring(Integer.MAX_VALUE, offset));
            }
        };
    }

    private static Transition makeTransitionToJsStringLiteral(String literal, final HtmlContext state) {
        return new Transition(literal){

            @Override
            Context computeNextContext(Context prior, Matcher matcher) {
                return prior.toBuilder().withState(state).withSlashType(Context.JsFollowingSlash.NONE).withUriPart(Context.UriPart.NONE).build();
            }
        };
    }

    private static Transition makeTransitionToSelf(Pattern regex) {
        return new Transition(regex){

            @Override
            Context computeNextContext(Context prior, Matcher matcher) {
                return prior;
            }
        };
    }

    private static Context.UriPart getNextUriPart(RawTextNode node, int offset, Context.UriPart uriPart, char matchChar) {
        switch (uriPart) {
            case MAYBE_SCHEME: 
            case MAYBE_VARIABLE_SCHEME: {
                if (matchChar == ':') {
                    if (uriPart == Context.UriPart.MAYBE_VARIABLE_SCHEME) {
                        throw SoyAutoescapeException.createWithNode("Soy can't safely process a URI that might start with a variable scheme. For example, {$x}:{$y} could have an XSS if $x is 'javascript' and $y is attacker-controlled. Either use a hard-coded scheme, or introduce disambiguating characters (e.g. http://{$x}:{$y}, ./{$x}:{$y}, or {$x}?foo=:{$y})", node.substring(Integer.MAX_VALUE, offset));
                    }
                    return Context.UriPart.AUTHORITY_OR_PATH;
                }
                if (matchChar == '/') {
                    return Context.UriPart.AUTHORITY_OR_PATH;
                }
                if ((matchChar == '=' || matchChar == '&') && uriPart == Context.UriPart.MAYBE_VARIABLE_SCHEME) {
                    return Context.UriPart.QUERY;
                }
            }
            case AUTHORITY_OR_PATH: 
            case UNKNOWN_PRE_FRAGMENT: {
                if (matchChar == '?') {
                    return Context.UriPart.QUERY;
                }
            }
            case QUERY: 
            case UNKNOWN: {
                if (matchChar == '#') {
                    return Context.UriPart.FRAGMENT;
                }
            }
            case FRAGMENT: {
                return uriPart;
            }
            case DANGEROUS_SCHEME: {
                return Context.UriPart.DANGEROUS_SCHEME;
            }
        }
        throw new AssertionError((Object)("Unanticipated URI part: " + (Object)((Object)uriPart)));
    }

    private static Transition makeCssUriTransition(Pattern regex, final Context.UriType uriType) {
        return new Transition(regex){

            @Override
            Context computeNextContext(Context prior, Matcher matcher) {
                String delim = matcher.group(1);
                HtmlContext state = "\"".equals(delim) ? HtmlContext.CSS_DQ_URI : ("'".equals(delim) ? HtmlContext.CSS_SQ_URI : HtmlContext.CSS_URI);
                return prior.toBuilder().withState(state).withUriType(uriType).withUriPart(Context.UriPart.START).build();
            }
        };
    }

    private static Transition makeDivPreceder(String literal) {
        return new Transition(literal){

            @Override
            Context computeNextContext(Context prior, Matcher matcher) {
                return prior.toBuilder().withState(HtmlContext.JS).withSlashType(Context.JsFollowingSlash.DIV_OP).build();
            }
        };
    }

    private static abstract class Transition {
        @Nullable
        final Pattern pattern;
        @Nullable
        final String literal;

        Transition(Pattern pattern) {
            this.pattern = pattern;
            this.literal = null;
        }

        Transition(String literal) {
            this.pattern = null;
            this.literal = literal;
        }

        Transition() {
            this.pattern = null;
            this.literal = null;
        }

        boolean isApplicableTo(Context prior, @Nullable Matcher matcher) {
            return true;
        }

        Context computeNextContext(RawTextNode originalNode, int offset, Context prior, @Nullable Matcher matcher) {
            return this.computeNextContext(prior, matcher);
        }

        Context computeNextContext(Context prior, @Nullable Matcher matcher) {
            throw new AbstractMethodError();
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("pattern", (Object)this.pattern).add("literal", (Object)this.literal).omitNullValues().toString();
        }
    }
}

