/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.parsepasses.contextautoesc;

import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.template.soy.base.internal.SanitizedContentKind;
import com.google.template.soy.basetree.Node;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.parsepasses.contextautoesc.AutoValue_InferenceEngine_DerivedNameAndContext;
import com.google.template.soy.parsepasses.contextautoesc.AutoValue_InferenceEngine_InferencesAndContext;
import com.google.template.soy.parsepasses.contextautoesc.Context;
import com.google.template.soy.parsepasses.contextautoesc.DerivedTemplateUtils;
import com.google.template.soy.parsepasses.contextautoesc.Inferences;
import com.google.template.soy.parsepasses.contextautoesc.RawTextContextUpdater;
import com.google.template.soy.parsepasses.contextautoesc.SoyAutoescapeException;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.AutoescapeMode;
import com.google.template.soy.soytree.CallBasicNode;
import com.google.template.soy.soytree.CallDelegateNode;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.CallParamContentNode;
import com.google.template.soy.soytree.EscapingMode;
import com.google.template.soy.soytree.ForeachIfemptyNode;
import com.google.template.soy.soytree.ForeachNode;
import com.google.template.soy.soytree.ForeachNonemptyNode;
import com.google.template.soy.soytree.HtmlAttributeNode;
import com.google.template.soy.soytree.HtmlAttributeValueNode;
import com.google.template.soy.soytree.HtmlCloseTagNode;
import com.google.template.soy.soytree.HtmlCommentNode;
import com.google.template.soy.soytree.HtmlContext;
import com.google.template.soy.soytree.HtmlOpenTagNode;
import com.google.template.soy.soytree.HtmlTagNode;
import com.google.template.soy.soytree.IfElseNode;
import com.google.template.soy.soytree.IfNode;
import com.google.template.soy.soytree.LetContentNode;
import com.google.template.soy.soytree.MsgFallbackGroupNode;
import com.google.template.soy.soytree.PrintDirectiveNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SwitchDefaultNode;
import com.google.template.soy.soytree.SwitchNode;
import com.google.template.soy.soytree.TemplateNode;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

final class InferenceEngine {
    private static final ImmutableSet<HtmlContext> ILLEGAL_RECONTEXTUALIZATIONS = Sets.immutableEnumSet((Enum)HtmlContext.HTML_TAG, (Enum[])new HtmlContext[]{HtmlContext.HTML_TAG_NAME, HtmlContext.HTML_PCDATA, HtmlContext.HTML_COMMENT, HtmlContext.HTML_ATTRIBUTE_NAME, HtmlContext.HTML_BEFORE_OPEN_TAG_NAME, HtmlContext.HTML_BEFORE_CLOSE_TAG_NAME});
    private final AutoescapeMode autoescapeMode;
    private final AutoescapeMode templateAutoescapeMode;
    private final Inferences inferences;
    private final EscapingMode defaultEscapingMode;
    private final ErrorReporter errorReporter;

    public static Context inferTemplateEndContext(TemplateNode templateNode, Context startContext, Inferences inferences, ErrorReporter errorReporter) {
        Context endContext;
        try {
            AutoescapeMode autoescapeMode = templateNode.getAutoescapeMode();
            InferenceEngine inferenceEngine = new InferenceEngine(autoescapeMode, autoescapeMode, inferences, errorReporter);
            endContext = inferenceEngine.infer(templateNode, startContext);
            inferences.recordTemplateEndContext(templateNode.getTemplateName(), endContext);
        }
        catch (SoyAutoescapeException e) {
            throw e.maybeAssociateNode(templateNode);
        }
        return endContext;
    }

    private static void checkStrictBlockEndContext(SoyNode.RenderUnitNode node, Context endContext) {
        if (!endContext.isValidEndContextForContentKind(node.getContentKind())) {
            String msg = String.format("A strict block of kind=\"%s\" cannot end in context %s. Likely cause is %s.", node.getContentKind().asAttributeValue(), endContext, endContext.getLikelyEndContextMismatchCause(node.getContentKind()));
            throw SoyAutoescapeException.createWithNode(msg, node);
        }
    }

    static void inferStrictRenderUnitNode(AutoescapeMode templateAutoescapeMode, SoyNode.RenderUnitNode node, Inferences inferences, ErrorReporter errorReporter) {
        InferenceEngine inferenceEngine = new InferenceEngine(AutoescapeMode.STRICT, templateAutoescapeMode, inferences, errorReporter);
        Context endContext = inferenceEngine.inferChildren(node, Context.getStartContextForContentKind(node.getContentKind()));
        InferenceEngine.checkStrictBlockEndContext(node, endContext);
    }

    private InferenceEngine(AutoescapeMode autoescapeMode, AutoescapeMode templateAutoescapeMode, Inferences inferences, ErrorReporter errorReporter) {
        this.autoescapeMode = autoescapeMode;
        this.templateAutoescapeMode = templateAutoescapeMode;
        this.inferences = inferences;
        this.defaultEscapingMode = EscapingMode.ESCAPE_HTML;
        this.errorReporter = errorReporter;
    }

    private Context infer(SoyNode node, Context context) {
        return new ContextPropagatingVisitor(context).exec(node);
    }

    private Context inferChildren(SoyNode node, Context context) {
        ContextPropagatingVisitor contextPropagatingVisitor = new ContextPropagatingVisitor(context);
        return contextPropagatingVisitor.execChildren(node);
    }

    private static Context getContextAfterDynamicValue(SoyNode node, Context startContext) {
        return InferenceEngine.getContextAfterEscaping(node, startContext);
    }

    private static Context getContextAfterEscaping(SoyNode node, Context startContext) {
        try {
            return startContext.getContextAfterDynamicValue();
        }
        catch (SoyAutoescapeException e) {
            throw e.maybeAssociateNode(node);
        }
    }

    static abstract class InferencesAndContext {
        InferencesAndContext() {
        }

        static InferencesAndContext create(Inferences inferences, Context context) {
            return new AutoValue_InferenceEngine_InferencesAndContext(inferences, context);
        }

        abstract Inferences inferences();

        abstract Context context();
    }

    static abstract class DerivedNameAndContext {
        DerivedNameAndContext() {
        }

        static DerivedNameAndContext create(String derivedName, Context context) {
            return new AutoValue_InferenceEngine_DerivedNameAndContext(derivedName, context);
        }

        abstract String derivedName();

        abstract Context context();
    }

    private final class ContextPropagatingVisitor
    extends AbstractSoyNodeVisitor<Context> {
        private Context context;

        public ContextPropagatingVisitor(Context context) {
            this.context = context;
        }

        @Override
        public Context exec(SoyNode node) {
            this.visit(node);
            return this.context;
        }

        public Context execChildren(SoyNode node) {
            if (node instanceof SoyNode.ParentSoyNode) {
                this.visitChildren((SoyNode.ParentSoyNode)node);
            }
            return this.context;
        }

        @Override
        protected void visitTemplateNode(TemplateNode templateNode) {
            Preconditions.checkState((templateNode.getAutoescapeMode() == InferenceEngine.this.autoescapeMode ? 1 : 0) != 0, (Object)"Same ContextPropagatingVisitor cannot be reused for multiple escaping modes.");
            if (InferenceEngine.this.autoescapeMode == AutoescapeMode.STRICT) {
                Preconditions.checkState((boolean)this.context.isValidStartContextForContentKind(templateNode.getContentKind()), (Object)"Strict templates may only be visited in the context for their declared content kind.");
                this.context = Context.getStartContextForContentKind(templateNode.getContentKind());
            }
            this.visitChildren(templateNode);
            if (InferenceEngine.this.autoescapeMode == AutoescapeMode.STRICT) {
                InferenceEngine.checkStrictBlockEndContext(templateNode, this.context);
            }
        }

        @Override
        protected void visitRawTextNode(RawTextNode rawTextNode) {
            Context newContext;
            try {
                newContext = RawTextContextUpdater.processRawText(rawTextNode, this.context);
            }
            catch (SoyAutoescapeException ex) {
                throw ex.maybeAssociateNode(rawTextNode);
            }
            this.context = newContext;
        }

        @Override
        protected void visitMsgFallbackGroupNode(MsgFallbackGroupNode node) {
            if (InferenceEngine.this.autoescapeMode == AutoescapeMode.STRICT || InferenceEngine.this.autoescapeMode == AutoescapeMode.CONTEXTUAL) {
                Optional<Context.MsgEscapingStrategy> maybeStrategy = this.context.getMsgEscapingStrategy();
                if (!maybeStrategy.isPresent()) {
                    throw SoyAutoescapeException.createWithNode("Messages are not supported in this context, because it would mean asking translators to write source code; if this is desired, try factoring the message into a {let} block: " + this.context, node);
                }
                Context.MsgEscapingStrategy strategy = (Context.MsgEscapingStrategy)maybeStrategy.get();
                InferenceEngine.this.inferences.setEscapingDirectives(node, this.context, (List<EscapingMode>)strategy.escapingModesForFullMessage);
                Context msgEndContext = new InferenceEngine(InferenceEngine.this.autoescapeMode, InferenceEngine.this.templateAutoescapeMode, InferenceEngine.this.inferences, InferenceEngine.this.errorReporter).inferChildren(node, strategy.childContext);
                if (!msgEndContext.equals(strategy.childContext)) {
                    throw SoyAutoescapeException.createWithNode("Message text should not alter the escaping context. " + this.context + " != " + strategy.childContext, node);
                }
            } else {
                this.visitChildren(node);
            }
        }

        @Override
        protected void visitCallNode(CallNode callNode) {
            try {
                String calleeName = callNode instanceof CallBasicNode ? ((CallBasicNode)callNode).getCalleeName() : ((CallDelegateNode)callNode).getDelCalleeName();
                DerivedNameAndContext derivedNameAndContext = this.inferCallSite(callNode, this.context, calleeName, InferenceEngine.this.inferences);
                String derivedCalleeName = derivedNameAndContext.derivedName();
                if (!calleeName.equals(derivedCalleeName)) {
                    InferenceEngine.this.inferences.retargetCall(callNode, derivedCalleeName);
                }
                this.context = derivedNameAndContext.context();
            }
            catch (SoyAutoescapeException ex) {
                throw ex.maybeAssociateNode(callNode);
            }
            this.visitChildren(callNode);
        }

        @Override
        protected void visitCallParamContentNode(CallParamContentNode node) {
            this.visitRenderUnitNode(node);
        }

        @Override
        protected void visitLetContentNode(LetContentNode node) {
            this.visitRenderUnitNode(node);
        }

        private void visitRenderUnitNode(SoyNode.RenderUnitNode node) {
            switch (InferenceEngine.this.autoescapeMode) {
                case CONTEXTUAL: {
                    if (node.getContentKind() == null) {
                        this.inferInContextualModeForHtml(node);
                        break;
                    }
                    this.inferInStrictMode(node);
                    break;
                }
                case STRICT: {
                    this.inferInStrictMode(node);
                    break;
                }
            }
        }

        @Override
        protected void visitIfNode(IfNode ifNode) {
            this.propagateAcrossDisjunction(ifNode);
        }

        @Override
        protected void visitSwitchNode(SwitchNode switchNode) {
            this.propagateAcrossDisjunction(switchNode);
        }

        @Override
        protected void visitForeachNode(ForeachNode foreachNode) {
            ForeachIfemptyNode ieNode;
            List foreachChildren = foreachNode.getChildren();
            ForeachNonemptyNode neNode = (ForeachNonemptyNode)foreachChildren.get(0);
            if (foreachChildren.size() == 2) {
                ieNode = (ForeachIfemptyNode)foreachChildren.get(1);
            } else if (foreachChildren.size() == 1) {
                ieNode = null;
            } else {
                throw new AssertionError();
            }
            try {
                Context ifemptyContext;
                Optional<Context> combined;
                Context afterBody = this.context;
                if (neNode != null) {
                    afterBody = InferenceEngine.this.infer(neNode, this.context);
                    Context elseContext = InferenceEngine.this.infer(neNode, afterBody);
                    combined = Context.union(elseContext, afterBody);
                    if (!combined.isPresent()) {
                        throw SoyAutoescapeException.createWithNode("{" + foreachNode.getCommandName() + "} body does not end in the same context after repeated entries.", foreachNode);
                    }
                    afterBody = (Context)combined.get();
                }
                if (!(combined = Context.union(ifemptyContext = ieNode != null ? InferenceEngine.this.infer(ieNode, this.context) : this.context, afterBody)).isPresent()) {
                    throw SoyAutoescapeException.createWithNode("{" + foreachNode.getCommandName() + "} body " + (ieNode == null ? "changes context." : "does not end in the same context as {ifempty}."), ieNode == null ? foreachNode : ieNode);
                }
                this.context = (Context)combined.get();
            }
            catch (SoyAutoescapeException ex) {
                throw ex.maybeAssociateNode(foreachNode);
            }
        }

        @Override
        protected void visitPrintNode(PrintNode printNode) {
            try {
                if (InferenceEngine.this.autoescapeMode == AutoescapeMode.STRICT && this.context.state != HtmlContext.TEXT) {
                    for (PrintDirectiveNode printDirective : printNode.getChildren()) {
                        if (printDirective.getName().equals("|noAutoescape")) {
                            if (InferenceEngine.this.templateAutoescapeMode != AutoescapeMode.STRICT) continue;
                            SanitizedContentKind recommendedKind = this.context.getMostAppropriateContentKind();
                            String recommendedKindStr = recommendedKind == SanitizedContentKind.TEXT ? "appropriate kind=\"...\"" : "kind=\"" + recommendedKind.asAttributeValue() + "\"";
                            throw SoyAutoescapeException.createWithNode("noAutoescape is not allowed in strict autoescaping mode. Instead, pass in a {param} with " + recommendedKindStr + " or SanitizedContent.", printNode);
                        }
                        if (printDirective.getPrintDirective() == null || !printDirective.getPrintDirective().shouldCancelAutoescape()) continue;
                        throw SoyAutoescapeException.createWithNode("Autoescape-cancelling print directives like " + printDirective.getName() + " are only allowed in kind=\"text\" blocks. If you really want to over-escape, try using a let block: {let $foo kind=\"text\"}" + printNode.toSourceString() + "{/let}{$foo}.", printNode);
                    }
                }
                ImmutableList<EscapingMode> escapingModes = InferenceEngine.this.inferences.getEscapingMode(printNode);
                Context prev = this.context;
                this.context = this.context.getContextBeforeDynamicValue();
                if (escapingModes.isEmpty()) {
                    ImmutableList<EscapingMode> escapingModesToSet = null;
                    switch (InferenceEngine.this.autoescapeMode) {
                        case CONTEXTUAL: 
                        case STRICT: {
                            escapingModes = escapingModesToSet = this.context.getEscapingModes(printNode.getChildren());
                            break;
                        }
                        case NONCONTEXTUAL: {
                            escapingModes = ImmutableList.of((Object)((Object)InferenceEngine.this.defaultEscapingMode));
                        }
                    }
                    InferenceEngine.this.inferences.setEscapingDirectives(printNode, prev, (List<EscapingMode>)escapingModesToSet);
                } else if (!this.context.isCompatibleWith((EscapingMode)((Object)escapingModes.get(0)))) {
                    String msg = String.format("Escaping modes %s not compatible with %s.", escapingModes, this.context);
                    throw SoyAutoescapeException.createWithNode(msg, printNode);
                }
                this.context = !escapingModes.isEmpty() || InferenceEngine.this.autoescapeMode == AutoescapeMode.CONTEXTUAL || InferenceEngine.this.autoescapeMode == AutoescapeMode.STRICT ? InferenceEngine.getContextAfterEscaping(printNode, this.context) : RawTextContextUpdater.processRawText(new RawTextNode(-1, "z", printNode.getSourceLocation()), this.context);
            }
            catch (SoyAutoescapeException ex) {
                throw ex.maybeAssociateNode(printNode);
            }
        }

        @Override
        protected void visitHtmlOpenTagNode(HtmlOpenTagNode node) {
            this.visitHtmlTagNode(node);
        }

        @Override
        protected void visitHtmlCloseTagNode(HtmlCloseTagNode node) {
            this.visitHtmlTagNode(node);
        }

        @Override
        protected void visitHtmlCommentNode(HtmlCommentNode node) {
            this.context = this.context.transitionToState(HtmlContext.HTML_COMMENT);
            this.visitChildren(node);
            this.context = this.context.transitionToState(HtmlContext.HTML_PCDATA);
        }

        private void visitHtmlTagNode(HtmlTagNode tag) {
            this.context = this.context.transitionToState(tag.getKind() == SoyNode.Kind.HTML_OPEN_TAG_NODE ? HtmlContext.HTML_BEFORE_OPEN_TAG_NAME : HtmlContext.HTML_BEFORE_CLOSE_TAG_NAME);
            if (tag.getTagName().isStatic()) {
                this.context = this.context.transitionToTagName(tag.getTagName().getStaticTagNameAsLowerCase());
            } else {
                this.visit((SoyNode)tag.getChild(0));
            }
            Preconditions.checkArgument((this.context.elType != Context.ElementType.NONE ? 1 : 0) != 0);
            this.context = this.context.transitionToTagBody();
            for (int i = 1; i < tag.numChildren(); ++i) {
                this.visit((SoyNode)tag.getChild(i));
            }
            this.context = this.context.transitionToAfterTag();
        }

        @Override
        protected void visitHtmlAttributeNode(HtmlAttributeNode node) {
            Node first = node.getChild(0);
            if (first.getKind() == SoyNode.Kind.RAW_TEXT_NODE) {
                this.context = this.context.transitionToAttrName(((RawTextNode)first).getRawText());
            } else {
                this.visit((SoyNode)first);
            }
            if (node.hasValue()) {
                this.visit((SoyNode)node.getChild(1));
            }
            this.context = this.context.transitionToTagBody();
        }

        @Override
        protected void visitHtmlAttributeValueNode(HtmlAttributeValueNode node) {
            Context.AttributeEndDelimiter delim;
            this.context = this.context.transitionToState(HtmlContext.HTML_BEFORE_ATTRIBUTE_VALUE);
            switch (node.getQuotes()) {
                case DOUBLE: {
                    delim = Context.AttributeEndDelimiter.DOUBLE_QUOTE;
                    break;
                }
                case NONE: {
                    delim = Context.AttributeEndDelimiter.SPACE_OR_TAG_END;
                    break;
                }
                case SINGLE: {
                    delim = Context.AttributeEndDelimiter.SINGLE_QUOTE;
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            this.context = this.context.transitionToAttrValue(delim);
            this.visitChildren(node);
            this.context = this.context.transitionToTagBody();
        }

        @Override
        protected void visitSoyNode(SoyNode node) {
            if (node instanceof SoyNode.ParentSoyNode) {
                this.visitChildren((SoyNode.ParentSoyNode)node);
            }
        }

        private SanitizedContentKind getCommonContentKindIfStrict(List<TemplateNode> templates) {
            if (templates == null || templates.isEmpty()) {
                return null;
            }
            SanitizedContentKind contentKind = templates.get(0).getContentKind();
            for (TemplateNode template : templates) {
                Preconditions.checkArgument((template.getContentKind() == contentKind ? 1 : 0) != 0);
            }
            return contentKind;
        }

        private DerivedNameAndContext inferCallSite(CallNode callNode, Context startContext, String templateName, Inferences inferences) {
            inferences.recordTemplateChecked(templateName);
            List<TemplateNode> targets = inferences.lookupTemplates(templateName);
            SanitizedContentKind calleeStrictContentKind = this.getCommonContentKindIfStrict(targets);
            if (InferenceEngine.this.autoescapeMode == AutoescapeMode.STRICT) {
                if (calleeStrictContentKind != null && startContext.isValidStartContextForContentKind(calleeStrictContentKind)) {
                    return DerivedNameAndContext.create(templateName, InferenceEngine.getContextAfterDynamicValue(callNode, startContext));
                }
                if (calleeStrictContentKind != null || targets == null || targets.isEmpty()) {
                    Context callContext = startContext.getContextBeforeDynamicValue();
                    inferences.setEscapingDirectives(callNode, callContext, (List<EscapingMode>)callContext.getEscapingModes((List<PrintDirectiveNode>)ImmutableList.of()));
                    return DerivedNameAndContext.create(templateName, InferenceEngine.getContextAfterDynamicValue(callNode, startContext));
                }
                if (startContext.state == HtmlContext.TEXT) {
                    return this.contextualizeCallee(callNode, startContext, templateName, inferences);
                }
                throw SoyAutoescapeException.createWithNode("Soy strict autoescaping currently forbids calls to non-strict templates, unless the context is kind=\"text\", since there's no guarantee the callee is safe.", callNode);
            }
            if (targets == null || targets.isEmpty()) {
                return DerivedNameAndContext.create(templateName, startContext);
            }
            if (calleeStrictContentKind != null) {
                if (!startContext.isValidStartContextForContentKindLoose(calleeStrictContentKind)) {
                    String msg = String.format("Cannot call strictly autoescaped template %s of kind=\"%s\" from incompatible context %s. Strict templates generate extra code to safely call templates of other content kinds, but non-strict templates do not.", templateName, calleeStrictContentKind.asAttributeValue(), startContext);
                    throw SoyAutoescapeException.createWithNode(msg, callNode);
                }
                return DerivedNameAndContext.create(templateName, startContext);
            }
            return this.contextualizeCallee(callNode, startContext, templateName, inferences);
        }

        private DerivedNameAndContext contextualizeCallee(CallNode callNode, Context startContext, String calleeName, Inferences inferences) {
            String suffix = DerivedTemplateUtils.getSuffix(startContext);
            String baseName = DerivedTemplateUtils.getBaseName(calleeName);
            String newCalleeName = baseName + suffix;
            if (inferences.lookupTemplates(newCalleeName) == null) {
                if (ILLEGAL_RECONTEXTUALIZATIONS.contains((Object)startContext.state)) {
                    throw SoyAutoescapeException.createWithNode("Attempting to call non-strict template '" + baseName + "' in context '" + (Object)((Object)startContext.state) + "'.  This is no longer allowed, please migrate the callee to strict and specify a content kind by adding a kind=\"(html|attributes|js|css|uri)\" attribute to the callee", callNode);
                }
                inferences.cloneTemplates(baseName, newCalleeName, callNode);
            }
            try {
                Context endContext = this.determineContextualization(startContext, newCalleeName, inferences);
                return DerivedNameAndContext.create(newCalleeName, endContext);
            }
            catch (SoyAutoescapeException e) {
                throw SoyAutoescapeException.createCausedWithNode("Error while re-contextualizing template " + calleeName + " in context " + startContext + ":", e, callNode);
            }
        }

        private Context determineContextualization(Context startContext, String calleeName, Inferences inferences) {
            Context endContext = inferences.getTemplateEndContext(calleeName);
            if (endContext != null) {
                return endContext;
            }
            List<TemplateNode> templateNodes = inferences.lookupTemplates(calleeName);
            InferencesAndContext hypothesis = this.hypothesizeContextualization(startContext, startContext, calleeName, templateNodes, inferences);
            endContext = hypothesis.context();
            Inferences subInferences = hypothesis.inferences();
            if (!endContext.equals(startContext) && subInferences.wasTemplateChecked(calleeName)) {
                InferencesAndContext secondHypothesis = this.hypothesizeContextualization(startContext, endContext, calleeName, templateNodes, inferences);
                Optional<Context> combined = Context.union(secondHypothesis.context(), endContext);
                if (!combined.isPresent()) {
                    throw SoyAutoescapeException.createWithNode("Cannot determine end context for recursive template " + calleeName, templateNodes.get(0));
                }
                endContext = (Context)combined.get();
            }
            subInferences.recordTemplateEndContext(calleeName, endContext);
            subInferences.foldIntoParent();
            return endContext;
        }

        private InferencesAndContext hypothesizeContextualization(Context startContext, Context hypotheticalEndContext, String calleeName, List<TemplateNode> templateNodes, Inferences parentInferences) {
            Inferences inferences = new Inferences(parentInferences);
            ArrayList<Context> endContexts = new ArrayList<Context>();
            inferences.recordTemplateEndContext(calleeName, hypotheticalEndContext);
            for (TemplateNode templateNode : templateNodes) {
                endContexts.add(InferenceEngine.inferTemplateEndContext(templateNode, startContext, inferences, InferenceEngine.this.errorReporter));
            }
            Optional<Context> combined = Context.union(endContexts);
            if (!combined.isPresent()) {
                throw SoyAutoescapeException.createWithNode("Deltemplates diverge when used with deprecated-contextual autoescaping. Based on the call site, assuming these templates all start in " + startContext + ", the different deltemplates end in incompatible contexts: " + Joiner.on((String)", ").join(endContexts), templateNodes.get(0));
            }
            return InferencesAndContext.create(inferences, (Context)combined.get());
        }

        private void propagateAcrossDisjunction(SoyNode.ParentSoyNode<?> node) {
            try {
                Iterator childIt = node.getChildren().iterator();
                SoyNode firstBranch = (SoyNode)childIt.next();
                Context out = InferenceEngine.this.infer(firstBranch, this.context);
                boolean sawElseOrDefault = false;
                while (childIt.hasNext()) {
                    SoyNode branch = (SoyNode)childIt.next();
                    Context brOut = InferenceEngine.this.infer(branch, this.context);
                    Optional<Context> combined = Context.union(out, brOut);
                    if (!combined.isPresent()) {
                        throw SoyAutoescapeException.createWithNode((node instanceof IfNode ? "{if} command branch ends in a different context than preceding branches:" : "{switch} command case ends in a different context than preceding cases:") + " " + branch.toSourceString(), branch);
                    }
                    out = (Context)combined.get();
                    if (!(branch instanceof IfElseNode) && !(branch instanceof SwitchDefaultNode)) continue;
                    sawElseOrDefault = true;
                }
                if (!sawElseOrDefault) {
                    Optional<Context> combined = Context.union(this.context, out);
                    if (!combined.isPresent()) {
                        throw SoyAutoescapeException.createWithNode(node instanceof IfNode ? "{if} command without {else} changes context." : "{switch} command without {default} changes context.", node);
                    }
                    out = (Context)combined.get();
                }
                this.context = out;
            }
            catch (SoyAutoescapeException ex) {
                throw ex.maybeAssociateNode(node);
            }
        }

        private void inferInStrictMode(SoyNode.RenderUnitNode node) {
            InferenceEngine.inferStrictRenderUnitNode(InferenceEngine.this.templateAutoescapeMode, node, InferenceEngine.this.inferences, InferenceEngine.this.errorReporter);
        }

        private void inferInContextualModeForHtml(SoyNode.CommandNode node) {
            Context paramContentNodeEndContext = new InferenceEngine(AutoescapeMode.CONTEXTUAL, InferenceEngine.this.templateAutoescapeMode, InferenceEngine.this.inferences, InferenceEngine.this.errorReporter).inferChildren(node, Context.HTML_PCDATA);
            if (!paramContentNodeEndContext.equals(Context.HTML_PCDATA)) {
                throw SoyAutoescapeException.createWithNode("Blocks should start and end in HTML context.", node);
            }
        }
    }
}

