/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.internal;

import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.base.internal.SanitizedContentKind;
import com.google.template.soy.msgs.internal.MsgUtils;
import com.google.template.soy.passes.BuildAllDependeesMapVisitor;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.HtmlAttributeNode;
import com.google.template.soy.soytree.LetContentNode;
import com.google.template.soy.soytree.MsgFallbackGroupNode;
import com.google.template.soy.soytree.MsgNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SoyTreeUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ExtractMsgVariablesVisitor
extends AbstractSoyNodeVisitor<Void> {
    private List<MsgFallbackGroupNode> msgFbGrpNodes;
    private Map<SoyNode, List<SoyNode>> allDependeesMap;
    private int counter;

    @Override
    public Void exec(SoyNode node) {
        this.msgFbGrpNodes = new ArrayList<MsgFallbackGroupNode>();
        this.visit(node);
        return null;
    }

    @Override
    protected void visitSoyFileSetNode(SoyFileSetNode node) {
        this.counter = 0;
        this.visitChildren(node);
        this.allDependeesMap = new BuildAllDependeesMapVisitor().exec(node);
        IdGenerator nodeIdGen = node.getNearestAncestor(SoyFileSetNode.class).getNodeIdGenerator();
        for (MsgFallbackGroupNode msgFbGrpNode : this.msgFbGrpNodes) {
            this.wrapMsgFallbackGroupNodeHelper(msgFbGrpNode, nodeIdGen);
        }
    }

    @Override
    protected void visitMsgFallbackGroupNode(MsgFallbackGroupNode node) {
        this.msgFbGrpNodes.add(node);
        this.visitChildren(node);
    }

    @Override
    protected void visitSoyNode(SoyNode node) {
        if (node instanceof SoyNode.ParentSoyNode) {
            this.visitChildren((SoyNode.ParentSoyNode)node);
        }
    }

    protected void wrapMsgFallbackGroupNodeHelper(MsgFallbackGroupNode msgFbGrpNode, IdGenerator nodeIdGen) {
        String varName = "msg_" + ++this.counter;
        for (MsgNode msg : msgFbGrpNode.getChildren()) {
            varName = varName + "_" + MsgUtils.computeMsgIdForDualFormat(msg);
        }
        SoyNode.RenderUnitNode container = msgFbGrpNode.getNearestAncestor(SoyNode.RenderUnitNode.class);
        SanitizedContentKind kind = container.getContentKind();
        HtmlAttributeNode containingAttribute = msgFbGrpNode.getNearestAncestor(HtmlAttributeNode.class);
        if (containingAttribute != null && SoyTreeUtils.isDescendantOf(containingAttribute, container)) {
            kind = SanitizedContentKind.TEXT;
        }
        LetContentNode letNode = LetContentNode.forVariable(nodeIdGen.genId(), msgFbGrpNode.getSourceLocation(), varName, kind);
        msgFbGrpNode.getParent().replaceChild(msgFbGrpNode, msgFbGrpNode.makePrintNode(nodeIdGen, letNode.getVar()));
        letNode.addChild(msgFbGrpNode);
        this.insertWrappingLetNode(letNode, this.allDependeesMap.get(msgFbGrpNode));
    }

    private void insertWrappingLetNode(LetContentNode letNode, List<SoyNode> allDependees) {
        int indexUnderNewParent;
        SoyNode.BlockNode newParent;
        SoyNode nearestDependee = allDependees.get(0);
        if (nearestDependee instanceof SoyNode.LocalVarInlineNode) {
            newParent = (SoyNode.BlockNode)nearestDependee.getParent();
            indexUnderNewParent = newParent.getChildIndex(nearestDependee) + 1;
        } else if (nearestDependee instanceof SoyNode.BlockNode) {
            newParent = (SoyNode.BlockNode)nearestDependee;
            indexUnderNewParent = 0;
        } else {
            throw new AssertionError();
        }
        newParent.addChild(indexUnderNewParent, letNode);
    }
}

