/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.dsl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.dsl.Switch;
import javax.annotation.Nullable;

public final class SwitchBuilder {
    private final CodeChunk.WithValue switchOn;
    private final ImmutableList.Builder<Switch.CaseClause> clauses = ImmutableList.builder();
    @Nullable
    private CodeChunk defaultCaseBody;

    SwitchBuilder(CodeChunk.WithValue switchOn) {
        this.switchOn = switchOn;
    }

    public SwitchBuilder case_(ImmutableList<CodeChunk.WithValue> caseLabels, CodeChunk body) {
        Preconditions.checkState((!caseLabels.isEmpty() ? 1 : 0) != 0, (Object)"at least one case required");
        this.clauses.add((Object)new Switch.CaseClause(caseLabels, body));
        return this;
    }

    public SwitchBuilder default_(CodeChunk body) {
        Preconditions.checkState((this.defaultCaseBody == null ? 1 : 0) != 0);
        this.defaultCaseBody = body;
        return this;
    }

    public CodeChunk build() {
        return Switch.create(this.switchOn, (ImmutableList<Switch.CaseClause>)this.clauses.build(), this.defaultCaseBody);
    }
}

