/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.dsl;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.Immutable;
import com.google.template.soy.jssrc.dsl.AutoValue_LeafStatement;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.dsl.FormattingContext;
import com.google.template.soy.jssrc.dsl.GoogRequire;

@Immutable
abstract class LeafStatement
extends CodeChunk {
    LeafStatement() {
    }

    abstract String value();

    abstract ImmutableSet<GoogRequire> requires();

    static LeafStatement create(String value, Iterable<GoogRequire> requires) {
        while (value.endsWith("\n")) {
            value = value.substring(0, value.length() - 1);
        }
        if (!(value.isEmpty() || value.endsWith("}") || value.endsWith(";"))) {
            value = value + ';';
        }
        return new AutoValue_LeafStatement(value, (ImmutableSet<GoogRequire>)ImmutableSet.copyOf(requires));
    }

    @Override
    void doFormatInitialStatements(FormattingContext ctx) {
        if (this.value().length() == 0) {
            return;
        }
        for (String line : Splitter.on((char)'\n').split((CharSequence)this.value())) {
            ctx.append(line).endLine();
        }
    }

    @Override
    public void collectRequires(CodeChunk.RequiresCollector collector) {
        for (GoogRequire require : this.requires()) {
            collector.add(require);
        }
    }
}

