/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc.runtime;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.data.Dir;
import com.google.template.soy.data.LogStatement;
import com.google.template.soy.data.LoggingAdvisingAppendable;
import com.google.template.soy.data.LoggingFunctionInvocation;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.SoyValueProvider;
import com.google.template.soy.data.UnsafeSanitizedContentOrdainer;
import com.google.template.soy.data.restricted.SoyString;
import com.google.template.soy.data.restricted.StringData;
import com.google.template.soy.jbcsrc.api.RenderResult;
import com.google.template.soy.jbcsrc.runtime.TombstoneValue;
import java.io.IOException;
import javax.annotation.Nullable;

public abstract class DetachableContentProvider
implements SoyValueProvider {
    @Nullable
    private final SanitizedContent.ContentKind contentKind;
    private SoyString resolvedValue;
    private LoggingAdvisingAppendable.BufferingAppendable buffer;
    private LoggingAdvisingAppendable builder;

    protected DetachableContentProvider(@Nullable SanitizedContent.ContentKind contentKind) {
        this.contentKind = contentKind;
    }

    @Override
    public final SoyValue resolve() {
        Preconditions.checkState((boolean)this.isDone(), (Object)"called resolve() before status() returned ready.");
        SoyString local = this.getResolvedValue();
        Preconditions.checkState((local != TombstoneValue.INSTANCE ? 1 : 0) != 0, (Object)"called resolve() after calling renderAndResolve with isLast == true");
        return local;
    }

    @Override
    public final RenderResult status() {
        RenderResult result;
        if (this.isDone()) {
            return RenderResult.done();
        }
        LoggingAdvisingAppendable.BufferingAppendable currentBuilder = (LoggingAdvisingAppendable.BufferingAppendable)this.builder;
        if (currentBuilder == null) {
            currentBuilder = LoggingAdvisingAppendable.buffering();
            this.builder = currentBuilder;
        }
        if ((result = this.doRender(currentBuilder)).isDone()) {
            this.buffer = currentBuilder;
            this.builder = null;
        }
        return result;
    }

    @Override
    public RenderResult renderAndResolve(LoggingAdvisingAppendable appendable, boolean isLast) throws IOException {
        RenderResult result;
        if (this.isDone()) {
            this.buffer.replayOn(appendable);
            return RenderResult.done();
        }
        if (isLast) {
            RenderResult result2 = this.doRender(appendable);
            if (result2.isDone()) {
                this.resolvedValue = TombstoneValue.INSTANCE;
            }
            return result2;
        }
        TeeAdvisingAppendable currentBuilder = (TeeAdvisingAppendable)this.builder;
        if (currentBuilder == null) {
            currentBuilder = new TeeAdvisingAppendable(appendable);
            this.builder = currentBuilder;
        }
        if ((result = this.doRender(currentBuilder)).isDone()) {
            this.buffer = currentBuilder.buffer;
            this.builder = null;
        }
        return result;
    }

    private boolean isDone() {
        return this.resolvedValue != null || this.buffer != null;
    }

    private SoyString getResolvedValue() {
        SoyString local = this.resolvedValue;
        if (local == null) {
            if (this.buffer != null) {
                String string = this.buffer.toString();
                local = this.contentKind != null ? UnsafeSanitizedContentOrdainer.ordainAsSafe(string, this.contentKind) : StringData.forValue(string);
                this.resolvedValue = local;
            } else {
                throw new AssertionError((Object)"getResolvedValue() should only be called if the value isDone.");
            }
        }
        return local;
    }

    protected abstract RenderResult doRender(LoggingAdvisingAppendable var1);

    private static final class TeeAdvisingAppendable
    extends LoggingAdvisingAppendable {
        final LoggingAdvisingAppendable.BufferingAppendable buffer = LoggingAdvisingAppendable.buffering();
        final LoggingAdvisingAppendable delegate;

        TeeAdvisingAppendable(LoggingAdvisingAppendable delegate) {
            this.delegate = delegate;
        }

        @Override
        protected void notifyContentKind(SanitizedContent.ContentKind kind) throws IOException {
            this.delegate.setSanitizedContentKind(kind);
            this.buffer.setSanitizedContentKind(kind);
        }

        @Override
        protected void notifyContentDirectionality(@Nullable Dir contentDir) throws IOException {
            this.delegate.setSanitizedContentDirectionality(contentDir);
            this.buffer.setSanitizedContentDirectionality(contentDir);
        }

        @Override
        public TeeAdvisingAppendable append(CharSequence csq) throws IOException {
            this.delegate.append(csq);
            this.buffer.append(csq);
            return this;
        }

        @Override
        public TeeAdvisingAppendable append(CharSequence csq, int start, int end) throws IOException {
            this.delegate.append(csq, start, end);
            this.buffer.append(csq, start, end);
            return this;
        }

        @Override
        public TeeAdvisingAppendable append(char c) throws IOException {
            this.delegate.append(c);
            this.buffer.append(c);
            return this;
        }

        @Override
        public boolean softLimitReached() {
            return this.delegate.softLimitReached();
        }

        public String toString() {
            return this.buffer.toString();
        }

        @Override
        public LoggingAdvisingAppendable enterLoggableElement(LogStatement statement) {
            this.delegate.enterLoggableElement(statement);
            this.buffer.enterLoggableElement(statement);
            return this;
        }

        @Override
        public LoggingAdvisingAppendable exitLoggableElement() {
            this.delegate.exitLoggableElement();
            this.buffer.exitLoggableElement();
            return this;
        }

        @Override
        public LoggingAdvisingAppendable appendLoggingFunctionInvocation(LoggingFunctionInvocation funCall, ImmutableList<Function<String, String>> escapers) throws IOException {
            this.delegate.appendLoggingFunctionInvocation(funCall, escapers);
            this.buffer.appendLoggingFunctionInvocation(funCall, (ImmutableList)escapers);
            return this;
        }
    }
}

