/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.exprtree;

import com.google.common.base.Preconditions;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.exprtree.AbstractParentExprNode;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.shared.restricted.SoyFunction;

public final class FunctionNode
extends AbstractParentExprNode {
    private final SoyFunction soyFunction;

    public FunctionNode(SoyFunction soyFunction, SourceLocation sourceLocation) {
        super(sourceLocation);
        this.soyFunction = (SoyFunction)Preconditions.checkNotNull((Object)soyFunction);
    }

    private FunctionNode(FunctionNode orig, CopyState copyState) {
        super(orig, copyState);
        this.soyFunction = orig.soyFunction;
    }

    @Override
    public ExprNode.Kind getKind() {
        return ExprNode.Kind.FUNCTION_NODE;
    }

    public String getFunctionName() {
        return this.soyFunction.getName();
    }

    public SoyFunction getSoyFunction() {
        return this.soyFunction;
    }

    @Override
    public String toSourceString() {
        StringBuilder sourceSb = new StringBuilder();
        sourceSb.append(this.getFunctionName()).append('(');
        boolean isFirst = true;
        for (ExprNode child : this.getChildren()) {
            if (isFirst) {
                isFirst = false;
            } else {
                sourceSb.append(", ");
            }
            sourceSb.append(child.toSourceString());
        }
        sourceSb.append(')');
        return sourceSb.toString();
    }

    @Override
    public FunctionNode copy(CopyState copyState) {
        return new FunctionNode(this, copyState);
    }
}

