/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.error;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.ForOverride;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.SoyFileSupplier;
import com.google.template.soy.error.ErrorReporterImpl;
import com.google.template.soy.error.ExplodingErrorReporter;
import com.google.template.soy.error.SoyError;
import com.google.template.soy.error.SoyErrorKind;
import java.util.Map;

public abstract class ErrorReporter {
    public static ErrorReporter create(Map<String, SoyFileSupplier> filePathsToSuppliers) {
        return new ErrorReporterImpl((ImmutableMap<String, SoyFileSupplier>)ImmutableMap.copyOf(filePathsToSuppliers));
    }

    public static ErrorReporter createForTest() {
        return new ErrorReporterImpl((ImmutableMap<String, SoyFileSupplier>)ImmutableMap.of());
    }

    public static ErrorReporter exploding() {
        return ExplodingErrorReporter.EXPLODING;
    }

    public static ErrorReporter explodeOnErrorsAndIgnoreWarnings() {
        return ExplodingErrorReporter.EXPLODING_IGNORE_WARNINGS;
    }

    public abstract void report(SourceLocation var1, SoyErrorKind var2, Object ... var3);

    public abstract void warn(SourceLocation var1, SoyErrorKind var2, Object ... var3);

    public final Checkpoint checkpoint() {
        return new Checkpoint(this, this.getCurrentNumberOfErrors());
    }

    public final boolean errorsSince(Checkpoint checkpoint) {
        Checkpoint impl = checkpoint;
        if (impl.owner != this) {
            throw new IllegalArgumentException("Can only call errorsSince on a Checkpoint instance that was returned from this same reporter");
        }
        return this.getCurrentNumberOfErrors() > impl.errorsSoFar;
    }

    public final boolean hasErrors() {
        return this.getCurrentNumberOfErrors() != 0;
    }

    @ForOverride
    abstract int getCurrentNumberOfErrors();

    public abstract ImmutableList<SoyError> getErrors();

    public abstract ImmutableList<SoyError> getWarnings();

    public static final class Checkpoint {
        private final ErrorReporter owner;
        private final int errorsSoFar;

        private Checkpoint(ErrorReporter owner, int errorsSoFar) {
            this.owner = owner;
            this.errorsSoFar = errorsSoFar;
        }
    }
}

