/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.data.internal;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.template.soy.data.LoggingAdvisingAppendable;
import com.google.template.soy.data.SoyAbstractValue;
import com.google.template.soy.data.SoyDataException;
import com.google.template.soy.data.SoyDict;
import com.google.template.soy.data.SoyNewMap;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.SoyValueProvider;
import com.google.template.soy.data.internal.Transforms;
import com.google.template.soy.data.restricted.StringData;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public final class DictImpl
extends SoyAbstractValue
implements SoyDict,
SoyNewMap {
    protected final Map<String, ? extends SoyValueProvider> providerMap;
    private RuntimeMapType mapType;

    public static DictImpl forProviderMap(Map<String, ? extends SoyValueProvider> providerMap) {
        return new DictImpl(providerMap);
    }

    private DictImpl(Map<String, ? extends SoyValueProvider> providerMap) {
        this.providerMap = (Map)Preconditions.checkNotNull(providerMap);
        this.mapType = RuntimeMapType.UNKNOWN;
    }

    @Override
    public final boolean hasField(String name) {
        return this.providerMap.containsKey(name);
    }

    @Override
    public final SoyValue getField(String name) {
        SoyValueProvider provider = this.providerMap.get(name);
        return provider != null ? provider.resolve() : null;
    }

    @Override
    public final SoyValueProvider getFieldProvider(String name) {
        return this.providerMap.get(name);
    }

    @Override
    public final int getItemCnt() {
        this.maybeSetLegacyObjectMapType();
        return this.providerMap.size();
    }

    @Override
    public int size() {
        this.maybeSetMapType();
        return this.providerMap.size();
    }

    @Override
    @Nonnull
    public final Iterable<? extends SoyValue> getItemKeys() {
        this.maybeSetLegacyObjectMapType();
        return Iterables.transform(this.providerMap.keySet(), (Function)new Function<String, SoyValue>(){

            public SoyValue apply(String key) {
                return StringData.forValue(key);
            }
        });
    }

    @Override
    @Nonnull
    public Iterable<? extends SoyValue> keys() {
        this.maybeSetMapType();
        return Iterables.transform(this.providerMap.keySet(), (Function)new Function<String, SoyValue>(){

            public SoyValue apply(String key) {
                return StringData.forValue(key);
            }
        });
    }

    @Override
    public final boolean hasItem(SoyValue key) {
        this.maybeSetLegacyObjectMapType();
        return this.providerMap.containsKey(this.getStringKey(key));
    }

    @Override
    public boolean containsKey(SoyValue key) {
        this.maybeSetMapType();
        return this.providerMap.containsKey(this.getStringKey(key));
    }

    @Override
    public final SoyValue getItem(SoyValue key) {
        this.maybeSetLegacyObjectMapType();
        return this.getField(this.getStringKey(key));
    }

    @Override
    public SoyValue get(SoyValue key) {
        this.maybeSetMapType();
        return this.getField(this.getStringKey(key));
    }

    @Override
    public final SoyValueProvider getItemProvider(SoyValue key) {
        this.maybeSetLegacyObjectMapType();
        return this.providerMap.get(this.getStringKey(key));
    }

    @Override
    public SoyValueProvider getProvider(SoyValue key) {
        this.maybeSetMapType();
        return this.providerMap.get(this.getStringKey(key));
    }

    @Override
    @Nonnull
    public final Map<String, ? extends SoyValueProvider> asJavaStringMap() {
        return Collections.unmodifiableMap(this.providerMap);
    }

    @Override
    @Nonnull
    public final Map<String, ? extends SoyValue> asResolvedJavaStringMap() {
        return Maps.transformValues(this.asJavaStringMap(), Transforms.RESOLVE_FUNCTION);
    }

    protected final String getStringKey(SoyValue key) {
        try {
            return key.stringValue();
        }
        catch (SoyDataException e) {
            throw new SoyDataException("SoyDict accessed with non-string key (got key type " + key.getClass().getName() + ").");
        }
    }

    @Override
    public final boolean coerceToBoolean() {
        return true;
    }

    @Override
    public final String coerceToString() {
        LoggingAdvisingAppendable.BufferingAppendable mapStr = LoggingAdvisingAppendable.buffering();
        try {
            this.render(mapStr);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        return ((Object)mapStr).toString();
    }

    @Override
    public void render(LoggingAdvisingAppendable appendable) throws IOException {
        appendable.append('{');
        boolean isFirst = true;
        boolean useNewSoyMap = this.mapType == RuntimeMapType.MAP;
        for (SoyValue soyValue : useNewSoyMap ? this.keys() : this.getItemKeys()) {
            SoyValue value;
            SoyValue soyValue2 = value = useNewSoyMap ? this.get(soyValue) : this.getItem(soyValue);
            if (isFirst) {
                isFirst = false;
            } else {
                appendable.append(", ");
            }
            soyValue.render(appendable);
            appendable.append(": ");
            value.render(appendable);
        }
        appendable.append('}');
    }

    @Override
    public final boolean equals(Object other) {
        return this == other;
    }

    public final int hashCode() {
        return System.identityHashCode(this);
    }

    public String toString() {
        return this.coerceToString();
    }

    private void maybeSetLegacyObjectMapType() {
        if (this.mapType == RuntimeMapType.UNKNOWN) {
            this.mapType = RuntimeMapType.LEGACY_OBJECT_MAP;
        } else if (this.mapType == RuntimeMapType.MAP) {
            throw new IllegalStateException("Expected a value of type `map`, got `legacy_object_map`. These two map types are not interoperable.");
        }
    }

    private void maybeSetMapType() {
        if (this.mapType == RuntimeMapType.UNKNOWN) {
            this.mapType = RuntimeMapType.MAP;
        } else if (this.mapType == RuntimeMapType.LEGACY_OBJECT_MAP) {
            throw new IllegalStateException("Expected a value of type `legacy_object_map`, got `map`. These two map types are not interoperable.");
        }
    }

    private static enum RuntimeMapType {
        UNKNOWN,
        LEGACY_OBJECT_MAP,
        MAP;

    }
}

