/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.data;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.BaseEncoding;
import com.google.inject.Inject;
import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ProtocolMessageEnum;
import com.google.template.soy.data.SoyAbstractCachingValueProvider;
import com.google.template.soy.data.SoyCustomValueConverter;
import com.google.template.soy.data.SoyDataException;
import com.google.template.soy.data.SoyDict;
import com.google.template.soy.data.SoyEasyList;
import com.google.template.soy.data.SoyFutureValueProvider;
import com.google.template.soy.data.SoyGlobalsValue;
import com.google.template.soy.data.SoyList;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.SoyValueProvider;
import com.google.template.soy.data.internal.DictImpl;
import com.google.template.soy.data.internal.EasyListImpl;
import com.google.template.soy.data.internal.ListImpl;
import com.google.template.soy.data.internal.SoyMapImpl;
import com.google.template.soy.data.restricted.BooleanData;
import com.google.template.soy.data.restricted.FloatData;
import com.google.template.soy.data.restricted.IntegerData;
import com.google.template.soy.data.restricted.NullData;
import com.google.template.soy.data.restricted.StringData;
import com.google.template.soy.jbcsrc.api.RenderResult;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class SoyValueConverter {
    public static final SoyValueConverter UNCUSTOMIZED_INSTANCE = new SoyValueConverter();
    public static final SoyDict EMPTY_DICT = DictImpl.forProviderMap((Map<String, ? extends SoyValueProvider>)ImmutableMap.of());
    public static final SoyList EMPTY_LIST = ListImpl.forProviderList((ImmutableList<? extends SoyValueProvider>)ImmutableList.of());
    public static final SoyMapImpl EMPTY_MAP = SoyMapImpl.forProviderMap((Map<String, ? extends SoyValueProvider>)ImmutableMap.of());
    @Inject(optional=true)
    private List<SoyCustomValueConverter> customValueConverters;

    @Inject
    SoyValueConverter() {
    }

    public SoyDict newDictFromMap(Map<String, ?> javaStringMap) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<String, ?> entry : javaStringMap.entrySet()) {
            builder.put((Object)entry.getKey(), (Object)this.convertLazy(entry.getValue()));
        }
        return DictImpl.forProviderMap((Map<String, ? extends SoyValueProvider>)builder.build());
    }

    @Deprecated
    public SoyEasyList newEasyListFromList(SoyList list) {
        EasyListImpl result = new EasyListImpl();
        for (SoyValueProvider soyValueProvider : list.asJavaList()) {
            result.add(soyValueProvider);
        }
        return result;
    }

    private SoyList newListFromIterable(Iterable<?> items) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Object item : items) {
            builder.add((Object)this.convertLazy(item));
        }
        return ListImpl.forProviderList((ImmutableList<? extends SoyValueProvider>)builder.build());
    }

    @Nonnull
    public SoyValueProvider convert(@Nullable Object obj) {
        SoyValueProvider convertedPrimitive = this.convertPrimitive(obj);
        if (convertedPrimitive != null) {
            return convertedPrimitive;
        }
        if (obj instanceof Map) {
            Map objCast = (Map)obj;
            return this.newDictFromMap(objCast);
        }
        if (obj instanceof Collection || obj instanceof FluentIterable) {
            return this.newListFromIterable((Iterable)obj);
        }
        if (obj instanceof SoyGlobalsValue) {
            return this.convert(((SoyGlobalsValue)obj).getSoyGlobalValue());
        }
        if (obj instanceof ByteString) {
            return StringData.forValue(BaseEncoding.base64().encode(((ByteString)obj).toByteArray()));
        }
        if (obj instanceof Descriptors.EnumValueDescriptor) {
            return IntegerData.forValue(((Descriptors.EnumValueDescriptor)obj).getNumber());
        }
        if (obj instanceof ProtocolMessageEnum) {
            return IntegerData.forValue(((ProtocolMessageEnum)obj).getNumber());
        }
        if (this.customValueConverters != null) {
            for (SoyCustomValueConverter customConverter : this.customValueConverters) {
                SoyValueProvider result = customConverter.convert(this, obj);
                if (result == null) continue;
                return result;
            }
        }
        throw new SoyDataException("Attempting to convert unrecognized object to Soy value (object type " + obj.getClass().getName() + ").");
    }

    private SoyValueProvider convertLazy(final @Nullable Object obj) {
        SoyValueProvider convertedPrimitive = this.convertPrimitive(obj);
        if (convertedPrimitive != null) {
            return convertedPrimitive;
        }
        return new SoyAbstractCachingValueProvider(){

            @Override
            protected SoyValue compute() {
                return SoyValueConverter.this.convert(obj).resolve();
            }

            @Override
            public RenderResult status() {
                return RenderResult.done();
            }
        };
    }

    @Nullable
    private SoyValueProvider convertPrimitive(@Nullable Object obj) {
        if (obj == null) {
            return NullData.INSTANCE;
        }
        if (obj instanceof SoyValueProvider) {
            return (SoyValueProvider)obj;
        }
        if (obj instanceof String) {
            return StringData.forValue((String)obj);
        }
        if (obj instanceof Boolean) {
            return BooleanData.forValue((Boolean)obj);
        }
        if (obj instanceof Number) {
            if (obj instanceof Integer) {
                return IntegerData.forValue(((Integer)obj).intValue());
            }
            if (obj instanceof Long) {
                return IntegerData.forValue((Long)obj);
            }
            if (obj instanceof Double) {
                return FloatData.forValue((Double)obj);
            }
            if (obj instanceof Float) {
                return FloatData.forValue(((Float)obj).floatValue());
            }
        } else if (obj instanceof Future) {
            return new SoyFutureValueProvider(this, (Future)obj);
        }
        return null;
    }
}

