/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.bidifunctions;

import com.google.common.collect.ImmutableSet;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.restricted.IntegerData;
import com.google.template.soy.exprtree.Operator;
import com.google.template.soy.internal.i18n.BidiGlobalDir;
import com.google.template.soy.jbcsrc.restricted.BytecodeUtils;
import com.google.template.soy.jbcsrc.restricted.Expression;
import com.google.template.soy.jbcsrc.restricted.JbcSrcPluginContext;
import com.google.template.soy.jbcsrc.restricted.MethodRef;
import com.google.template.soy.jbcsrc.restricted.SoyExpression;
import com.google.template.soy.jbcsrc.restricted.SoyJbcSrcFunction;
import com.google.template.soy.jssrc.restricted.JsExpr;
import com.google.template.soy.jssrc.restricted.SoyLibraryAssistedJsSrcFunction;
import com.google.template.soy.pysrc.restricted.PyExpr;
import com.google.template.soy.pysrc.restricted.PyExprUtils;
import com.google.template.soy.pysrc.restricted.SoyPySrcFunction;
import com.google.template.soy.shared.restricted.SoyJavaFunction;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.objectweb.asm.Type;

@Singleton
final class BidiGlobalDirFunction
implements SoyJavaFunction,
SoyLibraryAssistedJsSrcFunction,
SoyPySrcFunction,
SoyJbcSrcFunction {
    private final Provider<BidiGlobalDir> bidiGlobalDirProvider;

    @Inject
    BidiGlobalDirFunction(Provider<BidiGlobalDir> bidiGlobalDirProvider) {
        this.bidiGlobalDirProvider = bidiGlobalDirProvider;
    }

    @Override
    public String getName() {
        return "bidiGlobalDir";
    }

    @Override
    public Set<Integer> getValidArgsSizes() {
        return ImmutableSet.of((Object)0);
    }

    @Override
    public SoyValue computeForJava(List<SoyValue> args) {
        return IntegerData.forValue(((BidiGlobalDir)this.bidiGlobalDirProvider.get()).getStaticValue());
    }

    @Override
    public SoyExpression computeForJbcSrc(JbcSrcPluginContext context, List<SoyExpression> args) {
        return SoyExpression.forInt(BytecodeUtils.numericConversion(context.getBidiGlobalDir().invoke(JbcSrcMethods.GET_STATIC_VALUE, new Expression[0]), Type.LONG_TYPE));
    }

    @Override
    public JsExpr computeForJsSrc(List<JsExpr> args) {
        BidiGlobalDir bidiGlobalDir = (BidiGlobalDir)this.bidiGlobalDirProvider.get();
        return new JsExpr(bidiGlobalDir.getCodeSnippet(), bidiGlobalDir.isStaticValue() ? Integer.MAX_VALUE : Operator.CONDITIONAL.getPrecedence());
    }

    @Override
    public ImmutableSet<String> getRequiredJsLibNames() {
        return ImmutableSet.copyOf((Collection)((BidiGlobalDir)this.bidiGlobalDirProvider.get()).getNamespace().asSet());
    }

    @Override
    public PyExpr computeForPySrc(List<PyExpr> args) {
        return new PyExpr(((BidiGlobalDir)this.bidiGlobalDirProvider.get()).getCodeSnippet(), PyExprUtils.pyPrecedenceForOperator(Operator.CONDITIONAL));
    }

    private static final class JbcSrcMethods {
        static final MethodRef GET_STATIC_VALUE = MethodRef.create(BidiGlobalDir.class, "getStaticValue", new Class[0]).asCheap();

        private JbcSrcMethods() {
        }
    }
}

