/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.basicfunctions;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.template.soy.basicfunctions.BasicFunctionsRuntime;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.exprtree.Operator;
import com.google.template.soy.internal.targetexpr.TargetExpr;
import com.google.template.soy.jbcsrc.restricted.BytecodeUtils;
import com.google.template.soy.jbcsrc.restricted.JbcSrcPluginContext;
import com.google.template.soy.jbcsrc.restricted.MethodRef;
import com.google.template.soy.jbcsrc.restricted.SoyExpression;
import com.google.template.soy.jbcsrc.restricted.SoyJbcSrcFunction;
import com.google.template.soy.jssrc.dsl.SoyJsPluginUtils;
import com.google.template.soy.jssrc.restricted.JsExpr;
import com.google.template.soy.jssrc.restricted.SoyJsSrcFunction;
import com.google.template.soy.pysrc.restricted.PyExpr;
import com.google.template.soy.pysrc.restricted.SoyPySrcFunction;
import com.google.template.soy.shared.restricted.SoyJavaFunction;
import com.google.template.soy.shared.restricted.SoyPureFunction;
import com.google.template.soy.types.SoyTypes;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.objectweb.asm.Type;

@Singleton
@SoyPureFunction
public final class RoundFunction
implements SoyJavaFunction,
SoyJsSrcFunction,
SoyPySrcFunction,
SoyJbcSrcFunction {
    @Inject
    public RoundFunction() {
    }

    @Override
    public String getName() {
        return "round";
    }

    @Override
    public Set<Integer> getValidArgsSizes() {
        return ImmutableSet.of((Object)1, (Object)2);
    }

    @Override
    public SoyValue computeForJava(List<SoyValue> args) {
        SoyValue value = args.get(0);
        int numDigitsAfterPt = args.size() == 2 ? args.get(1).integerValue() : 0;
        return BasicFunctionsRuntime.round(value, numDigitsAfterPt);
    }

    @Override
    public JsExpr computeForJsSrc(List<JsExpr> args) {
        JsExpr value = args.get(0);
        JsExpr numDigitsAfterPt = args.size() == 2 ? args.get(1) : null;
        int numDigitsAfterPtAsInt = RoundFunction.convertNumDigits(numDigitsAfterPt);
        if (numDigitsAfterPtAsInt == 0) {
            return new JsExpr("Math.round(" + value.getText() + ")", Integer.MAX_VALUE);
        }
        if (numDigitsAfterPtAsInt >= 0 && numDigitsAfterPtAsInt <= 12 || numDigitsAfterPtAsInt == Integer.MIN_VALUE) {
            String shiftExprText = numDigitsAfterPtAsInt >= 0 && numDigitsAfterPtAsInt <= 12 ? "1" + "000000000000".substring(0, numDigitsAfterPtAsInt) : "Math.pow(10, " + numDigitsAfterPt.getText() + ")";
            JsExpr shift = new JsExpr(shiftExprText, Integer.MAX_VALUE);
            JsExpr valueTimesShift = SoyJsPluginUtils.genJsExprUsingSoySyntax(Operator.TIMES, Lists.newArrayList((Object[])new JsExpr[]{value, shift}));
            return new JsExpr("Math.round(" + valueTimesShift.getText() + ") / " + shift.getText(), Operator.DIVIDE_BY.getPrecedence());
        }
        if (numDigitsAfterPtAsInt < 0 && numDigitsAfterPtAsInt >= -12) {
            String shiftExprText = "1" + "000000000000".substring(0, -numDigitsAfterPtAsInt);
            JsExpr shift = new JsExpr(shiftExprText, Integer.MAX_VALUE);
            JsExpr valueDivideByShift = SoyJsPluginUtils.genJsExprUsingSoySyntax(Operator.DIVIDE_BY, Lists.newArrayList((Object[])new JsExpr[]{value, shift}));
            return new JsExpr("Math.round(" + valueDivideByShift.getText() + ") * " + shift.getText(), Operator.TIMES.getPrecedence());
        }
        throw new IllegalArgumentException("Second argument to round() function is " + numDigitsAfterPtAsInt + ", which is too large in magnitude.");
    }

    @Override
    public PyExpr computeForPySrc(List<PyExpr> args) {
        boolean isLiteral;
        PyExpr value = args.get(0);
        PyExpr precision = args.size() == 2 ? args.get(1) : null;
        int precisionAsInt = RoundFunction.convertNumDigits(precision);
        boolean bl = isLiteral = precisionAsInt != Integer.MIN_VALUE;
        if (precisionAsInt >= -12 && precisionAsInt <= 12 || !isLiteral) {
            String floatBreakdown = "math.frexp(" + value.getText() + ")";
            String precisionValue = isLiteral ? precisionAsInt + "" : precision.getText();
            StringBuilder roundedValue = new StringBuilder("round(").append('(').append(floatBreakdown).append("[0]").append(" + sys.float_info.epsilon)*2**").append(floatBreakdown).append("[1]").append(", ").append(precisionValue).append(")");
            return new PyExpr("runtime.simplify_num(" + roundedValue + ", " + precisionValue + ")", Integer.MAX_VALUE);
        }
        throw new IllegalArgumentException("Second argument to round() function is " + precisionAsInt + ", which is too large in magnitude.");
    }

    private static int convertNumDigits(TargetExpr numDigitsAfterPt) {
        int numDigitsAfterPtAsInt = 0;
        if (numDigitsAfterPt != null) {
            try {
                numDigitsAfterPtAsInt = Integer.parseInt(numDigitsAfterPt.getText());
            }
            catch (NumberFormatException nfe) {
                numDigitsAfterPtAsInt = Integer.MIN_VALUE;
            }
        }
        return numDigitsAfterPtAsInt;
    }

    @Override
    public SoyExpression computeForJbcSrc(JbcSrcPluginContext context, List<SoyExpression> args) {
        if (args.size() == 1) {
            return this.invokeRoundFunction(args.get(0));
        }
        return this.invokeRoundFunction(args.get(0), args.get(1));
    }

    private SoyExpression invokeRoundFunction(SoyExpression soyExpression) {
        if (soyExpression.assignableToNullableInt()) {
            return soyExpression;
        }
        if (soyExpression.assignableToNullableFloat()) {
            return SoyExpression.forInt(JbcSrcMethods.MATH_ROUND.invoke(soyExpression.unboxAs(Double.TYPE)));
        }
        return SoyExpression.forInt(JbcSrcMethods.ROUND_FN.invoke(soyExpression.box()));
    }

    private SoyExpression invokeRoundFunction(SoyExpression value, SoyExpression digitsAfterPoint) {
        return SoyExpression.forSoyValue(SoyTypes.NUMBER_TYPE, JbcSrcMethods.ROUND_WITH_NUM_DIGITS_AFTER_POINT_FN.invoke(value.box(), BytecodeUtils.numericConversion(digitsAfterPoint.unboxAs(Long.TYPE), Type.INT_TYPE)));
    }

    private static final class JbcSrcMethods {
        static final MethodRef MATH_ROUND = MethodRef.create(Math.class, "round", Double.TYPE).asCheap();
        static final MethodRef ROUND_FN = MethodRef.create(BasicFunctionsRuntime.class, "round", SoyValue.class).asNonNullable();
        static final MethodRef ROUND_WITH_NUM_DIGITS_AFTER_POINT_FN = MethodRef.create(BasicFunctionsRuntime.class, "round", SoyValue.class, Integer.TYPE).asNonNullable();

        private JbcSrcMethods() {
        }
    }
}

