/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.basicfunctions;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.template.soy.basicfunctions.BasicFunctionsRuntime;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.internal.SoyMapImpl;
import com.google.template.soy.jbcsrc.restricted.JbcSrcPluginContext;
import com.google.template.soy.jbcsrc.restricted.MethodRef;
import com.google.template.soy.jbcsrc.restricted.SoyExpression;
import com.google.template.soy.jbcsrc.restricted.SoyJbcSrcFunction;
import com.google.template.soy.jssrc.restricted.JsExpr;
import com.google.template.soy.jssrc.restricted.SoyLibraryAssistedJsSrcFunction;
import com.google.template.soy.pysrc.restricted.PyExpr;
import com.google.template.soy.pysrc.restricted.SoyPySrcFunction;
import com.google.template.soy.shared.restricted.SoyJavaFunction;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.aggregate.LegacyObjectMapType;
import com.google.template.soy.types.aggregate.MapType;
import com.google.template.soy.types.primitive.UnknownType;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;

public final class MapToLegacyObjectMapFunction
implements SoyJavaFunction,
SoyJbcSrcFunction,
SoyPySrcFunction,
SoyLibraryAssistedJsSrcFunction {
    @Inject
    MapToLegacyObjectMapFunction() {
    }

    @Override
    public String getName() {
        return "mapToLegacyObjectMap";
    }

    @Override
    public Set<Integer> getValidArgsSizes() {
        return ImmutableSet.of((Object)1);
    }

    @Override
    public ImmutableSet<String> getRequiredJsLibNames() {
        return ImmutableSet.of((Object)"soy.map");
    }

    @Override
    public SoyExpression computeForJbcSrc(JbcSrcPluginContext context, List<SoyExpression> args) {
        LegacyObjectMapType newType;
        SoyExpression soyExpression = (SoyExpression)Iterables.getOnlyElement(args);
        SoyType originalType = soyExpression.soyRuntimeType().soyType();
        if (originalType instanceof MapType) {
            newType = LegacyObjectMapType.of(((MapType)originalType).getKeyType(), ((MapType)originalType).getValueType());
        } else if (originalType instanceof UnknownType) {
            newType = LegacyObjectMapType.of(UnknownType.getInstance(), UnknownType.getInstance());
        } else {
            throw new IllegalArgumentException("mapToLegacyObjectMap() expects input to be MAP, get " + (Object)((Object)originalType.getKind()));
        }
        return SoyExpression.forLegacyObjectMap(newType, JbcSrcMethods.MAP_TO_LEGACY_OBJECT_MAP.invoke(soyExpression.box().checkedCast(SoyMapImpl.class)));
    }

    @Override
    public JsExpr computeForJsSrc(List<JsExpr> args) {
        return new JsExpr("soy.map.$$mapToLegacyObjectMap(" + args.get(0).getText() + ")", Integer.MAX_VALUE);
    }

    @Override
    public PyExpr computeForPySrc(List<PyExpr> args) {
        return (PyExpr)Iterables.getOnlyElement(args);
    }

    @Override
    public SoyValue computeForJava(List<SoyValue> args) {
        SoyMapImpl map = (SoyMapImpl)Iterables.getOnlyElement(args);
        return BasicFunctionsRuntime.mapToLegacyObjectMap(map);
    }

    private static final class JbcSrcMethods {
        static final MethodRef MAP_TO_LEGACY_OBJECT_MAP = MethodRef.create(BasicFunctionsRuntime.class, "mapToLegacyObjectMap", SoyMapImpl.class);

        private JbcSrcMethods() {
        }
    }
}

