/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.basicfunctions;

import com.google.common.collect.ImmutableSet;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.restricted.FloatData;
import com.google.template.soy.jbcsrc.restricted.BytecodeUtils;
import com.google.template.soy.jbcsrc.restricted.JbcSrcPluginContext;
import com.google.template.soy.jbcsrc.restricted.SoyExpression;
import com.google.template.soy.jbcsrc.restricted.SoyJbcSrcFunction;
import com.google.template.soy.jssrc.restricted.JsExpr;
import com.google.template.soy.jssrc.restricted.SoyJsSrcFunction;
import com.google.template.soy.pysrc.restricted.PyExpr;
import com.google.template.soy.pysrc.restricted.SoyPySrcFunction;
import com.google.template.soy.shared.restricted.SoyJavaFunction;
import com.google.template.soy.shared.restricted.SoyPureFunction;
import java.util.List;
import java.util.Set;
import org.objectweb.asm.Type;

@SoyPureFunction
public final class FloatFunction
implements SoyJavaFunction,
SoyJsSrcFunction,
SoyPySrcFunction,
SoyJbcSrcFunction {
    public static final String NAME = "$$float";
    public static final FloatFunction INSTANCE = new FloatFunction();

    private FloatFunction() {
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Set<Integer> getValidArgsSizes() {
        return ImmutableSet.of((Object)1);
    }

    @Override
    public SoyValue computeForJava(List<SoyValue> args) {
        return FloatData.forValue(args.get(0).longValue());
    }

    @Override
    public JsExpr computeForJsSrc(List<JsExpr> args) {
        return args.get(0);
    }

    @Override
    public PyExpr computeForPySrc(List<PyExpr> args) {
        return args.get(0);
    }

    @Override
    public SoyExpression computeForJbcSrc(JbcSrcPluginContext context, List<SoyExpression> args) {
        SoyExpression arg = args.get(0);
        SoyExpression unboxed = arg.isBoxed() ? arg.unboxAs(Long.TYPE) : arg;
        SoyExpression result = SoyExpression.forFloat(BytecodeUtils.numericConversion(unboxed, Type.DOUBLE_TYPE));
        return arg.isCheap() ? result.asCheap() : result;
    }
}

