/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.basicdirectives;

import com.google.common.base.CaseFormat;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.concurrent.LazyInit;
import com.google.template.soy.data.LoggingAdvisingAppendable;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.restricted.StringData;
import com.google.template.soy.jbcsrc.restricted.Expression;
import com.google.template.soy.jbcsrc.restricted.JbcSrcPluginContext;
import com.google.template.soy.jbcsrc.restricted.MethodRef;
import com.google.template.soy.jbcsrc.restricted.SoyExpression;
import com.google.template.soy.jbcsrc.restricted.SoyJbcSrcPrintDirective;
import com.google.template.soy.jssrc.restricted.JsExpr;
import com.google.template.soy.jssrc.restricted.SoyLibraryAssistedJsSrcPrintDirective;
import com.google.template.soy.pysrc.restricted.PyExpr;
import com.google.template.soy.pysrc.restricted.SoyPySrcPrintDirective;
import com.google.template.soy.shared.internal.ShortCircuitable;
import com.google.template.soy.shared.restricted.Sanitizers;
import com.google.template.soy.shared.restricted.SoyJavaPrintDirective;
import com.google.template.soy.shared.restricted.SoyPurePrintDirective;
import java.util.List;
import java.util.Set;
import javax.inject.Singleton;

public abstract class BasicEscapeDirective
implements SoyJavaPrintDirective,
SoyLibraryAssistedJsSrcPrintDirective,
SoyPySrcPrintDirective,
SoyJbcSrcPrintDirective {
    private static final ImmutableSet<Integer> VALID_ARGS_SIZES = ImmutableSet.of((Object)0);
    private final String name;
    @LazyInit
    private MethodRef javaSoyValueSanitizer;
    @LazyInit
    private MethodRef javaStreamingSanitizer;

    public BasicEscapeDirective(String name) {
        this.name = name;
    }

    protected abstract String escape(SoyValue var1);

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final Set<Integer> getValidArgsSizes() {
        return VALID_ARGS_SIZES;
    }

    @Override
    public final boolean shouldCancelAutoescape() {
        return true;
    }

    protected boolean isCloseable() {
        return false;
    }

    @Override
    public SoyValue applyForJava(SoyValue value, List<SoyValue> args) {
        return StringData.forValue(this.escape(value));
    }

    @Override
    public JsExpr applyForJsSrc(JsExpr value, List<JsExpr> args) {
        return new JsExpr("soy.$$" + this.name.substring(1) + "(" + value.getText() + ")", Integer.MAX_VALUE);
    }

    @Override
    public ImmutableSet<String> getRequiredJsLibNames() {
        return ImmutableSet.of((Object)"soy");
    }

    @Override
    public PyExpr applyForPySrc(PyExpr value, List<PyExpr> args) {
        String pyFnName = CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, this.name.substring(1));
        return new PyExpr("sanitize." + pyFnName + "(" + value.getText() + ")", Integer.MAX_VALUE);
    }

    @Override
    public SoyExpression applyForJbcSrc(JbcSrcPluginContext context, SoyExpression value, List<SoyExpression> args) {
        MethodRef sanitizerMethod = this.javaSoyValueSanitizer;
        if (sanitizerMethod == null) {
            this.javaSoyValueSanitizer = sanitizerMethod = MethodRef.create(Sanitizers.class, this.name.substring(1), SoyValue.class).asNonNullable();
        }
        return SoyExpression.forString(sanitizerMethod.invoke(value.box()));
    }

    public final SoyJbcSrcPrintDirective.Streamable.AppendableAndOptions applyForJbcSrcStreaming(JbcSrcPluginContext context, Expression delegateAppendable, List<SoyExpression> args) {
        MethodRef sanitizerMethod = this.javaStreamingSanitizer;
        if (sanitizerMethod == null) {
            this.javaStreamingSanitizer = sanitizerMethod = MethodRef.create(Sanitizers.class, this.name.substring(1) + "Streaming", LoggingAdvisingAppendable.class).asNonNullable();
        }
        Expression streamingSanitizersExpr = sanitizerMethod.invoke(delegateAppendable);
        if (this.isCloseable()) {
            return SoyJbcSrcPrintDirective.Streamable.AppendableAndOptions.createCloseable(streamingSanitizersExpr);
        }
        return SoyJbcSrcPrintDirective.Streamable.AppendableAndOptions.create(streamingSanitizersExpr);
    }

    @Singleton
    @SoyPurePrintDirective
    static final class FilterTrustedResourceUri
    extends BasicEscapeDirective
    implements ShortCircuitable {
        FilterTrustedResourceUri() {
            super("|filterTrustedResourceUri");
        }

        @Override
        protected String escape(SoyValue value) {
            return Sanitizers.filterTrustedResourceUri(value);
        }

        @Override
        public boolean isNoopForKind(SanitizedContent.ContentKind kind) {
            return kind == SanitizedContent.ContentKind.TRUSTED_RESOURCE_URI;
        }
    }

    @Singleton
    @SoyPurePrintDirective
    static final class EscapeUri
    extends BasicEscapeDirective {
        EscapeUri() {
            super("|escapeUri");
        }

        @Override
        protected String escape(SoyValue value) {
            return Sanitizers.escapeUri(value);
        }
    }

    @Singleton
    @SoyPurePrintDirective
    static final class NormalizeUri
    extends BasicEscapeDirective
    implements SoyJbcSrcPrintDirective.Streamable {
        NormalizeUri() {
            super("|normalizeUri");
        }

        @Override
        protected String escape(SoyValue value) {
            return Sanitizers.normalizeUri(value);
        }
    }

    @Singleton
    @SoyPurePrintDirective
    static final class FilterNormalizeMediaUri
    extends BasicEscapeDirective {
        FilterNormalizeMediaUri() {
            super("|filterNormalizeMediaUri");
        }

        @Override
        protected String escape(SoyValue value) {
            return Sanitizers.filterNormalizeMediaUri(value);
        }
    }

    @Singleton
    @SoyPurePrintDirective
    static final class FilterNormalizeUri
    extends BasicEscapeDirective {
        FilterNormalizeUri() {
            super("|filterNormalizeUri");
        }

        @Override
        protected String escape(SoyValue value) {
            return Sanitizers.filterNormalizeUri(value);
        }
    }

    @Singleton
    @SoyPurePrintDirective
    static final class EscapeJsValue
    extends BasicEscapeDirective
    implements ShortCircuitable {
        EscapeJsValue() {
            super("|escapeJsValue");
        }

        @Override
        protected String escape(SoyValue value) {
            return Sanitizers.escapeJsValue(value);
        }

        @Override
        public boolean isNoopForKind(SanitizedContent.ContentKind kind) {
            return kind == SanitizedContent.ContentKind.JS;
        }
    }

    @Singleton
    @SoyPurePrintDirective
    static final class EscapeJsString
    extends BasicEscapeDirective
    implements SoyJbcSrcPrintDirective.Streamable {
        EscapeJsString() {
            super("|escapeJsString");
        }

        @Override
        protected String escape(SoyValue value) {
            return Sanitizers.escapeJsString(value);
        }
    }

    @Singleton
    @SoyPurePrintDirective
    static final class EscapeJsRegex
    extends BasicEscapeDirective
    implements SoyJbcSrcPrintDirective.Streamable {
        EscapeJsRegex() {
            super("|escapeJsRegex");
        }

        @Override
        protected String escape(SoyValue value) {
            return Sanitizers.escapeJsRegex(value);
        }
    }

    @Singleton
    @SoyPurePrintDirective
    static final class FilterHtmlElementName
    extends BasicEscapeDirective {
        FilterHtmlElementName() {
            super("|filterHtmlElementName");
        }

        @Override
        protected String escape(SoyValue value) {
            return Sanitizers.filterHtmlElementName(value);
        }
    }

    @Singleton
    @SoyPurePrintDirective
    static final class FilterHtmlAttributes
    extends BasicEscapeDirective
    implements SoyJbcSrcPrintDirective.Streamable {
        FilterHtmlAttributes() {
            super("|filterHtmlAttributes");
        }

        @Override
        protected String escape(SoyValue value) {
            return Sanitizers.filterHtmlAttributes(value);
        }

        @Override
        protected boolean isCloseable() {
            return true;
        }
    }

    @Singleton
    @SoyPurePrintDirective
    static final class EscapeHtmlAttributeNospace
    extends BasicEscapeDirective {
        EscapeHtmlAttributeNospace() {
            super("|escapeHtmlAttributeNospace");
        }

        @Override
        protected String escape(SoyValue value) {
            return Sanitizers.escapeHtmlAttributeNospace(value);
        }
    }

    @Singleton
    @SoyPurePrintDirective
    static final class EscapeHtmlAttribute
    extends BasicEscapeDirective {
        EscapeHtmlAttribute() {
            super("|escapeHtmlAttribute");
        }

        @Override
        protected String escape(SoyValue value) {
            return Sanitizers.escapeHtmlAttribute(value);
        }
    }

    @Singleton
    @SoyPurePrintDirective
    static final class EscapeHtmlRcdata
    extends BasicEscapeDirective
    implements SoyJbcSrcPrintDirective.Streamable {
        EscapeHtmlRcdata() {
            super("|escapeHtmlRcdata");
        }

        @Override
        protected String escape(SoyValue value) {
            return Sanitizers.escapeHtmlRcdata(value);
        }
    }

    @Singleton
    @SoyPurePrintDirective
    static final class NormalizeHtml
    extends BasicEscapeDirective
    implements SoyJbcSrcPrintDirective.Streamable {
        NormalizeHtml() {
            super("|normalizeHtml");
        }

        @Override
        protected String escape(SoyValue value) {
            return Sanitizers.normalizeHtml(value);
        }
    }

    @Singleton
    @SoyPurePrintDirective
    static final class FilterCssValue
    extends BasicEscapeDirective {
        FilterCssValue() {
            super("|filterCssValue");
        }

        @Override
        protected String escape(SoyValue value) {
            return Sanitizers.filterCssValue(value);
        }
    }

    @Singleton
    @SoyPurePrintDirective
    static final class EscapeCssString
    extends BasicEscapeDirective
    implements SoyJbcSrcPrintDirective.Streamable {
        EscapeCssString() {
            super("|escapeCssString");
        }

        @Override
        protected String escape(SoyValue value) {
            return Sanitizers.escapeCssString(value);
        }
    }
}

