/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.SoyFileKind;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.soytree.AbstractParentSoyNode;
import com.google.template.soy.soytree.AliasDeclaration;
import com.google.template.soy.soytree.NamespaceDeclaration;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.TemplateNode;
import java.util.Map;
import javax.annotation.Nullable;

public final class SoyFileNode
extends AbstractParentSoyNode<TemplateNode>
implements SoyNode.SplitLevelTopNode<TemplateNode> {
    public static final Predicate<SoyFileNode> MATCH_SRC_FILENODE = new Predicate<SoyFileNode>(){

        public boolean apply(@Nullable SoyFileNode input) {
            return input != null && input.getSoyFileKind() == SoyFileKind.SRC;
        }
    };
    private final SoyFileKind soyFileKind;
    @Nullable
    private final String delPackageName;
    private final NamespaceDeclaration namespaceDeclaration;
    private final ImmutableMap<String, String> aliasToNamespaceMap;
    private final ImmutableList<AliasDeclaration> aliasDeclarations;
    private final String filePath;
    private final String fileName;

    public SoyFileNode(int id, String filePath, SoyFileKind soyFileKind, NamespaceDeclaration namespaceDeclaration, TemplateNode.SoyFileHeaderInfo headerInfo) {
        super(id, null);
        this.filePath = (String)Preconditions.checkNotNull((Object)filePath);
        this.fileName = SourceLocation.fileNameFromPath(filePath);
        this.soyFileKind = soyFileKind;
        this.delPackageName = headerInfo.delPackageName;
        this.namespaceDeclaration = namespaceDeclaration;
        this.aliasDeclarations = headerInfo.aliasDeclarations;
        this.aliasToNamespaceMap = headerInfo.aliasToNamespaceMap;
    }

    private SoyFileNode(SoyFileNode orig, CopyState copyState) {
        super(orig, copyState);
        this.soyFileKind = orig.soyFileKind;
        this.filePath = orig.filePath;
        this.fileName = orig.fileName;
        this.delPackageName = orig.delPackageName;
        this.namespaceDeclaration = orig.namespaceDeclaration;
        this.aliasDeclarations = orig.aliasDeclarations;
        this.aliasToNamespaceMap = orig.aliasToNamespaceMap;
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.SOY_FILE_NODE;
    }

    public SoyFileKind getSoyFileKind() {
        return this.soyFileKind;
    }

    @Nullable
    public String getDelPackageName() {
        return this.delPackageName;
    }

    @Nullable
    public String getNamespace() {
        return this.namespaceDeclaration.getNamespace();
    }

    public NamespaceDeclaration getNamespaceDeclaration() {
        return this.namespaceDeclaration;
    }

    public ImmutableList<String> getRequiredCssNamespaces() {
        return this.namespaceDeclaration.getRequiredCssNamespaces();
    }

    @Nullable
    public String getCssBaseNamespace() {
        return this.namespaceDeclaration.getCssBaseNamespace();
    }

    public ImmutableMap<String, String> getAliasToNamespaceMap() {
        return this.aliasToNamespaceMap;
    }

    public ImmutableList<AliasDeclaration> getAliasDeclarations() {
        return this.aliasDeclarations;
    }

    public String getFilePath() {
        return this.filePath;
    }

    @Nullable
    public String getFileName() {
        return this.fileName;
    }

    @Override
    @Deprecated
    public SourceLocation getSourceLocation() {
        return super.getSourceLocation();
    }

    @Override
    public String toSourceString() {
        StringBuilder sb = new StringBuilder();
        if (this.delPackageName != null) {
            sb.append("{delpackage ").append(this.delPackageName).append("}\n");
        }
        sb.append(this.namespaceDeclaration.toSourceString());
        if (!this.aliasToNamespaceMap.isEmpty()) {
            sb.append("\n");
            for (Map.Entry entry : this.aliasToNamespaceMap.entrySet()) {
                String alias = (String)entry.getKey();
                String aliasNamespace = (String)entry.getValue();
                if (aliasNamespace.equals(alias) || aliasNamespace.endsWith("." + alias)) {
                    sb.append("{alias ").append(aliasNamespace).append("}\n");
                    continue;
                }
                sb.append("{alias ").append(aliasNamespace).append(" as ").append(alias).append("}\n");
            }
        }
        for (SoyNode child : this.getChildren()) {
            sb.append("\n");
            sb.append(child.toSourceString());
        }
        return sb.toString();
    }

    @Override
    public SoyFileSetNode getParent() {
        return (SoyFileSetNode)super.getParent();
    }

    @Override
    public SoyFileNode copy(CopyState copyState) {
        return new SoyFileNode(this, copyState);
    }
}

