/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.exprtree.ExprEquivalence;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.soytree.AbstractParentCommandNode;
import com.google.template.soy.soytree.CaseOrDefaultNode;
import com.google.template.soy.soytree.MsgSubstUnitBaseVarNameUtils;
import com.google.template.soy.soytree.SoyNode;

public final class MsgPluralNode
extends AbstractParentCommandNode<CaseOrDefaultNode>
implements SoyNode.MsgSubstUnitNode,
SoyNode.SplitLevelTopNode<CaseOrDefaultNode>,
SoyNode.ExprHolderNode {
    public static final String FALLBACK_BASE_PLURAL_VAR_NAME = "NUM";
    private final int offset;
    private final ExprRootNode pluralExpr;
    private final String basePluralVarName;

    public MsgPluralNode(int id, SourceLocation location, ExprNode expr, int offset) {
        super(id, location, "plural");
        this.offset = offset;
        this.pluralExpr = new ExprRootNode(expr);
        this.basePluralVarName = MsgSubstUnitBaseVarNameUtils.genNaiveBaseNameForExpr(expr, FALLBACK_BASE_PLURAL_VAR_NAME);
    }

    private MsgPluralNode(MsgPluralNode orig, CopyState copyState) {
        super(orig, copyState);
        this.offset = orig.offset;
        this.pluralExpr = orig.pluralExpr.copy(copyState);
        this.basePluralVarName = orig.basePluralVarName;
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.MSG_PLURAL_NODE;
    }

    public int getOffset() {
        return this.offset;
    }

    public ExprRootNode getExpr() {
        return this.pluralExpr;
    }

    @Override
    public String getBaseVarName() {
        return this.basePluralVarName;
    }

    @Override
    public boolean shouldUseSameVarNameAs(SoyNode.MsgSubstUnitNode other) {
        if (!(other instanceof MsgPluralNode)) {
            return false;
        }
        MsgPluralNode that = (MsgPluralNode)other;
        return ExprEquivalence.get().equivalent(this.pluralExpr, that.pluralExpr) && this.offset == that.offset;
    }

    @Override
    public String getCommandText() {
        return this.offset > 0 ? this.pluralExpr.toSourceString() + " offset=" + this.offset : this.pluralExpr.toSourceString();
    }

    @Override
    public ImmutableList<ExprRootNode> getExprList() {
        return ImmutableList.of((Object)this.pluralExpr);
    }

    @Override
    public SoyNode.MsgBlockNode getParent() {
        return (SoyNode.MsgBlockNode)super.getParent();
    }

    @Override
    public MsgPluralNode copy(CopyState copyState) {
        return new MsgPluralNode(this, copyState);
    }
}

