/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.base.Preconditions;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.soytree.AbstractSoyNode;
import com.google.template.soy.soytree.SoyNode;

abstract class AbstractCommandNode
extends AbstractSoyNode
implements SoyNode.CommandNode {
    private static final String TAG_STRING = "{%s}";
    private static final String TAG_STRING_SELF_ENDING = "{%s /}";
    private final String commandName;

    public AbstractCommandNode(int id, SourceLocation sourceLocation, String commandName) {
        super(id, sourceLocation);
        this.commandName = (String)Preconditions.checkNotNull((Object)commandName);
    }

    protected AbstractCommandNode(AbstractCommandNode orig, CopyState copyState) {
        super(orig, copyState);
        this.commandName = orig.commandName;
    }

    @Override
    public String getCommandName() {
        return this.commandName;
    }

    @Override
    public String getCommandText() {
        return "";
    }

    protected String getTagString() {
        return this.getTagString(false);
    }

    protected String getTagString(boolean selfEnding) {
        String base = selfEnding ? TAG_STRING_SELF_ENDING : TAG_STRING;
        String commandName = this.getCommandName();
        String commandText = this.getCommandText();
        String tagText = String.format("%s %s", commandName, commandText);
        return String.format(base, tagText.trim());
    }

    @Override
    public String toSourceString() {
        return this.getTagString();
    }
}

