/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.template.soy.base.internal.SoyFileKind;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.CallBasicNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.TemplateBasicNode;
import com.google.template.soy.soytree.TemplateRegistry;

public final class StrictDepsVisitor
extends AbstractSoyNodeVisitor<Void> {
    private static final SoyErrorKind CALL_TO_UNDEFINED_TEMPLATE = SoyErrorKind.of("Undefined template ''{0}''.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind CALL_TO_INDIRECT_DEPENDENCY = SoyErrorKind.of("Call is satisfied only by indirect dependency {0}. Add it as a direct dependency.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind CALL_FROM_DEP_TO_SRC = SoyErrorKind.of("Illegal call to ''{0}'', because according to the dependency graph, {1} depends on {2}, not the other way around.", new SoyErrorKind.StyleAllowance[0]);
    private final TemplateRegistry templateRegistry;
    private final ErrorReporter errorReporter;

    public StrictDepsVisitor(TemplateRegistry templateRegistry, ErrorReporter errorReporter) {
        this.templateRegistry = templateRegistry;
        this.errorReporter = errorReporter;
    }

    @Override
    protected void visitCallBasicNode(CallBasicNode node) {
        TemplateBasicNode callee = this.templateRegistry.getBasicTemplate(node.getCalleeName());
        if (callee == null) {
            this.errorReporter.report(node.getSourceLocation(), CALL_TO_UNDEFINED_TEMPLATE, node.getCalleeName());
        } else {
            SoyFileKind callerKind = node.getNearestAncestor(SoyFileNode.class).getSoyFileKind();
            SoyFileKind calleeKind = callee.getParent().getSoyFileKind();
            if (calleeKind == SoyFileKind.INDIRECT_DEP && callerKind == SoyFileKind.SRC) {
                this.errorReporter.report(node.getSourceLocation(), CALL_TO_INDIRECT_DEPENDENCY, callee.getSourceLocation().getFilePath());
            }
            if (calleeKind == SoyFileKind.SRC && callerKind != SoyFileKind.SRC) {
                this.errorReporter.report(node.getSourceLocation(), CALL_FROM_DEP_TO_SRC, callee.getTemplateNameForUserMsgs(), callee.getSourceLocation().getFilePath(), node.getSourceLocation().getFilePath());
            }
        }
        this.visitChildren(node);
    }

    @Override
    protected void visitSoyNode(SoyNode node) {
        if (node instanceof SoyNode.ParentSoyNode) {
            this.visitChildren((SoyNode.ParentSoyNode)node);
        }
    }
}

