/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.base.Equivalence;
import com.google.common.base.Preconditions;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.shared.internal.DelTemplateSelector;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.CallBasicNode;
import com.google.template.soy.soytree.CallDelegateNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.TemplateBasicNode;
import com.google.template.soy.soytree.TemplateDelegateNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.TemplateRegistry;
import com.google.template.soy.soytree.defn.TemplateParam;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

final class CheckDelegatesVisitor
extends AbstractSoyNodeVisitor<Void> {
    private static final SoyErrorKind CALL_TO_DELTEMPLATE = SoyErrorKind.of("''call'' to delegate template ''{0}'' (expected ''delcall'').", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind CROSS_PACKAGE_DELCALL = SoyErrorKind.of("Found illegal call from ''{0}'' to ''{1}'', which is in a different delegate package.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind DELCALL_TO_BASIC_TEMPLATE = SoyErrorKind.of("''delcall'' to basic template ''{0}'' (expected ''call'').", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind DELTEMPLATES_WITH_DIFFERENT_PARAM_DECLARATIONS = SoyErrorKind.of("Found delegate template with same name ''{0}'' but different param declarations compared to the definition at {1}.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind STRICT_DELTEMPLATES_WITH_DIFFERENT_CONTENT_KIND = SoyErrorKind.of("If one deltemplate has strict autoescaping, all its peers must also be strictly autoescaped with the same content kind: {0} != {1}. Conflicting definition at {2}.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind DELTEMPLATES_WITH_DIFFERENT_STRICT_HTML_MODE = SoyErrorKind.of("Found delegate template with same name ''{0}'' but different strict html mode compared to the definition at {1}.", new SoyErrorKind.StyleAllowance[0]);
    private final TemplateRegistry templateRegistry;
    private String currTemplateNameForUserMsgs;
    private String currDelPackageName;
    private final boolean enabledStrictHtml;
    private final ErrorReporter errorReporter;

    CheckDelegatesVisitor(TemplateRegistry templateRegistry, boolean enabledStrictHtml, ErrorReporter errorReporter) {
        this.templateRegistry = templateRegistry;
        this.enabledStrictHtml = enabledStrictHtml;
        this.errorReporter = errorReporter;
    }

    @Override
    public Void exec(SoyNode soyNode) {
        Preconditions.checkArgument((boolean)(soyNode instanceof SoyFileSetNode));
        this.checkTemplates();
        super.exec(soyNode);
        return null;
    }

    private void checkTemplates() {
        DelTemplateSelector<TemplateDelegateNode> selector = this.templateRegistry.getDelTemplateSelector();
        for (Collection delTemplateGroup : selector.delTemplateNameToValues().asMap().values()) {
            TemplateDelegateNode firstDelTemplate = null;
            Set<Equivalence.Wrapper<TemplateParam>> firstRequiredParamSet = null;
            SanitizedContent.ContentKind firstContentKind = null;
            boolean firstStrictHtml = false;
            for (TemplateDelegateNode delTemplate : delTemplateGroup) {
                if (firstDelTemplate == null) {
                    firstDelTemplate = delTemplate;
                    firstRequiredParamSet = CheckDelegatesVisitor.getRequiredParamSet(delTemplate);
                    firstContentKind = delTemplate.getContentKind();
                    firstStrictHtml = delTemplate.isStrictHtml() && firstContentKind == SanitizedContent.ContentKind.HTML;
                    continue;
                }
                Set<Equivalence.Wrapper<TemplateParam>> currRequiredParamSet = CheckDelegatesVisitor.getRequiredParamSet(delTemplate);
                if (!currRequiredParamSet.equals(firstRequiredParamSet)) {
                    this.errorReporter.report(delTemplate.getSourceLocation(), DELTEMPLATES_WITH_DIFFERENT_PARAM_DECLARATIONS, firstDelTemplate.getDelTemplateName(), firstDelTemplate.getSourceLocation().toString());
                }
                if (delTemplate.getContentKind() != firstContentKind) {
                    this.errorReporter.report(delTemplate.getSourceLocation(), STRICT_DELTEMPLATES_WITH_DIFFERENT_CONTENT_KIND, String.valueOf((Object)firstContentKind), String.valueOf((Object)delTemplate.getContentKind()), firstDelTemplate.getSourceLocation().toString());
                }
                if (!this.enabledStrictHtml || delTemplate.isStrictHtml() == firstStrictHtml) continue;
                this.errorReporter.report(delTemplate.getSourceLocation(), DELTEMPLATES_WITH_DIFFERENT_STRICT_HTML_MODE, firstDelTemplate.getDelTemplateName(), firstDelTemplate.getSourceLocation().toString());
            }
        }
    }

    private static Set<Equivalence.Wrapper<TemplateParam>> getRequiredParamSet(TemplateDelegateNode delTemplate) {
        HashSet<Equivalence.Wrapper<TemplateParam>> paramSet = new HashSet<Equivalence.Wrapper<TemplateParam>>();
        for (TemplateParam param : delTemplate.getParams()) {
            if (!param.isRequired()) continue;
            paramSet.add((Equivalence.Wrapper<TemplateParam>)ParamEquivalence.INSTANCE.wrap(param));
        }
        return paramSet;
    }

    @Override
    protected void visitTemplateNode(TemplateNode node) {
        this.currTemplateNameForUserMsgs = node.getTemplateNameForUserMsgs();
        this.currDelPackageName = node.getDelPackageName();
        this.visitChildren(node);
    }

    @Override
    protected void visitCallBasicNode(CallBasicNode node) {
        String calleeDelPackageName;
        TemplateBasicNode callee;
        String calleeName = node.getCalleeName();
        if (this.templateRegistry.getDelTemplateSelector().hasDelTemplateNamed(calleeName)) {
            this.errorReporter.report(node.getSourceLocation(), CALL_TO_DELTEMPLATE, calleeName);
        }
        if ((callee = this.templateRegistry.getBasicTemplate(calleeName)) != null && (calleeDelPackageName = callee.getDelPackageName()) != null && !calleeDelPackageName.equals(this.currDelPackageName)) {
            this.errorReporter.report(node.getSourceLocation(), CROSS_PACKAGE_DELCALL, this.currTemplateNameForUserMsgs, callee.getTemplateName());
        }
    }

    @Override
    protected void visitCallDelegateNode(CallDelegateNode node) {
        String delCalleeName = node.getDelCalleeName();
        if (this.templateRegistry.getBasicTemplate(delCalleeName) != null) {
            this.errorReporter.report(node.getSourceLocation(), DELCALL_TO_BASIC_TEMPLATE, delCalleeName);
        }
    }

    @Override
    protected void visitSoyNode(SoyNode node) {
        if (node instanceof SoyNode.ParentSoyNode) {
            this.visitChildren((SoyNode.ParentSoyNode)node);
        }
    }

    private static final class ParamEquivalence
    extends Equivalence<TemplateParam> {
        static final ParamEquivalence INSTANCE = new ParamEquivalence();

        private ParamEquivalence() {
        }

        protected boolean doEquivalent(TemplateParam a, TemplateParam b) {
            return a.name().equals(b.name()) && a.isRequired() == b.isRequired() && a.isInjected() == b.isInjected() && a.type().equals(b.type());
        }

        protected int doHash(TemplateParam t) {
            return Objects.hash(t.name(), t.isInjected(), t.isRequired(), t.type());
        }
    }
}

