/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.base.Preconditions;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.VarRefNode;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.CallParamNode;
import com.google.template.soy.soytree.CallParamValueNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.TemplateNode;

public final class ChangeCallsToPassAllDataVisitor
extends AbstractSoyNodeVisitor<Void> {
    @Override
    public Void exec(SoyNode node) {
        Preconditions.checkArgument((node instanceof SoyFileSetNode || node instanceof SoyFileNode || node instanceof TemplateNode ? 1 : 0) != 0);
        this.visit(node);
        return null;
    }

    @Override
    protected void visitCallNode(CallNode node) {
        if (node.numChildren() == 0) {
            return;
        }
        this.visitChildrenAllowingConcurrentModification(node);
        if (node.isPassingData() && !node.isPassingAllData()) {
            return;
        }
        for (CallParamNode param : node.getChildren()) {
            if (!(param instanceof CallParamValueNode)) {
                return;
            }
            CallParamValueNode paramNode = (CallParamValueNode)param;
            ExprNode valueExpr = paramNode.getExpr().getRoot();
            if (!(valueExpr instanceof VarRefNode)) {
                return;
            }
            VarRefNode valueDataRef = (VarRefNode)valueExpr;
            if (valueDataRef.isLocalVar() || valueDataRef.isInjected()) {
                return;
            }
            if (paramNode.getKey().identifier().equals(valueDataRef.getName())) continue;
            return;
        }
        node.setDataAll();
        node.clearChildren();
    }

    @Override
    protected void visitSoyNode(SoyNode node) {
        if (node instanceof SoyNode.ParentSoyNode) {
            this.visitChildrenAllowingConcurrentModification((SoyNode.ParentSoyNode)node);
        }
    }
}

