/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.exprtree.OperatorNodes;
import com.google.template.soy.exprtree.VarRefNode;
import com.google.template.soy.passes.CompilerFilePass;
import com.google.template.soy.shared.internal.BuiltinFunction;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.AutoescapeMode;
import com.google.template.soy.soytree.IfCondNode;
import com.google.template.soy.soytree.IfNode;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SoyTreeUtils;
import com.google.template.soy.soytree.TemplateDelegateNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.defn.TemplateParam;

public final class AddHtmlCommentsForDebugPass
extends CompilerFilePass {
    public static final String DEBUG_VARIABLE_NAME = "debug_soy_template_info";
    private static final SoyErrorKind IJ_DEBUG_REFERENCE = SoyErrorKind.of("Found a use of the injected parameter ''debug_soy_template_info''. This parameter is reserved by the Soy compiler.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind DEBUG_MODE_BANNED = SoyErrorKind.of("Found a use of the reserved built-in function debugMode(). This is currently disallowed.", new SoyErrorKind.StyleAllowance[0]);
    private final ErrorReporter errorReporter;

    AddHtmlCommentsForDebugPass(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
    }

    @Override
    public void run(SoyFileNode file, IdGenerator nodeIdGen) {
        new AddHtmlCommentsForDebugVisitor(nodeIdGen).exec(file);
    }

    private final class AddHtmlCommentsForDebugVisitor
    extends AbstractSoyNodeVisitor<Void> {
        private static final String HTML_COMMENTS_PREFIX = "<!--dta_of(%s, %s, %s)-->";
        private static final String HTML_COMMENTS_SUFFIX = "<!--dta_cf(%s)-->";
        private final IdGenerator nodeIdGen;
        private String filePath = "";

        AddHtmlCommentsForDebugVisitor(IdGenerator nodeIdGen) {
            this.nodeIdGen = nodeIdGen;
        }

        @Override
        protected void visitSoyFileNode(SoyFileNode node) {
            this.filePath = node.getFilePath();
            this.visitChildren(node);
        }

        @Override
        protected void visitTemplateNode(TemplateNode node) {
            for (TemplateParam param : node.getAllParams()) {
                if (!param.isInjected() || !param.name().equals(AddHtmlCommentsForDebugPass.DEBUG_VARIABLE_NAME)) continue;
                AddHtmlCommentsForDebugPass.this.errorReporter.report(param.nameLocation(), IJ_DEBUG_REFERENCE, new Object[0]);
            }
            for (VarRefNode var : SoyTreeUtils.getAllNodesOfType(node, VarRefNode.class)) {
                if (!var.isDollarSignIjParameter() || !var.getName().equals(AddHtmlCommentsForDebugPass.DEBUG_VARIABLE_NAME)) continue;
                AddHtmlCommentsForDebugPass.this.errorReporter.report(var.getSourceLocation(), IJ_DEBUG_REFERENCE, new Object[0]);
            }
            for (FunctionNode func : SoyTreeUtils.getAllNodesOfType(node, FunctionNode.class)) {
                if (!func.getFunctionName().equals(BuiltinFunction.DEBUG_MODE.getName())) continue;
                AddHtmlCommentsForDebugPass.this.errorReporter.report(func.getSourceLocation(), DEBUG_MODE_BANNED, new Object[0]);
            }
            if (node.getContentKind() != SanitizedContent.ContentKind.HTML) {
                return;
            }
            if (node.getAutoescapeMode() != AutoescapeMode.STRICT) {
                return;
            }
            String templateName = node instanceof TemplateDelegateNode ? ((TemplateDelegateNode)node).getDelTemplateName() : node.getTemplateName();
            node.addChild(0, this.createSoyDebug(node.getSourceLocation(), this.nodeIdGen, String.format(HTML_COMMENTS_PREFIX, templateName, this.filePath, node.getSourceLocation().getBeginLine())));
            node.addChild(this.createSoyDebug(node.getSourceLocation(), this.nodeIdGen, String.format(HTML_COMMENTS_SUFFIX, templateName)));
            this.visitChildren(node);
        }

        @Override
        protected void visitSoyNode(SoyNode node) {
            if (node instanceof SoyNode.ParentSoyNode) {
                this.visitChildren((SoyNode.ParentSoyNode)node);
            }
        }

        private IfNode createSoyDebug(SourceLocation insertionLocation, IdGenerator nodeIdGen, String htmlComment) {
            IfNode ifNode = new IfNode(nodeIdGen.genId(), insertionLocation);
            OperatorNodes.AndOpNode exprNode = new OperatorNodes.AndOpNode(insertionLocation);
            exprNode.addChild(new FunctionNode(BuiltinFunction.DEBUG_MODE.getName(), insertionLocation));
            exprNode.addChild(new VarRefNode(AddHtmlCommentsForDebugPass.DEBUG_VARIABLE_NAME, insertionLocation, true, null));
            IfCondNode ifCondNode = new IfCondNode(nodeIdGen.genId(), insertionLocation, "if", exprNode);
            ifNode.addChild(ifCondNode);
            RawTextNode htmlCommentNode = new RawTextNode(nodeIdGen.genId(), htmlComment, insertionLocation);
            ifCondNode.addChild(htmlCommentNode);
            return ifNode;
        }
    }
}

