/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.parsepasses.contextautoesc;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.template.soy.parsepasses.contextautoesc.AutoValue_SlicedRawTextNode_RawTextSlice;
import com.google.template.soy.parsepasses.contextautoesc.Context;
import com.google.template.soy.soytree.RawTextNode;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;

public final class SlicedRawTextNode {
    private RawTextNode rawTextNode;
    private final Context startContext;
    private Context endContext;
    private final List<RawTextSlice> slices = Lists.newArrayList();

    public SlicedRawTextNode(RawTextNode rawTextNode, Context startContext) {
        this.rawTextNode = rawTextNode;
        this.startContext = startContext;
    }

    public RawTextNode getRawTextNode() {
        return this.rawTextNode;
    }

    public List<RawTextSlice> getSlices() {
        return Collections.unmodifiableList(this.slices);
    }

    public Context getEndContext() {
        return this.endContext;
    }

    void setEndContext(Context endContext) {
        this.endContext = endContext;
    }

    void addSlice(int startOffset, int endOffset, Context context) {
        RawTextSlice last;
        int lastSliceIndex = this.slices.size() - 1;
        if (lastSliceIndex >= 0 && (last = this.slices.get(lastSliceIndex)).getEndOffset() == startOffset && context.equals(last.getContext())) {
            this.slices.remove(lastSliceIndex);
            startOffset = last.getStartOffset();
        }
        this.slices.add(RawTextSlice.create(context, this.rawTextNode, startOffset, endOffset));
    }

    public static List<RawTextSlice> find(Iterable<? extends SlicedRawTextNode> slicedTextNodes, @Nullable Predicate<? super Context> prevContextPredicate, @Nullable Predicate<? super Context> sliceContextPredicate, @Nullable Predicate<? super Context> nextContextPredicate) {
        if (prevContextPredicate == null) {
            prevContextPredicate = Predicates.alwaysTrue();
        }
        if (sliceContextPredicate == null) {
            sliceContextPredicate = Predicates.alwaysTrue();
        }
        if (nextContextPredicate == null) {
            nextContextPredicate = Predicates.alwaysTrue();
        }
        ImmutableSet.Builder matches = ImmutableSet.builder();
        for (SlicedRawTextNode slicedRawTextNode : slicedTextNodes) {
            Context prevContext = slicedRawTextNode.startContext;
            List<RawTextSlice> slices = slicedRawTextNode.slices;
            int n = slices.size();
            for (int i = 0; i < n; ++i) {
                RawTextSlice current = slices.get(i);
                Context nextContext = i + 1 < n ? slices.get(i + 1).getContext() : slicedRawTextNode.endContext;
                if (prevContextPredicate.apply((Object)prevContext) && sliceContextPredicate.apply((Object)current.getContext()) && nextContextPredicate.apply((Object)nextContext)) {
                    matches.add((Object)current);
                }
                prevContext = current.getContext();
            }
        }
        return matches.build().asList();
    }

    static abstract class RawTextSlice {
        RawTextSlice() {
        }

        static RawTextSlice create(Context context, RawTextNode rawTextNode, int startOffset, int endOffset) {
            return new AutoValue_SlicedRawTextNode_RawTextSlice(context, rawTextNode, startOffset, endOffset);
        }

        abstract Context getContext();

        abstract RawTextNode getRawTextNode();

        abstract int getStartOffset();

        abstract int getEndOffset();

        public int getLength() {
            return this.getEndOffset() - this.getStartOffset();
        }

        public String getRawText() {
            return this.getRawTextNode().getRawText().substring(this.getStartOffset(), this.getEndOffset());
        }

        public String toString() {
            String rawText = this.getRawText();
            int id = this.getRawTextNode().getId();
            return "\"" + rawText.replaceAll("\"|\\\\", "\\\\$0") + "\"#" + id;
        }
    }
}

