/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.parsepasses.contextautoesc;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.Ordering;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.basetree.ParentNode;
import com.google.template.soy.error.ExplodingErrorReporter;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.VarRefNode;
import com.google.template.soy.parsepasses.contextautoesc.Context;
import com.google.template.soy.parsepasses.contextautoesc.SlicedRawTextNode;
import com.google.template.soy.soytree.EscapingMode;
import com.google.template.soy.soytree.HtmlContext;
import com.google.template.soy.soytree.IfCondNode;
import com.google.template.soy.soytree.IfNode;
import com.google.template.soy.soytree.PrintDirectiveNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.defn.InjectedParam;
import com.google.template.soy.types.primitive.StringType;
import java.util.List;

public final class ContentSecurityPolicyPass {
    public static final String CSP_NONCE_VARIABLE_NAME = "csp_nonce";
    private static final String NONCE_ATTR_BEFORE_VALUE = " nonce=\"";
    private static final String ATTR_AFTER_VALUE = "\"";
    private static final InjectedParam IMPLICIT_CSP_NONCE_DEFN = new InjectedParam("csp_nonce", StringType.getInstance());
    private static final Predicate<? super Context> IN_SCRIPT_OR_STYLE_TAG_PREDICATE = new Predicate<Context>(){

        public boolean apply(Context c) {
            return (c.elType == Context.ElementType.SCRIPT || c.elType == Context.ElementType.STYLE) && c.state == HtmlContext.HTML_TAG && c.attrType == Context.AttributeType.NONE;
        }
    };
    private static final Predicate<? super Context> IN_SCRIPT_OR_STYLE_BODY_PREDICATE = new Predicate<Context>(){

        public boolean apply(Context c) {
            return c.attrType == Context.AttributeType.NONE && (c.state == HtmlContext.JS || c.state == HtmlContext.CSS);
        }
    };
    public static final Predicate<? super Context> HTML_BEFORE_ATTRIBUTE_VALUE = new Predicate<Context>(){

        public boolean apply(Context c) {
            return c.state == HtmlContext.HTML_BEFORE_ATTRIBUTE_VALUE;
        }
    };
    private static final Ordering<InjectedSoyGenerator> BY_OFFSET = new Ordering<InjectedSoyGenerator>(){

        public int compare(InjectedSoyGenerator o1, InjectedSoyGenerator o2) {
            return Integer.compare(o1.offset, o2.offset);
        }
    };

    private ContentSecurityPolicyPass() {
    }

    public static void blessAuthorSpecifiedScripts(Iterable<? extends SlicedRawTextNode> slicedRawTextNodes) {
        ImmutableList.Builder injectedSoyGenerators = ImmutableList.builder();
        ContentSecurityPolicyPass.findNonceAttrLocations(slicedRawTextNodes, (ImmutableList.Builder<InjectedSoyGenerator>)injectedSoyGenerators);
        ImmutableListMultimap<RawTextNode, InjectedSoyGenerator> groupedInjectedAttrs = ContentSecurityPolicyPass.sortAndGroup((List<InjectedSoyGenerator>)injectedSoyGenerators.build());
        ContentSecurityPolicyPass.generateAndInsertSoyNodesWrappedInIfNode(groupedInjectedAttrs);
    }

    private static void findNonceAttrLocations(Iterable<? extends SlicedRawTextNode> slicedRawTextNodes, ImmutableList.Builder<InjectedSoyGenerator> out) {
        List<SlicedRawTextNode.RawTextSlice> transitions = SlicedRawTextNode.find(slicedRawTextNodes, null, IN_SCRIPT_OR_STYLE_TAG_PREDICATE, IN_SCRIPT_OR_STYLE_BODY_PREDICATE);
        for (SlicedRawTextNode.RawTextSlice slice : transitions) {
            int rawTextLen;
            String rawText = slice.getRawText();
            if (rawText.charAt((rawTextLen = rawText.length()) - 1) != '>') {
                throw new IllegalStateException("Invalid tag end: " + rawText);
            }
            int insertionPoint = rawTextLen - 1;
            if (insertionPoint - 1 >= 0 && rawText.charAt(insertionPoint - 1) == '/') {
                --insertionPoint;
            }
            out.add((Object)new NonceAttrGenerator(slice.getRawTextNode(), slice.getStartOffset() + insertionPoint));
        }
    }

    private static ImmutableListMultimap<RawTextNode, InjectedSoyGenerator> sortAndGroup(List<InjectedSoyGenerator> ungrouped) {
        ListMultimap byNode = MultimapBuilder.hashKeys().arrayListValues().build();
        for (InjectedSoyGenerator generator : ungrouped) {
            byNode.put((Object)generator.rawTextNode, (Object)generator);
        }
        ImmutableListMultimap.Builder groupedAndSorted = ImmutableListMultimap.builder();
        for (RawTextNode node : byNode.keySet()) {
            List group = BY_OFFSET.sortedCopy((Iterable)byNode.get((Object)node));
            int i = 0;
            while (i < group.size()) {
                InjectedSoyGenerator firstGroupMember = (InjectedSoyGenerator)group.get(i);
                int start = i++;
                while (i < group.size() && ((InjectedSoyGenerator)group.get((int)i)).offset == firstGroupMember.offset) {
                    ++i;
                }
                InjectedSoyGenerator groupGenerator = i == start + 1 ? firstGroupMember : new GroupOfInjectedSoyGenerator(group.subList(start, i));
                groupedAndSorted.put((Object)node, (Object)groupGenerator);
            }
        }
        return groupedAndSorted.build();
    }

    private static void generateAndInsertSoyNodesWrappedInIfNode(ImmutableListMultimap<RawTextNode, InjectedSoyGenerator> groupedInjectedAttrs) {
        for (RawTextNode rawTextNode : groupedInjectedAttrs.keySet()) {
            String rawText = rawTextNode.getRawText();
            ParentNode parent = rawTextNode.getParent();
            IdGenerator idGenerator = parent.getNearestAncestor(SoyFileSetNode.class).getNodeIdGenerator();
            int textStart = 0;
            int childIndex = parent.getChildIndex(rawTextNode);
            parent.removeChild(rawTextNode);
            for (InjectedSoyGenerator generator : groupedInjectedAttrs.get((Object)rawTextNode)) {
                int offset = generator.offset;
                if (offset != textStart) {
                    RawTextNode textBefore = new RawTextNode(idGenerator.genId(), rawText.substring(textStart, offset), rawTextNode.getSourceLocation());
                    parent.addChild(childIndex, textBefore);
                    ++childIndex;
                    textStart = offset;
                }
                IfNode ifNode = new IfNode(idGenerator.genId(), rawTextNode.getSourceLocation());
                IfCondNode ifCondNode = new IfCondNode(idGenerator.genId(), rawTextNode.getSourceLocation(), "if", ContentSecurityPolicyPass.makeReferenceToInjectedCspNonce(rawTextNode.getSourceLocation()));
                parent.addChild(childIndex, ifNode);
                ++childIndex;
                ifNode.addChild(ifCondNode);
                ImmutableList.Builder newChildren = ImmutableList.builder();
                generator.addNodesToInject(idGenerator, (ImmutableList.Builder<? super SoyNode.StandaloneNode>)newChildren);
                ifCondNode.addChildren((List)newChildren.build());
            }
            if (textStart == rawText.length()) continue;
            RawTextNode textTail = new RawTextNode(idGenerator.genId(), rawText.substring(textStart), rawTextNode.getSourceLocation());
            parent.addChild(childIndex, textTail);
        }
    }

    private static ExprNode makeReferenceToInjectedCspNonce(SourceLocation location) {
        return new VarRefNode(CSP_NONCE_VARIABLE_NAME, location, true, IMPLICIT_CSP_NONCE_DEFN);
    }

    private static PrintNode makeInjectedCspNoncePrintNode(SourceLocation location, IdGenerator idGenerator, EscapingMode escapeMode) {
        PrintNode printNode = new PrintNode(idGenerator.genId(), location, true, ContentSecurityPolicyPass.makeReferenceToInjectedCspNonce(location), null, ExplodingErrorReporter.get());
        printNode.addChild(new PrintDirectiveNode(idGenerator.genId(), location, escapeMode.directiveName, (ImmutableList<ExprNode>)ImmutableList.of()));
        return printNode;
    }

    private static final class GroupOfInjectedSoyGenerator
    extends InjectedSoyGenerator {
        final ImmutableList<InjectedSoyGenerator> members;

        GroupOfInjectedSoyGenerator(List<? extends InjectedSoyGenerator> group) {
            super(group.get((int)0).rawTextNode, group.get((int)0).offset);
            this.members = ImmutableList.copyOf(group);
            for (InjectedSoyGenerator member : this.members) {
                if (member.rawTextNode == this.rawTextNode && member.offset == this.offset) continue;
                throw new IllegalArgumentException("Invalid group member");
            }
        }

        @Override
        void addNodesToInject(IdGenerator idGenerator, ImmutableList.Builder<? super SoyNode.StandaloneNode> out) {
            for (InjectedSoyGenerator member : this.members) {
                member.addNodesToInject(idGenerator, out);
            }
        }
    }

    private static final class NonceAttrGenerator
    extends InjectedSoyGenerator {
        NonceAttrGenerator(RawTextNode rawTextNode, int offset) {
            super(rawTextNode, offset);
        }

        @Override
        void addNodesToInject(IdGenerator idGenerator, ImmutableList.Builder<? super SoyNode.StandaloneNode> out) {
            out.add((Object)new RawTextNode(idGenerator.genId(), ContentSecurityPolicyPass.NONCE_ATTR_BEFORE_VALUE, this.rawTextNode.getSourceLocation()));
            out.add((Object)ContentSecurityPolicyPass.makeInjectedCspNoncePrintNode(this.rawTextNode.getSourceLocation(), idGenerator, EscapingMode.FILTER_CSP_NONCE_VALUE));
            out.add((Object)new RawTextNode(idGenerator.genId(), ContentSecurityPolicyPass.ATTR_AFTER_VALUE, this.rawTextNode.getSourceLocation()));
        }
    }

    private static abstract class InjectedSoyGenerator {
        final RawTextNode rawTextNode;
        final int offset;

        InjectedSoyGenerator(RawTextNode rawTextNode, int offset) {
            Preconditions.checkElementIndex((int)offset, (int)rawTextNode.getRawText().length(), (String)"text offset");
            this.rawTextNode = rawTextNode;
            this.offset = offset;
        }

        abstract void addNodesToInject(IdGenerator var1, ImmutableList.Builder<? super SoyNode.StandaloneNode> var2);
    }
}

