/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.internal;

import com.google.protobuf.Descriptors;
import com.google.template.soy.base.SoyBackendKind;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.data.internalutils.NodeContentKinds;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.dsl.GoogRequire;
import com.google.template.soy.types.proto.ProtoUtils;
import com.google.template.soy.types.proto.SoyProtoType;

public final class JsRuntime {
    private static final GoogRequire GOOG_ARRAY = GoogRequire.create("goog.array");
    private static final GoogRequire GOOG_ASSERTS = GoogRequire.create("goog.asserts");
    private static final GoogRequire GOOG_STRING = GoogRequire.create("goog.string");
    private static final GoogRequire SOY = GoogRequire.create("soy");
    private static final GoogRequire SOY_ASSERTS = GoogRequire.create("soy.asserts");
    private static final GoogRequire XID_REQUIRE = GoogRequire.create("xid");
    public static final CodeChunk.WithValue GOOG_ARRAY_MAP = GOOG_ARRAY.reference().dotAccess("map");
    public static final CodeChunk.WithValue GOOG_ASSERTS_ASSERT = GOOG_ASSERTS.reference().dotAccess("assert");
    public static final CodeChunk.WithValue GOOG_DEBUG = CodeChunk.dottedIdNoRequire("goog.DEBUG");
    public static final CodeChunk.WithValue GOOG_GET_CSS_NAME = CodeChunk.dottedIdNoRequire("goog.getCssName");
    public static final CodeChunk.WithValue GOOG_GET_MSG = CodeChunk.dottedIdNoRequire("goog.getMsg");
    public static final CodeChunk.WithValue GOOG_IS_ARRAY = CodeChunk.dottedIdNoRequire("goog.isArray");
    public static final CodeChunk.WithValue GOOG_IS_BOOLEAN = CodeChunk.dottedIdNoRequire("goog.isBoolean");
    public static final CodeChunk.WithValue GOOG_IS_FUNCTION = CodeChunk.dottedIdNoRequire("goog.isFunction");
    public static final CodeChunk.WithValue GOOG_IS_NUMBER = CodeChunk.dottedIdNoRequire("goog.isNumber");
    public static final CodeChunk.WithValue GOOG_IS_OBJECT = CodeChunk.dottedIdNoRequire("goog.isObject");
    public static final CodeChunk.WithValue GOOG_IS_STRING = CodeChunk.dottedIdNoRequire("goog.isString");
    public static final CodeChunk.WithValue GOOG_REQUIRE = CodeChunk.dottedIdNoRequire("goog.require");
    public static final CodeChunk.WithValue GOOG_SOY_DATA_SANITIZED_CONTENT = GoogRequire.create("goog.soy.data.SanitizedContent").reference();
    public static final CodeChunk.WithValue GOOG_STRING_UNESCAPE_ENTITIES = GOOG_STRING.dotAccess("unescapeEntities");
    public static final CodeChunk.WithValue GOOG_I18N_MESSAGE_FORMAT = GoogRequire.create("goog.i18n.MessageFormat").reference();
    public static final CodeChunk.WithValue SOY_ASSERTS_ASSERT_TYPE = SOY_ASSERTS.dotAccess("assertType");
    public static final CodeChunk.WithValue SOY_ASSIGN_DEFAULTS = SOY.dotAccess("$$assignDefaults");
    public static final CodeChunk.WithValue SOY_CHECK_MAP_KEY = SOY.dotAccess("$$checkMapKey");
    public static final CodeChunk.WithValue SOY_CHECK_NOT_NULL = SOY.dotAccess("$$checkNotNull");
    public static final CodeChunk.WithValue SOY_ESCAPE_HTML = SOY.dotAccess("$$escapeHtml");
    public static final CodeChunk.WithValue SOY_GET_DELEGATE_FN = SOY.dotAccess("$$getDelegateFn");
    public static final CodeChunk.WithValue SOY_REGISTER_DELEGATE_FN = SOY.dotAccess("$$registerDelegateFn");
    public static final CodeChunk.WithValue SOY_GET_DELTEMPLATE_ID = SOY.dotAccess("$$getDelTemplateId");
    public static final CodeChunk.WithValue WINDOW_CONSOLE_LOG = CodeChunk.dottedIdNoRequire("window.console.log");
    public static final CodeChunk.WithValue XID = XID_REQUIRE.reference();
    public static final CodeChunk.WithValue OPT_DATA = CodeChunk.id("opt_data");
    public static final CodeChunk.WithValue OPT_IJ_DATA = CodeChunk.id("opt_ijData");

    private JsRuntime() {
    }

    public static CodeChunk.WithValue extensionField(Descriptors.FieldDescriptor desc) {
        String jsExtensionImport = ProtoUtils.getJsExtensionImport(desc);
        String jsExtensionName = ProtoUtils.getJsExtensionName(desc);
        return JsRuntime.symbolWithNamespace(jsExtensionImport, jsExtensionName);
    }

    public static CodeChunk.WithValue protoToSanitizedContentConverterFunction(Descriptors.Descriptor messageType) {
        return GoogRequire.create(NodeContentKinds.toJsUnpackFunction(messageType)).reference();
    }

    public static CodeChunk.WithValue sanitizedContentToProtoConverterFunction(Descriptors.Descriptor messageType) {
        return GoogRequire.create(NodeContentKinds.toJsPackFunction(messageType)).reference();
    }

    public static CodeChunk.WithValue sanitizedContentOrdainerFunction(SanitizedContent.ContentKind kind) {
        return JsRuntime.symbolWithNamespace(NodeContentKinds.getJsImportForOrdainersFunctions(kind), NodeContentKinds.toJsSanitizedContentOrdainer(kind));
    }

    public static CodeChunk.WithValue sanitizedContentOrdainerFunctionForInternalBlocks(SanitizedContent.ContentKind kind) {
        return JsRuntime.symbolWithNamespace(NodeContentKinds.getJsImportForOrdainersFunctions(kind), NodeContentKinds.toJsSanitizedContentOrdainerForInternalBlocks(kind));
    }

    public static CodeChunk.WithValue protoConstructor(SoyProtoType type) {
        return GoogRequire.create(type.getNameForBackend(SoyBackendKind.JS_SRC)).reference();
    }

    public static CodeChunk.WithValue sanitizedContentType(SanitizedContent.ContentKind kind) {
        return GoogRequire.create(NodeContentKinds.toJsSanitizedContentCtorName(kind)).reference();
    }

    private static CodeChunk.WithValue symbolWithNamespace(String requireSymbol, String fullyQualifiedSymbol) {
        GoogRequire require = GoogRequire.create(requireSymbol);
        if (fullyQualifiedSymbol.equals(require.symbol())) {
            return require.reference();
        }
        String ident = fullyQualifiedSymbol.substring(require.symbol().length() + 1);
        return require.dotAccess(ident);
    }
}

