/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.dsl.CodeChunkUtils;
import com.google.template.soy.jssrc.dsl.GoogRequire;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nullable;

public class JsCodeBuilder {
    private static final int INDENT_SIZE = 2;
    private final StringBuilder code;
    private final Deque<OutputVar> outputVars;
    private String indent;
    private final CodeChunk.RequiresCollector requireCollector = new CodeChunk.RequiresCollector(){

        @Override
        public void add(GoogRequire require) {
            JsCodeBuilder.this.addGoogRequire(require);
        }
    };
    private final Map<String, GoogRequire> googRequires = new TreeMap<String, GoogRequire>();
    @Nullable
    protected CodeChunk.WithValue currOutputVar;
    private boolean currOutputVarIsInited;

    protected JsCodeBuilder() {
        this.code = new StringBuilder();
        this.indent = "";
        this.outputVars = new ArrayDeque<OutputVar>();
        this.currOutputVar = null;
        this.currOutputVarIsInited = false;
    }

    protected JsCodeBuilder(JsCodeBuilder parent) {
        this.code = new StringBuilder();
        this.indent = parent.indent;
        this.outputVars = parent.outputVars;
        this.currOutputVar = parent.currOutputVar;
        this.currOutputVarIsInited = parent.currOutputVarIsInited;
    }

    Iterable<GoogRequire> googRequires() {
        return this.googRequires.values();
    }

    public void initOutputVarIfNecessary() {
        if (this.currOutputVarIsInited) {
            return;
        }
        this.appendLine("var ", this.currOutputVar.assertExpr().getText(), " = '';");
        this.setOutputVarInited();
    }

    public JsCodeBuilder addChunkToOutputVar(CodeChunk.WithValue chunk) {
        return this.addChunksToOutputVar((List<? extends CodeChunk.WithValue>)ImmutableList.of((Object)chunk));
    }

    public JsCodeBuilder addChunksToOutputVar(List<? extends CodeChunk.WithValue> codeChunks) {
        if (this.currOutputVarIsInited) {
            CodeChunk.WithValue rhs = CodeChunkUtils.concatChunks(codeChunks);
            rhs.collectRequires(this.requireCollector);
            this.appendLine(this.currOutputVar.plusEquals(rhs).getCode());
        } else {
            CodeChunk.WithValue rhs = CodeChunkUtils.concatChunksForceString(codeChunks);
            rhs.collectRequires(this.requireCollector);
            this.append(CodeChunk.declare(this.currOutputVar.singleExprOrName().getText(), rhs));
            this.setOutputVarInited();
        }
        return this;
    }

    public final JsCodeBuilder increaseIndent() {
        return this.changeIndentHelper(1);
    }

    public final JsCodeBuilder increaseIndentTwice() {
        return this.changeIndentHelper(2);
    }

    public final JsCodeBuilder decreaseIndent() {
        return this.changeIndentHelper(-1);
    }

    public final JsCodeBuilder decreaseIndentTwice() {
        return this.changeIndentHelper(-2);
    }

    private JsCodeBuilder changeIndentHelper(int chg) {
        int newIndentDepth = this.indent.length() + chg * 2;
        Preconditions.checkState((newIndentDepth >= 0 ? 1 : 0) != 0);
        this.indent = Strings.repeat((String)" ", (int)newIndentDepth);
        return this;
    }

    void setIndent(int indentCt) {
        this.indent = Strings.repeat((String)" ", (int)indentCt);
    }

    int getIndent() {
        return this.indent.length();
    }

    public JsCodeBuilder pushOutputVar(String outputVarName) {
        this.currOutputVar = CodeChunk.id(outputVarName);
        this.outputVars.push(new OutputVar(this.currOutputVar, false));
        this.currOutputVarIsInited = false;
        return this;
    }

    public JsCodeBuilder popOutputVar() {
        this.outputVars.pop();
        OutputVar top = this.outputVars.peek();
        if (top != null) {
            this.currOutputVar = top.name;
            this.currOutputVarIsInited = top.initialized;
        } else {
            this.currOutputVar = null;
            this.currOutputVarIsInited = false;
        }
        return this;
    }

    public JsCodeBuilder setOutputVarInited() {
        this.outputVars.pop();
        this.outputVars.push(new OutputVar(this.currOutputVar, true));
        this.currOutputVarIsInited = true;
        return this;
    }

    public JsCodeBuilder append(CodeChunk codeChunk) {
        codeChunk.collectRequires(this.requireCollector);
        return this.append(codeChunk.getStatementsForInsertingIntoForeignCodeAtIndent(this.indent.length()));
    }

    public JsCodeBuilder append(String ... codeFragments) {
        for (String codeFragment : codeFragments) {
            this.code.append(codeFragment);
        }
        return this;
    }

    public JsCodeBuilder appendLine(String ... codeFragments) {
        this.code.append(this.indent);
        this.append(codeFragments);
        this.code.append("\n");
        return this;
    }

    public JsCodeBuilder appendLineStart(String ... codeFragments) {
        this.code.append(this.indent);
        this.append(codeFragments);
        return this;
    }

    public JsCodeBuilder appendLineEnd(String ... codeFragments) {
        this.append(codeFragments);
        this.code.append("\n");
        return this;
    }

    public CodeChunk.RequiresCollector getRequiresCollector() {
        return this.requireCollector;
    }

    public void addGoogRequire(GoogRequire require) {
        GoogRequire oldRequire = this.googRequires.put(require.symbol(), require);
        if (oldRequire != null && !oldRequire.equals(require)) {
            throw new IllegalArgumentException("Found the same namespace added as a require in multiple incompatible ways: " + oldRequire + " vs. " + require);
        }
    }

    void appendGoogRequires(StringBuilder sb) {
        for (GoogRequire require : this.googRequires.values()) {
            require.writeTo(sb);
        }
    }

    public String getCode() {
        return this.code.toString();
    }

    void appendCode(StringBuilder sb) {
        sb.append((CharSequence)this.code);
    }

    private static final class OutputVar {
        final CodeChunk.WithValue name;
        final boolean initialized;

        OutputVar(CodeChunk.WithValue name, boolean initialized) {
            this.name = name;
            this.initialized = initialized;
        }
    }
}

