/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.dsl;

import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.Immutable;
import com.google.template.soy.jssrc.dsl.AutoValue_Leaf;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.dsl.FormattingContext;
import com.google.template.soy.jssrc.dsl.GoogRequire;
import com.google.template.soy.jssrc.restricted.JsExpr;

@Immutable
abstract class Leaf
extends CodeChunk.WithValue {
    Leaf() {
    }

    static CodeChunk.WithValue create(String text, Iterable<GoogRequire> require) {
        return Leaf.create(new JsExpr(text, Integer.MAX_VALUE), (Iterable<GoogRequire>)ImmutableSet.copyOf(require));
    }

    static Leaf create(String text) {
        return Leaf.create(new JsExpr(text, Integer.MAX_VALUE), (Iterable<GoogRequire>)ImmutableSet.of());
    }

    static Leaf create(JsExpr value, Iterable<GoogRequire> requires) {
        return new AutoValue_Leaf(value, (ImmutableSet<GoogRequire>)ImmutableSet.copyOf(requires));
    }

    abstract JsExpr value();

    abstract ImmutableSet<GoogRequire> requires();

    @Override
    void doFormatInitialStatements(FormattingContext ctx) {
    }

    @Override
    void doFormatOutputExpr(FormattingContext ctx) {
        ctx.append(this.value().getText());
    }

    @Override
    public JsExpr singleExprOrName() {
        return this.value();
    }

    @Override
    public void collectRequires(CodeChunk.RequiresCollector collector) {
        for (GoogRequire require : this.requires()) {
            collector.add(require);
        }
    }

    @Override
    public ImmutableSet<CodeChunk> initialStatements() {
        return ImmutableSet.of();
    }
}

