/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.google.template.soy.base.internal.UniqueNameGenerator;
import com.google.template.soy.data.SoyValueProvider;
import com.google.template.soy.jbcsrc.AutoValue_TemplateVariableManager_SaveRestoreState;
import com.google.template.soy.jbcsrc.AutoValue_TemplateVariableManager_StaticFieldVariable;
import com.google.template.soy.jbcsrc.AutoValue_TemplateVariableManager_VarKey;
import com.google.template.soy.jbcsrc.BytecodeUtils;
import com.google.template.soy.jbcsrc.CodeBuilder;
import com.google.template.soy.jbcsrc.ConstructorRef;
import com.google.template.soy.jbcsrc.Expression;
import com.google.template.soy.jbcsrc.FieldRef;
import com.google.template.soy.jbcsrc.LocalVariable;
import com.google.template.soy.jbcsrc.Statement;
import com.google.template.soy.jbcsrc.SyntheticVarName;
import com.google.template.soy.jbcsrc.TypeInfo;
import com.google.template.soy.jbcsrc.api.AdvisingStringBuilder;
import com.google.template.soy.jbcsrc.shared.CompiledTemplate;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.Method;

final class TemplateVariableManager {
    private final List<Variable> allVariables = new ArrayList<Variable>();
    private final Deque<Map<VarKey, Variable>> frames = new ArrayDeque<Map<VarKey, Variable>>();
    private final List<StaticFieldVariable> staticFields = new ArrayList<StaticFieldVariable>();
    private final UniqueNameGenerator fieldNames;
    private final BitSet availableSlots = new BitSet();
    private final TypeInfo owner;
    private final LocalVariable thisVar;
    @Nullable
    private FieldRef currentCalleeField;
    @Nullable
    private FieldRef currentRendereeField;
    @Nullable
    private FieldRef tempBufferField;
    @Nullable
    private FieldRef msgPlaceholderMapField;
    private int msgPlaceholderMapInitialSize = 0;

    TemplateVariableManager(UniqueNameGenerator fieldNames, TypeInfo owner, LocalVariable thisVar, Method method) {
        this.fieldNames = fieldNames;
        this.fieldNames.claimName("$currentCallee");
        this.fieldNames.claimName("$currentRenderee");
        this.fieldNames.claimName("$tmpBuffer");
        this.fieldNames.claimName("$msgPlaceholderMap");
        this.owner = owner;
        this.thisVar = thisVar;
        this.availableSlots.set(0);
        int from = 1;
        for (Type type : method.getArgumentTypes()) {
            int to = from + type.getSize();
            this.availableSlots.set(from, to);
            from = to;
        }
    }

    Scope enterScope() {
        final LinkedHashMap currentFrame = new LinkedHashMap();
        final Label scopeExit = new Label();
        this.frames.push(currentFrame);
        return new Scope(){

            @Override
            Variable createSynthetic(SyntheticVarName varName, Expression initExpr, SaveStrategy strategy) {
                VarKey key = VarKey.create(VarKey.Kind.SYNTHETIC, varName.name());
                String name = TemplateVariableManager.this.fieldNames.generateName("$" + varName.name());
                return this.doCreate(name, new Label(), scopeExit, initExpr, key, strategy);
            }

            @Override
            Variable createTemporary(String name, Expression initExpr) {
                VarKey key = VarKey.create(VarKey.Kind.TEMPORARY, name);
                name = TemplateVariableManager.this.fieldNames.generateName("$$" + name);
                return this.doCreate(name, new Label(), scopeExit, initExpr, key, SaveStrategy.NEVER);
            }

            @Override
            Variable create(String name, Expression initExpr, SaveStrategy strategy) {
                VarKey key = VarKey.create(VarKey.Kind.USER_DEFINED, name);
                name = TemplateVariableManager.this.fieldNames.generateName(name);
                return this.doCreate(name, new Label(), scopeExit, initExpr, key, strategy);
            }

            @Override
            Statement exitScope() {
                TemplateVariableManager.this.frames.pop();
                final Set endLabels = Sets.newIdentityHashSet();
                for (Variable var : currentFrame.values()) {
                    endLabels.add(var.local.end());
                    TemplateVariableManager.this.availableSlots.clear(var.local.index(), var.local.index() + var.local.resultType().getSize());
                }
                return new Statement(){

                    @Override
                    void doGen(CodeBuilder adapter) {
                        for (Label label : endLabels) {
                            adapter.visitLabel(label);
                        }
                    }
                };
            }

            private Variable doCreate(String name, Label start, Label end, Expression initExpr, VarKey key, SaveStrategy strategy) {
                Variable var;
                int index = TemplateVariableManager.this.reserveSlotFor(initExpr.resultType());
                LocalVariable local = LocalVariable.createLocal(name, index, initExpr.resultType(), start, end);
                switch (strategy) {
                    case DERIVED: {
                        var = new DerivedVariable(initExpr, local);
                        break;
                    }
                    case NEVER: {
                        var = new TemporaryVariable(initExpr, local);
                        break;
                    }
                    case STORE: {
                        var = new FieldSavedVariable(initExpr, local);
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
                currentFrame.put(key, var);
                TemplateVariableManager.this.allVariables.add(var);
                return var;
            }
        };
    }

    void generateTableEntries(CodeBuilder ga) {
        for (Variable var : this.allVariables) {
            var.local.tableEntry(ga);
        }
    }

    FieldRef addStaticField(String proposedName, Expression initializer) {
        String name = this.fieldNames.generateName(proposedName);
        FieldRef ref = FieldRef.create(this.owner, name, initializer.resultType(), 26, !initializer.isNonNullable());
        this.staticFields.add(new AutoValue_TemplateVariableManager_StaticFieldVariable(ref, initializer));
        return ref;
    }

    @CheckReturnValue
    Statement defineFields(ClassVisitor writer) {
        ArrayList<Statement> initializers = new ArrayList<Statement>();
        for (Variable var : this.allVariables) {
            var.maybeDefineField(writer);
        }
        if (this.currentCalleeField != null) {
            this.currentCalleeField.defineField(writer);
        }
        if (this.currentRendereeField != null) {
            this.currentRendereeField.defineField(writer);
        }
        if (this.tempBufferField != null) {
            this.tempBufferField.defineField(writer);
            final Expression newStringBuilder = ConstructorRef.ADVISING_STRING_BUILDER.construct(new Expression[0]);
            initializers.add(new Statement(){

                @Override
                void doGen(CodeBuilder adapter) {
                    adapter.loadThis();
                    newStringBuilder.gen(adapter);
                    TemplateVariableManager.this.tempBufferField.putUnchecked(adapter);
                }
            });
        }
        if (this.msgPlaceholderMapField != null) {
            this.msgPlaceholderMapField.defineField(writer);
            final Expression newHashMap = ConstructorRef.LINKED_HASH_MAP_SIZE.construct(BytecodeUtils.constant(this.msgPlaceholderMapInitialSize));
            initializers.add(new Statement(){

                @Override
                void doGen(CodeBuilder adapter) {
                    adapter.loadThis();
                    newHashMap.gen(adapter);
                    TemplateVariableManager.this.msgPlaceholderMapField.putUnchecked(adapter);
                }
            });
        }
        return Statement.concat(initializers);
    }

    void defineStaticFields(ClassVisitor writer) {
        if (this.staticFields.isEmpty()) {
            return;
        }
        ArrayList<Statement> statements = new ArrayList<Statement>();
        for (StaticFieldVariable staticField : this.staticFields) {
            staticField.field().defineField(writer);
            statements.add(staticField.field().putStaticField(staticField.initializer()));
        }
        statements.add(Statement.RETURN);
        Statement.concat(statements).writeMethod(8, BytecodeUtils.CLASS_INIT, writer);
    }

    FieldRef getCurrentCalleeField() {
        FieldRef local = this.currentCalleeField;
        if (local == null) {
            local = this.currentCalleeField = FieldRef.createField(this.owner, "$currentCallee", CompiledTemplate.class);
        }
        return local;
    }

    FieldRef getTempBufferField() {
        FieldRef local = this.tempBufferField;
        if (local == null) {
            local = this.tempBufferField = FieldRef.createFinalField(this.owner, "$tmpBuffer", AdvisingStringBuilder.class).asNonNull();
        }
        return local;
    }

    FieldRef getMsgPlaceholderMapField() {
        FieldRef local = this.msgPlaceholderMapField;
        if (local == null) {
            local = this.msgPlaceholderMapField = FieldRef.createFinalField(this.owner, "$msgPlaceholderMap", LinkedHashMap.class).asNonNull();
        }
        return local;
    }

    void setMsgPlaceholderMapMinSize(int size) {
        this.msgPlaceholderMapInitialSize = Math.max(this.msgPlaceholderMapInitialSize, size);
    }

    FieldRef getCurrentRenderee() {
        FieldRef local = this.currentRendereeField;
        if (local == null) {
            local = this.currentRendereeField = FieldRef.createField(this.owner, "$currentRenderee", SoyValueProvider.class);
        }
        return local;
    }

    Variable getVariable(String name) {
        VarKey varKey = VarKey.create(VarKey.Kind.USER_DEFINED, name);
        return this.getVariable(varKey);
    }

    Variable getVariable(SyntheticVarName name) {
        VarKey varKey = VarKey.create(VarKey.Kind.SYNTHETIC, name.name());
        return this.getVariable(varKey);
    }

    private Variable getVariable(VarKey varKey) {
        Variable potentialMatch = null;
        for (Map<VarKey, Variable> f : this.frames) {
            Variable variable = f.get(varKey);
            if (variable == null) continue;
            if (potentialMatch == null) {
                potentialMatch = variable;
                continue;
            }
            throw new IllegalArgumentException("Ambiguous variable: " + varKey);
        }
        if (potentialMatch != null) {
            return potentialMatch;
        }
        throw new IllegalArgumentException("No variable: '" + varKey + "' is bound");
    }

    SaveRestoreState saveRestoreState() {
        ArrayList<Statement> saves = new ArrayList<Statement>();
        ArrayList<Statement> restores = new ArrayList<Statement>();
        Iterator<Map<VarKey, Variable>> iterator = this.frames.descendingIterator();
        while (iterator.hasNext()) {
            Map<VarKey, Variable> frame = iterator.next();
            for (Variable var : frame.values()) {
                saves.add(var.save());
                restores.add(var.restore());
            }
        }
        return new AutoValue_TemplateVariableManager_SaveRestoreState(Statement.concat(saves), Statement.concat(restores));
    }

    private int reserveSlotFor(Type type) {
        int size = type.getSize();
        Preconditions.checkArgument((size != 0 ? 1 : 0) != 0);
        int start = 0;
        int nextClear = this.availableSlots.nextClearBit(start);
        if (size == 2 && this.availableSlots.get(nextClear + 1)) {
            start = nextClear + 1;
        }
        this.availableSlots.set(nextClear, nextClear + size);
        return nextClear;
    }

    static abstract class SaveRestoreState {
        SaveRestoreState() {
        }

        abstract Statement save();

        abstract Statement restore();
    }

    static abstract class StaticFieldVariable {
        StaticFieldVariable() {
        }

        abstract FieldRef field();

        abstract Expression initializer();
    }

    private static final class TemporaryVariable
    extends Variable {
        private TemporaryVariable(Expression initExpression, LocalVariable local) {
            super(initExpression, local);
        }

        @Override
        Statement save() {
            throw new UnsupportedOperationException("Should not call save() on this variable.");
        }

        @Override
        Statement restore() {
            throw new UnsupportedOperationException("Should not call restore() on this variable.");
        }

        @Override
        void maybeDefineField(ClassVisitor writer) {
        }
    }

    private static final class DerivedVariable
    extends Variable {
        private DerivedVariable(Expression initExpression, LocalVariable local) {
            super(initExpression, local);
        }

        @Override
        Statement save() {
            return Statement.NULL_STATEMENT;
        }

        @Override
        Statement restore() {
            return this.local.store(this.initExpression);
        }

        @Override
        void maybeDefineField(ClassVisitor writer) {
        }
    }

    private final class FieldSavedVariable
    extends Variable {
        private FieldRef fieldRef;

        private FieldSavedVariable(Expression initExpression, LocalVariable local) {
            super(initExpression, local);
        }

        @Override
        Statement save() {
            return this.getField().putInstanceField(TemplateVariableManager.this.thisVar, this.local);
        }

        @Override
        Statement restore() {
            Expression fieldValue = this.getField().accessor(TemplateVariableManager.this.thisVar);
            return this.local.store(fieldValue);
        }

        private FieldRef getField() {
            if (this.fieldRef == null) {
                this.fieldRef = FieldRef.createField(TemplateVariableManager.this.owner, this.local.variableName(), this.local.resultType());
            }
            return this.fieldRef;
        }

        @Override
        void maybeDefineField(ClassVisitor writer) {
            if (this.fieldRef != null) {
                this.fieldRef.defineField(writer);
            }
        }
    }

    static abstract class Variable {
        protected final Expression initExpression;
        protected final LocalVariable local;
        private final Statement initializer;

        private Variable(Expression initExpression, LocalVariable local) {
            this.initExpression = initExpression;
            this.local = local;
            this.initializer = local.store(initExpression, local.start());
        }

        final Statement initializer() {
            return this.initializer;
        }

        abstract Statement save();

        abstract Statement restore();

        abstract void maybeDefineField(ClassVisitor var1);

        final LocalVariable local() {
            return this.local;
        }
    }

    static abstract class VarKey {
        VarKey() {
        }

        static VarKey create(Kind kind, String proposedName) {
            return new AutoValue_TemplateVariableManager_VarKey(kind, proposedName);
        }

        abstract Kind kind();

        abstract String name();

        static enum Kind {
            USER_DEFINED,
            SYNTHETIC,
            TEMPORARY;

        }
    }

    static abstract class Scope {
        private Scope() {
        }

        abstract Variable createSynthetic(SyntheticVarName var1, Expression var2, SaveStrategy var3);

        abstract Variable createTemporary(String var1, Expression var2);

        abstract Variable create(String var1, Expression var2, SaveStrategy var3);

        abstract Statement exitScope();
    }

    static enum SaveStrategy {
        DERIVED,
        NEVER,
        STORE;

    }
}

