/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.incrementaldomsrc;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.io.Files;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.incrementaldomsrc.GenIncrementalDomCodeVisitor;
import com.google.template.soy.incrementaldomsrc.HtmlContextVisitor;
import com.google.template.soy.incrementaldomsrc.IncrementalDomExtractMsgVariablesVisitor;
import com.google.template.soy.incrementaldomsrc.SoyIncrementalDomSrcOptions;
import com.google.template.soy.incrementaldomsrc.UnescapingVisitor;
import com.google.template.soy.internal.i18n.BidiGlobalDir;
import com.google.template.soy.internal.i18n.SoyBidiUtils;
import com.google.template.soy.jssrc.SoyJsSrcOptions;
import com.google.template.soy.jssrc.internal.OptimizeBidiCodeGenVisitor;
import com.google.template.soy.passes.CombineConsecutiveRawTextNodesVisitor;
import com.google.template.soy.shared.internal.ApiCallScopeUtils;
import com.google.template.soy.shared.internal.GuiceSimpleScope;
import com.google.template.soy.shared.internal.MainEntryPointUtils;
import com.google.template.soy.shared.restricted.ApiCallScopeBindingAnnotations;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.TemplateRegistry;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Provider;

public class IncrementalDomSrcMain {
    private final GuiceSimpleScope apiCallScope;
    private final Provider<OptimizeBidiCodeGenVisitor> optimizeBidiCodeGenVisitorProvider;
    private final Provider<GenIncrementalDomCodeVisitor> genIncrementalDomCodeVisitorProvider;

    @Inject
    public IncrementalDomSrcMain(@ApiCallScopeBindingAnnotations.ApiCall GuiceSimpleScope apiCallScope, Provider<OptimizeBidiCodeGenVisitor> optimizeBidiCodeGenVisitorProvider, Provider<GenIncrementalDomCodeVisitor> genIncrementalDomCodeVisitorProvider) {
        this.apiCallScope = apiCallScope;
        this.optimizeBidiCodeGenVisitorProvider = optimizeBidiCodeGenVisitorProvider;
        this.genIncrementalDomCodeVisitorProvider = genIncrementalDomCodeVisitorProvider;
    }

    public List<String> genJsSrc(SoyFileSetNode soyTree, TemplateRegistry registry, SoyIncrementalDomSrcOptions options, ErrorReporter errorReporter) throws SoySyntaxException {
        SoyJsSrcOptions incrementalJSSrcOptions = options.toJsSrcOptions();
        try (GuiceSimpleScope.InScope inScope = this.apiCallScope.enter();){
            inScope.seed(SoyJsSrcOptions.class, incrementalJSSrcOptions);
            BidiGlobalDir bidiGlobalDir = SoyBidiUtils.decodeBidiGlobalDirFromJsOptions(incrementalJSSrcOptions.getBidiGlobalDir(), incrementalJSSrcOptions.getUseGoogIsRtlForBidiGlobalDir());
            ApiCallScopeUtils.seedSharedParams(inScope, null, bidiGlobalDir);
            ((OptimizeBidiCodeGenVisitor)this.optimizeBidiCodeGenVisitorProvider.get()).exec(soyTree);
            new HtmlContextVisitor(errorReporter).exec(soyTree);
            new UnescapingVisitor().exec(soyTree);
            new IncrementalDomExtractMsgVariablesVisitor().exec(soyTree);
            new CombineConsecutiveRawTextNodesVisitor().exec(soyTree);
            List<String> list = ((GenIncrementalDomCodeVisitor)this.genIncrementalDomCodeVisitorProvider.get()).gen(soyTree, registry, errorReporter);
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void genJsFiles(SoyFileSetNode soyTree, TemplateRegistry templateRegistry, SoyIncrementalDomSrcOptions jsSrcOptions, String outputPathFormat, ErrorReporter errorReporter) throws IOException {
        List<String> jsFileContents = this.genJsSrc(soyTree, templateRegistry, jsSrcOptions, errorReporter);
        ImmutableList srcsToCompile = ImmutableList.copyOf((Iterable)Iterables.filter(soyTree.getChildren(), SoyFileNode.MATCH_SRC_FILENODE));
        if (srcsToCompile.size() != jsFileContents.size()) {
            throw new AssertionError((Object)String.format("Expected to generate %d code chunk(s), got %d", srcsToCompile.size(), jsFileContents.size()));
        }
        Multimap<String, Integer> outputs = MainEntryPointUtils.mapOutputsToSrcs(null, outputPathFormat, "", (ImmutableList<SoyFileNode>)srcsToCompile);
        for (String outputFilePath : outputs.keySet()) {
            try (BufferedWriter out = Files.newWriter((File)new File(outputFilePath), (Charset)StandardCharsets.UTF_8);){
                boolean isFirst = true;
                Iterator i$ = outputs.get((Object)outputFilePath).iterator();
                while (i$.hasNext()) {
                    int inputFileIndex = (Integer)i$.next();
                    if (isFirst) {
                        isFirst = false;
                    } else {
                        out.write("\n;\n");
                    }
                    out.write(jsFileContents.get(inputFileIndex));
                }
            }
        }
    }
}

