/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.error;

import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.error.SnippetFormatter;
import com.google.template.soy.error.SoyError;
import com.google.template.soy.error.SoyErrorKind;
import java.io.IOException;

public final class PrettyErrorFactory
implements SoyError.Factory {
    private final SnippetFormatter snippetFormatter;

    public PrettyErrorFactory(SnippetFormatter snippetFormatter) {
        this.snippetFormatter = snippetFormatter;
    }

    @Override
    public SoyError create(SourceLocation location, SoyErrorKind kind, Object ... args) {
        String message = kind.format(args);
        return SoyError.createError(location, kind, message, this.getFormattedError(location, message));
    }

    private String getFormattedError(SourceLocation sourceLocation, String message) {
        Optional<String> snippet;
        StringBuilder builder = new StringBuilder();
        builder.append(sourceLocation.getFilePath()).append(':').append(sourceLocation.getBeginLine()).append(": error: ").append(message).append("\n");
        try {
            snippet = this.snippetFormatter.getSnippet(sourceLocation);
        }
        catch (IOException exception) {
            snippet = Optional.absent();
        }
        if (snippet.isPresent()) {
            builder.append((String)snippet.get()).append("\n");
            int beginColumn = Math.max(sourceLocation.getBeginColumn(), 1);
            String caretLine = Strings.repeat((String)" ", (int)(beginColumn - 1)) + "^";
            builder.append(caretLine).append("\n");
        }
        return builder.toString();
    }
}

