/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.error;

import com.google.common.base.Preconditions;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.error.AbstractErrorReporter;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;

public final class ExplodingErrorReporter
extends AbstractErrorReporter {
    private static final ErrorReporter INSTANCE = new ExplodingErrorReporter();

    public static ErrorReporter get() {
        return INSTANCE;
    }

    private ExplodingErrorReporter() {
    }

    @Override
    public void report(SourceLocation sourceLocation, SoyErrorKind error, Object ... args) {
        Preconditions.checkNotNull((Object)sourceLocation);
        throw new AssertionError((Object)String.format("Unexpected SoyError: %s at %s", error.format(args), sourceLocation));
    }

    @Override
    public boolean hasErrors() {
        return false;
    }

    @Override
    protected int getCurrentNumberOfErrors() {
        return 0;
    }
}

