/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.error;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.ForOverride;
import com.google.template.soy.error.ErrorReporter;

public abstract class AbstractErrorReporter
implements ErrorReporter {
    @ForOverride
    protected abstract int getCurrentNumberOfErrors();

    @Override
    public final ErrorReporter.Checkpoint checkpoint() {
        return new CheckpointImpl(this, this.getCurrentNumberOfErrors());
    }

    @Override
    public final boolean errorsSince(ErrorReporter.Checkpoint checkpoint) {
        CheckpointImpl impl = (CheckpointImpl)checkpoint;
        if (impl.instance != this) {
            throw new IllegalArgumentException("Can only call errorsSince on a Checkpoint instance that was returned from this same reporter");
        }
        return this.getCurrentNumberOfErrors() > impl.errorsSoFar;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("errorCount", this.getCurrentNumberOfErrors()).toString();
    }

    private static final class CheckpointImpl
    implements ErrorReporter.Checkpoint {
        final ErrorReporter instance;
        final int errorsSoFar;

        private CheckpointImpl(ErrorReporter instance, int errorsSoFar) {
            this.instance = instance;
            this.errorsSoFar = errorsSoFar;
        }
    }
}

