/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.data;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.html.types.SafeHtml;
import com.google.common.html.types.SafeHtmlProto;
import com.google.common.html.types.SafeHtmls;
import com.google.common.html.types.SafeScript;
import com.google.common.html.types.SafeScriptProto;
import com.google.common.html.types.SafeScripts;
import com.google.common.html.types.SafeStyle;
import com.google.common.html.types.SafeStyleProto;
import com.google.common.html.types.SafeStyleSheet;
import com.google.common.html.types.SafeStyleSheetProto;
import com.google.common.html.types.SafeStyleSheets;
import com.google.common.html.types.SafeStyles;
import com.google.common.html.types.SafeUrl;
import com.google.common.html.types.SafeUrlProto;
import com.google.common.html.types.SafeUrls;
import com.google.common.html.types.TrustedResourceUrl;
import com.google.common.html.types.TrustedResourceUrlProto;
import com.google.common.html.types.TrustedResourceUrls;
import com.google.common.io.Resources;
import com.google.errorprone.annotations.CompileTimeConstant;
import com.google.template.soy.data.Dir;
import com.google.template.soy.data.SanitizedContent;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public final class SanitizedContents {
    private static final ImmutableSet<String> SAFE_HTML_FILE_EXTENSIONS = ImmutableSet.of((Object)"html", (Object)"svg");

    private SanitizedContents() {
    }

    public static SanitizedContent emptyString(SanitizedContent.ContentKind kind) {
        return SanitizedContent.create("", kind, Dir.NEUTRAL);
    }

    public static SanitizedContent unsanitizedText(String text, @Nullable Dir dir) {
        return SanitizedContent.create(text, SanitizedContent.ContentKind.TEXT, dir);
    }

    public static SanitizedContent unsanitizedText(String text) {
        return SanitizedContents.unsanitizedText(text, null);
    }

    public static SanitizedContent concatHtml(SanitizedContent ... contents) {
        for (SanitizedContent content : contents) {
            Preconditions.checkArgument((content.getContentKind() == SanitizedContent.ContentKind.HTML ? 1 : 0) != 0, (Object)"Can only concat HTML");
        }
        StringBuilder combined = new StringBuilder();
        Dir dir = Dir.NEUTRAL;
        for (SanitizedContent content : contents) {
            combined.append(content.getContent());
            if (dir == Dir.NEUTRAL) {
                dir = content.getContentDirection();
                continue;
            }
            if (content.getContentDirection() == dir || content.getContentDirection() == Dir.NEUTRAL) continue;
            dir = null;
        }
        return SanitizedContent.create(combined.toString(), SanitizedContent.ContentKind.HTML, dir);
    }

    public static SanitizedContent fromResource(Class<?> contextClass, String resourceName, Charset charset, SanitizedContent.ContentKind kind) throws IOException {
        SanitizedContents.pretendValidateResource(resourceName, kind);
        return SanitizedContent.create(Resources.toString((URL)Resources.getResource(contextClass, (String)resourceName), (Charset)charset), kind, SanitizedContents.getDefaultDir(kind));
    }

    public static SanitizedContent fromResource(String resourceName, Charset charset, SanitizedContent.ContentKind kind) throws IOException {
        SanitizedContents.pretendValidateResource(resourceName, kind);
        return SanitizedContent.create(Resources.toString((URL)Resources.getResource((String)resourceName), (Charset)charset), kind, SanitizedContents.getDefaultDir(kind));
    }

    public static SanitizedContent constantUri(@CompileTimeConstant String constant) {
        return SanitizedContents.fromConstant(constant, SanitizedContent.ContentKind.URI, Dir.LTR);
    }

    public static SanitizedContent constantHtml(@CompileTimeConstant String constant) {
        return SanitizedContents.fromConstant(constant, SanitizedContent.ContentKind.HTML, null);
    }

    private static SanitizedContent fromConstant(String constant, SanitizedContent.ContentKind kind, @Nullable Dir dir) {
        Preconditions.checkArgument((boolean)constant.intern().equals(constant), (Object)"The provided argument does not look like a compile-time constant.");
        return SanitizedContent.create(constant, kind, dir);
    }

    public static SanitizedContent fromSafeHtml(SafeHtml html) {
        return SanitizedContent.create(html.getSafeHtmlString(), SanitizedContent.ContentKind.HTML, null);
    }

    public static SanitizedContent fromSafeHtmlProto(SafeHtmlProto html) {
        return SanitizedContent.create(SafeHtmls.fromProto((SafeHtmlProto)html).getSafeHtmlString(), SanitizedContent.ContentKind.HTML, null);
    }

    public static SanitizedContent fromSafeScript(SafeScript script) {
        return SanitizedContent.create(script.getSafeScriptString(), SanitizedContent.ContentKind.JS, null);
    }

    public static SanitizedContent fromSafeScriptProto(SafeScriptProto script) {
        return SanitizedContent.create(SafeScripts.fromProto((SafeScriptProto)script).getSafeScriptString(), SanitizedContent.ContentKind.JS, null);
    }

    public static SanitizedContent fromSafeStyle(SafeStyle style) {
        return SanitizedContent.create(style.getSafeStyleString(), SanitizedContent.ContentKind.CSS, null);
    }

    public static SanitizedContent fromSafeStyleProto(SafeStyleProto style) {
        return SanitizedContent.create(SafeStyles.fromProto((SafeStyleProto)style).getSafeStyleString(), SanitizedContent.ContentKind.CSS, null);
    }

    public static SanitizedContent fromSafeStyleSheet(SafeStyleSheet styleSheet) {
        return SanitizedContent.create(styleSheet.getSafeStyleSheetString(), SanitizedContent.ContentKind.CSS, null);
    }

    public static SanitizedContent fromSafeStyleSheetProto(SafeStyleSheetProto styleSheet) {
        return SanitizedContent.create(SafeStyleSheets.fromProto((SafeStyleSheetProto)styleSheet).getSafeStyleSheetString(), SanitizedContent.ContentKind.CSS, null);
    }

    public static SanitizedContent fromSafeUrl(SafeUrl url) {
        return SanitizedContent.create(url.getSafeUrlString(), SanitizedContent.ContentKind.URI, Dir.LTR);
    }

    public static SanitizedContent fromSafeUrlProto(SafeUrlProto url) {
        return SanitizedContent.create(SafeUrls.fromProto((SafeUrlProto)url).getSafeUrlString(), SanitizedContent.ContentKind.URI, Dir.LTR);
    }

    public static SanitizedContent fromTrustedResourceUrl(TrustedResourceUrl url) {
        return SanitizedContent.create(url.getTrustedResourceUrlString(), SanitizedContent.ContentKind.TRUSTED_RESOURCE_URI, Dir.LTR);
    }

    public static SanitizedContent fromTrustedResourceUrlProto(TrustedResourceUrlProto url) {
        return SanitizedContent.create(TrustedResourceUrls.fromProto((TrustedResourceUrlProto)url).getTrustedResourceUrlString(), SanitizedContent.ContentKind.TRUSTED_RESOURCE_URI, Dir.LTR);
    }

    @VisibleForTesting
    static void pretendValidateResource(String resourceName, SanitizedContent.ContentKind kind) {
        int index = resourceName.lastIndexOf(46);
        Preconditions.checkArgument((index >= 0 ? 1 : 0) != 0, (Object)"Currently, we only validate resources with explicit extensions.");
        String fileExtension = resourceName.substring(index + 1).toLowerCase();
        switch (kind) {
            case JS: {
                Preconditions.checkArgument((boolean)fileExtension.equals("js"));
                break;
            }
            case HTML: {
                Preconditions.checkArgument((boolean)SAFE_HTML_FILE_EXTENSIONS.contains((Object)fileExtension));
                break;
            }
            case CSS: {
                Preconditions.checkArgument((boolean)fileExtension.equals("css"));
                break;
            }
            default: {
                throw new IllegalArgumentException("Don't know how to validate resources of kind " + (Object)((Object)kind));
            }
        }
    }

    static Dir getDefaultDir(SanitizedContent.ContentKind kind) {
        switch (kind) {
            case JS: 
            case CSS: 
            case URI: 
            case ATTRIBUTES: 
            case TRUSTED_RESOURCE_URI: {
                return Dir.LTR;
            }
        }
        return null;
    }
}

