/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.types.proto;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.TextFormat;
import com.google.template.soy.base.SoyBackendKind;
import com.google.template.soy.data.SoyAbstractValue;
import com.google.template.soy.data.SoyMap;
import com.google.template.soy.data.SoyProtoValue;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.SoyValueConverter;
import com.google.template.soy.data.SoyValueProvider;
import com.google.template.soy.data.restricted.StringData;
import com.google.template.soy.types.proto.Field;
import com.google.template.soy.types.proto.SoyProtoType;
import java.io.IOException;
import java.util.Collection;

public final class SoyProtoValueImpl
extends SoyAbstractValue
implements SoyProtoValue,
SoyMap {
    private final SoyValueConverter valueConverter;
    private final Message proto;
    private final SoyProtoType type;

    SoyProtoValueImpl(SoyValueConverter valueConverter, SoyProtoType type, Message proto) {
        this.valueConverter = (SoyValueConverter)Preconditions.checkNotNull((Object)valueConverter);
        this.type = (SoyProtoType)Preconditions.checkNotNull((Object)type);
        this.proto = (Message)Preconditions.checkNotNull((Object)proto);
    }

    @Override
    public Message getProto() {
        return this.proto;
    }

    @Override
    public boolean hasProtoField(String name) {
        Field field = this.type.getField(name);
        if (field == null) {
            throw new IllegalArgumentException("Proto " + this.proto.getClass().getName() + " does not have a field of name " + name);
        }
        return field.hasField(this.proto);
    }

    @Override
    public SoyValue getProtoField(String name) {
        Field field = this.type.getField(name);
        if (field == null) {
            throw new IllegalArgumentException("Proto " + this.proto.getClass().getName() + " does not have a field of name " + name);
        }
        return field.interpretField(this.valueConverter, this.proto).resolve();
    }

    @Override
    @Deprecated
    public boolean hasField(String name) {
        Field field = this.type.getField(name);
        if (field == null) {
            return false;
        }
        return field.hasField(this.proto);
    }

    @Override
    @Deprecated
    public SoyValue getField(String name) {
        SoyValueProvider valueProvider = this.getFieldProvider(name);
        return valueProvider != null ? valueProvider.resolve() : null;
    }

    @Override
    @Deprecated
    public SoyValueProvider getFieldProvider(String name) {
        return this.getFieldProviderInternal(name);
    }

    private SoyValueProvider getFieldProviderInternal(String name) {
        if (!this.hasField(name)) {
            return null;
        }
        return this.type.getField(name).interpretField(this.valueConverter, this.proto).resolve();
    }

    @Override
    public int getItemCnt() {
        return this.getItemKeys().size();
    }

    public Collection<SoyValue> getItemKeys() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String key : this.type.getFieldNames()) {
            if (!this.hasField(key)) continue;
            builder.add((Object)StringData.forValue(key));
        }
        return builder.build();
    }

    @Override
    public boolean hasItem(SoyValue key) {
        return this.hasField(key.stringValue());
    }

    @Override
    public SoyValue getItem(SoyValue key) {
        return this.getField(key.stringValue());
    }

    @Override
    public SoyValueProvider getItemProvider(SoyValue key) {
        return this.getFieldProvider(key.stringValue());
    }

    @Override
    public boolean equals(Object other) {
        return other != null && this.getClass() == other.getClass() && this.proto == ((SoyProtoValueImpl)other).proto;
    }

    @Override
    public boolean coerceToBoolean() {
        return true;
    }

    @Override
    public String coerceToString() {
        return this.proto.toString();
    }

    @Override
    public void render(Appendable appendable) throws IOException {
        TextFormat.print((MessageOrBuilder)this.proto, (Appendable)appendable);
    }

    public String toString() {
        return String.format("SoyProtoValue<%s>", this.proto.getDescriptorForType().getFullName());
    }

    public int hashCode() {
        return this.proto.hashCode();
    }

    public static final class Builder {
        private static final LoadingCache<SoyProtoType, Message> defaultInstanceForType = CacheBuilder.newBuilder().weakKeys().build((CacheLoader)new CacheLoader<SoyProtoType, Message>(){

            public Message load(SoyProtoType key) throws Exception {
                String nameForBackend = key.getNameForBackend(SoyBackendKind.TOFU);
                Class<?> messageClass = Class.forName(nameForBackend);
                return (Message)messageClass.getMethod("getDefaultInstance", new Class[0]).invoke(null, new Object[0]);
            }
        });
        private final SoyProtoType soyProto;
        private final Message.Builder builder;
        private final SoyValueConverter valueConverter;

        public Builder(SoyValueConverter valueConverter, SoyProtoType soyProto) {
            this.valueConverter = valueConverter;
            this.soyProto = soyProto;
            this.builder = ((Message)defaultInstanceForType.getUnchecked((Object)soyProto)).newBuilderForType();
        }

        public Builder setField(String field, SoyValue value) {
            this.soyProto.getField(field).assignField(this.builder, value);
            return this;
        }

        public SoyProtoValueImpl build() {
            return new SoyProtoValueImpl(this.valueConverter, this.soyProto, this.builder.build());
        }
    }
}

