/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.types.proto;

import com.google.common.base.CaseFormat;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.SoyValueConverter;
import com.google.template.soy.data.SoyValueProvider;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.SoyTypeRegistry;
import com.google.template.soy.types.proto.Field;
import com.google.template.soy.types.proto.FieldInterpreter;
import com.google.template.soy.types.proto.Protos;
import javax.annotation.concurrent.GuardedBy;

class NormalField
implements Field {
    private final SoyTypeRegistry typeRegistry;
    protected final Descriptors.FieldDescriptor fieldDescriptor;
    protected final String name;
    @GuardedBy(value="this")
    private volatile FieldInterpreter interpreter;

    NormalField(SoyTypeRegistry typeRegistry, Descriptors.FieldDescriptor desc) {
        this.typeRegistry = typeRegistry;
        this.fieldDescriptor = desc;
        this.name = NormalField.computeSoyName(desc);
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public SoyType getType() {
        return this.impl().type();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FieldInterpreter impl() {
        FieldInterpreter local = this.interpreter;
        if (local == null) {
            NormalField normalField = this;
            synchronized (normalField) {
                local = this.interpreter;
                if (local == null) {
                    this.interpreter = local = FieldInterpreter.create(this.typeRegistry, this.fieldDescriptor);
                }
            }
        }
        return local;
    }

    @Override
    public boolean hasField(Message proto) {
        return this.fieldDescriptor.isRepeated() || this.fieldDescriptor.hasDefaultValue() || proto.hasField(this.fieldDescriptor);
    }

    @Override
    public SoyValueProvider interpretField(SoyValueConverter converter, Message message) {
        return this.impl().soyFromProto(converter, message.getField(this.fieldDescriptor));
    }

    @Override
    public void assignField(Message.Builder builder, SoyValue value) {
        builder.setField(this.fieldDescriptor, this.impl().protoFromSoy(value));
    }

    @Override
    public Descriptors.FieldDescriptor getDescriptor() {
        return this.fieldDescriptor;
    }

    private static String computeSoyName(Descriptors.FieldDescriptor field) {
        return CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, field.getName()) + NormalField.fieldSuffix(field);
    }

    private static String fieldSuffix(Descriptors.FieldDescriptor field) {
        if (field.isRepeated()) {
            if (Protos.hasJsMapKey(field)) {
                return "Map";
            }
            return "List";
        }
        return "";
    }
}

