/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.types;

import com.google.common.base.Preconditions;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.aggregate.UnionType;
import com.google.template.soy.types.primitive.FloatType;
import com.google.template.soy.types.primitive.IntType;
import com.google.template.soy.types.primitive.NullType;

public final class SoyTypes {
    public static final SoyType NUMBER_TYPE = UnionType.of(IntType.getInstance(), FloatType.getInstance());

    public static SoyType removeNull(SoyType type) {
        Preconditions.checkArgument((!NullType.getInstance().equals(type) ? 1 : 0) != 0, (Object)"Can't remove null from null");
        if (type.getKind() == SoyType.Kind.UNION) {
            return ((UnionType)type).removeNullability();
        }
        return type;
    }

    public static SoyType makeNullable(SoyType type) {
        if (SoyTypes.isNullable(type)) {
            return type;
        }
        return UnionType.of(type, NullType.getInstance());
    }

    public static boolean isNullable(SoyType type) {
        return type.equals(NullType.getInstance()) || type.getKind() == SoyType.Kind.UNION && ((UnionType)type).isNullable();
    }
}

