/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.exprparse.ExpressionParser;
import com.google.template.soy.exprparse.SoyParsingContext;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.soytree.AbstractParentCommandNode;
import com.google.template.soy.soytree.ExprUnion;
import com.google.template.soy.soytree.SoyNode;
import java.util.List;

public final class SwitchNode
extends AbstractParentCommandNode<SoyNode.BlockNode>
implements SoyNode.StandaloneNode,
SoyNode.SplitLevelTopNode<SoyNode.BlockNode>,
SoyNode.StatementNode,
SoyNode.ExprHolderNode {
    private final ExprRootNode expr;

    private SwitchNode(int id, String commandText, ExprRootNode expr, SourceLocation sourceLocation) {
        super(id, sourceLocation, "switch", commandText);
        this.expr = expr;
    }

    private SwitchNode(SwitchNode orig, CopyState copyState) {
        super(orig, copyState);
        this.expr = orig.expr.copy(copyState);
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.SWITCH_NODE;
    }

    public String getExprText() {
        return this.expr.toSourceString();
    }

    public ExprRootNode getExpr() {
        return this.expr;
    }

    @Override
    public List<ExprUnion> getAllExprUnions() {
        return ImmutableList.of((Object)new ExprUnion(this.expr));
    }

    @Override
    public String getCommandText() {
        return this.expr.toSourceString();
    }

    @Override
    public SoyNode.BlockNode getParent() {
        return (SoyNode.BlockNode)super.getParent();
    }

    @Override
    public SwitchNode copy(CopyState copyState) {
        return new SwitchNode(this, copyState);
    }

    public static final class Builder {
        private final int id;
        private final String commandText;
        private final SourceLocation sourceLocation;

        public Builder(int id, String commandText, SourceLocation sourceLocation) {
            this.id = id;
            this.commandText = commandText;
            this.sourceLocation = sourceLocation;
        }

        public SwitchNode build(SoyParsingContext context) {
            ExprNode expr = new ExpressionParser(this.commandText, this.sourceLocation, context).parseExpression();
            return new SwitchNode(this.id, this.commandText, new ExprRootNode(expr), this.sourceLocation);
        }
    }
}

