/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.basetree.AbstractNodeVisitor;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.basetree.Node;
import com.google.template.soy.basetree.NodeVisitor;
import com.google.template.soy.basetree.ParentNode;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.VarDefn;
import com.google.template.soy.exprtree.VarRefNode;
import com.google.template.soy.soytree.ExprUnion;
import com.google.template.soy.soytree.SoyNode;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;

public final class SoyTreeUtils {
    private SoyTreeUtils() {
    }

    @SafeVarargs
    public static boolean hasNodesOfType(Node node, Class<? extends Node> ... types) {
        class Visitor
        implements NodeVisitor<Node, Boolean> {
            boolean found;
            final /* synthetic */ Class[] val$types;

            Visitor(Class[] classArray) {
                this.val$types = classArray;
            }

            @Override
            public Boolean exec(Node node) {
                for (Class type : this.val$types) {
                    if (!type.isInstance(node)) continue;
                    this.found = true;
                    return false;
                }
                return true;
            }
        }
        Visitor v = new Visitor(types);
        SoyTreeUtils.visitAllNodes(node, v);
        return v.found;
    }

    public static void visitAllNodes(Node node, NodeVisitor<? super Node, Boolean> visitor) {
        Node current;
        ArrayDeque<Node> queue = new ArrayDeque<Node>();
        queue.add(node);
        while ((current = (Node)queue.pollLast()) != null) {
            if (!visitor.exec(current).booleanValue()) {
                return;
            }
            if (current instanceof ParentNode) {
                queue.addAll(((ParentNode)current).getChildren());
            }
            if (!(current instanceof SoyNode.ExprHolderNode)) continue;
            for (ExprUnion union : ((SoyNode.ExprHolderNode)current).getAllExprUnions()) {
                if (union.getExpr() == null) continue;
                queue.add(union.getExpr());
            }
        }
    }

    public static <T extends Node> List<T> getAllNodesOfType(SoyNode rootSoyNode, Class<T> classObject) {
        return SoyTreeUtils.getAllNodesOfType(rootSoyNode, classObject, true);
    }

    public static <T extends Node> List<T> getAllNodesOfType(SoyNode rootSoyNode, final Class<T> classObject, final boolean doSearchSubtreesOfMatchedNodes) {
        final ImmutableList.Builder matchedNodesBuilder = ImmutableList.builder();
        final boolean exploreExpressions = ExprNode.class.isAssignableFrom(classObject);
        final AbstractNodeVisitor<ExprNode, Void> exprVisitor = exploreExpressions ? new AbstractNodeVisitor<ExprNode, Void>(){

            @Override
            protected void visit(ExprNode exprNode) {
                if (classObject.isInstance(exprNode)) {
                    matchedNodesBuilder.add(classObject.cast(exprNode));
                    if (!doSearchSubtreesOfMatchedNodes) {
                        return;
                    }
                }
                if (exprNode instanceof ExprNode.ParentExprNode) {
                    this.visitChildren((ExprNode.ParentExprNode)exprNode);
                }
            }
        } : null;
        AbstractNodeVisitor<SoyNode, Void> visitor = new AbstractNodeVisitor<SoyNode, Void>(){

            @Override
            protected void visit(SoyNode soyNode) {
                if (classObject.isInstance(soyNode)) {
                    matchedNodesBuilder.add(classObject.cast(soyNode));
                    if (!doSearchSubtreesOfMatchedNodes) {
                        return;
                    }
                }
                if (soyNode instanceof SoyNode.ParentSoyNode) {
                    this.visitChildren((SoyNode.ParentSoyNode)soyNode);
                }
                if (exploreExpressions && soyNode instanceof SoyNode.ExprHolderNode) {
                    for (ExprUnion exprUnion : ((SoyNode.ExprHolderNode)soyNode).getAllExprUnions()) {
                        if (exprUnion.getExpr() == null) continue;
                        exprVisitor.exec(exprUnion.getExpr());
                    }
                }
            }
        };
        visitor.exec(rootSoyNode);
        return matchedNodesBuilder.build();
    }

    public static <R> void execOnAllV2Exprs(SoyNode node, AbstractNodeVisitor<ExprNode, R> exprNodeVisitor) {
        new VisitAllV2ExprsVisitor(exprNodeVisitor).exec(node);
    }

    public static <T extends SoyNode> T cloneWithNewIds(T origNode, IdGenerator nodeIdGen) {
        T clone = SoyTreeUtils.cloneNode(origNode);
        new GenNewIdsVisitor(nodeIdGen).exec(clone);
        return clone;
    }

    public static <T extends SoyNode> List<T> cloneListWithNewIds(List<T> origNodes, IdGenerator nodeIdGen) {
        Preconditions.checkNotNull(origNodes);
        ArrayList<SoyNode> clones = new ArrayList<SoyNode>(origNodes.size());
        for (SoyNode origNode : origNodes) {
            SoyNode clone = SoyTreeUtils.cloneNode(origNode);
            new GenNewIdsVisitor(nodeIdGen).exec(clone);
            clones.add(clone);
        }
        return clones;
    }

    public static <T extends SoyNode> T cloneNode(T original) {
        SoyNode cloned = original.copy(new CopyState());
        List<SoyNode.LocalVarNode> originalLocalVarNodes = SoyTreeUtils.getAllNodesOfType(original, SoyNode.LocalVarNode.class);
        List<SoyNode.LocalVarNode> newLocalVarNodes = SoyTreeUtils.getAllNodesOfType(cloned, SoyNode.LocalVarNode.class);
        IdentityHashMap<VarDefn, VarDefn> replacementMap = new IdentityHashMap<VarDefn, VarDefn>();
        for (int i = 0; i < newLocalVarNodes.size(); ++i) {
            VarDefn oldDefn = originalLocalVarNodes.get(i).getVar();
            VarDefn newDefn = newLocalVarNodes.get(i).getVar();
            Preconditions.checkState((boolean)oldDefn.name().equals(newDefn.name()));
            replacementMap.put(oldDefn, newDefn);
        }
        for (VarRefNode varRef : SoyTreeUtils.getAllNodesOfType(cloned, VarRefNode.class)) {
            VarDefn replacement = (VarDefn)replacementMap.get(varRef.getDefnDecl());
            if (replacement == null) continue;
            varRef.setDefn(replacement);
        }
        return (T)cloned;
    }

    public static boolean isDescendantOf(SoyNode node, SoyNode ancestor) {
        while (node != null) {
            if (ancestor == node) {
                return true;
            }
            node = node.getParent();
        }
        return false;
    }

    private static class GenNewIdsVisitor
    extends AbstractNodeVisitor<SoyNode, Void> {
        private IdGenerator nodeIdGen;

        public GenNewIdsVisitor(IdGenerator nodeIdGen) {
            this.nodeIdGen = nodeIdGen;
        }

        @Override
        protected void visit(SoyNode node) {
            node.setId(this.nodeIdGen.genId());
            if (node instanceof SoyNode.ParentSoyNode) {
                this.visitChildren((SoyNode.ParentSoyNode)node);
            }
        }
    }

    private static final class VisitAllV2ExprsVisitor<R>
    extends AbstractNodeVisitor<SoyNode, R> {
        private final AbstractNodeVisitor<ExprNode, R> exprNodeVisitor;

        private VisitAllV2ExprsVisitor(AbstractNodeVisitor<ExprNode, R> exprNodeVisitor) {
            this.exprNodeVisitor = exprNodeVisitor;
        }

        @Override
        protected void visit(SoyNode node) {
            if (node instanceof SoyNode.ParentSoyNode) {
                this.visitChildren((SoyNode.ParentSoyNode)node);
            }
            if (node instanceof SoyNode.ExprHolderNode) {
                for (ExprUnion exprUnion : ((SoyNode.ExprHolderNode)node).getAllExprUnions()) {
                    ExprRootNode expr = exprUnion.getExpr();
                    if (expr == null) continue;
                    this.exprNodeVisitor.exec(expr);
                }
            }
        }
    }
}

