/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.exprparse.ExpressionParser;
import com.google.template.soy.exprparse.SoyParsingContext;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.StringNode;
import com.google.template.soy.soytree.CaseOrDefaultNode;
import com.google.template.soy.soytree.SoyNode;

public final class MsgSelectCaseNode
extends CaseOrDefaultNode
implements SoyNode.MsgBlockNode {
    private static final SoyErrorKind INVALID_STRING_FOR_SELECT_CASE = SoyErrorKind.of("Invalid string for select ''case''.");
    private final String caseValue;

    private MsgSelectCaseNode(int id, SourceLocation sourceLocation, String commandText, String caseValue) {
        super(id, sourceLocation, "case", commandText);
        this.caseValue = caseValue;
    }

    private MsgSelectCaseNode(MsgSelectCaseNode orig, CopyState copyState) {
        super(orig, copyState);
        this.caseValue = orig.caseValue;
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.MSG_SELECT_CASE_NODE;
    }

    public String getCaseValue() {
        return this.caseValue;
    }

    @Override
    public MsgSelectCaseNode copy(CopyState copyState) {
        return new MsgSelectCaseNode(this, copyState);
    }

    public static final class Builder {
        private final int id;
        private final String commandText;
        private final SourceLocation sourceLocation;

        private static MsgSelectCaseNode error() {
            return new MsgSelectCaseNode(-1, SourceLocation.UNKNOWN, "error", "error");
        }

        public Builder(int id, String commandText, SourceLocation sourceLocation) {
            this.id = id;
            this.commandText = commandText;
            this.sourceLocation = sourceLocation;
        }

        public MsgSelectCaseNode build(SoyParsingContext context) {
            ErrorReporter.Checkpoint checkpoint = context.errorReporter().checkpoint();
            ExprRootNode strLit = new ExprRootNode(new ExpressionParser(this.commandText, this.sourceLocation, context).parseExpression());
            if (strLit.numChildren() != 1 || !(strLit.getRoot() instanceof StringNode)) {
                context.report(this.sourceLocation, INVALID_STRING_FOR_SELECT_CASE, new Object[0]);
            }
            if (context.errorReporter().errorsSince(checkpoint)) {
                return Builder.error();
            }
            String caseValue = ((StringNode)strLit.getRoot()).getValue();
            return new MsgSelectCaseNode(this.id, this.sourceLocation, this.commandText, caseValue);
        }
    }
}

