/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.basetree.MixinParentNode;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.soytree.CallParamNode;
import com.google.template.soy.soytree.SoyNode;
import java.util.List;
import javax.annotation.Nullable;

public final class CallParamContentNode
extends CallParamNode
implements SoyNode.RenderUnitNode {
    private static final SoyErrorKind PARAM_HAS_VALUE_BUT_IS_NOT_SELF_CLOSING = SoyErrorKind.of("A ''param'' tag should contain a value if and only if it is also self-ending (with a trailing ''/'') (invalid tag is '{'param {0}'}').");
    private final MixinParentNode<SoyNode.StandaloneNode> parentMixin;
    private final String key;
    @Nullable
    private final SanitizedContent.ContentKind contentKind;

    private CallParamContentNode(int id, SourceLocation sourceLocation, String key, SanitizedContent.ContentKind contentKind, String commandText) {
        super(id, sourceLocation, commandText);
        this.parentMixin = new MixinParentNode<SoyNode.StandaloneNode>(this);
        this.key = key;
        this.contentKind = contentKind;
    }

    private CallParamContentNode(CallParamContentNode orig, CopyState copyState) {
        super(orig, copyState);
        this.parentMixin = new MixinParentNode<SoyNode.StandaloneNode>(orig.parentMixin, this, copyState);
        this.key = orig.key;
        this.contentKind = orig.contentKind;
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.CALL_PARAM_CONTENT_NODE;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    @Nullable
    public SanitizedContent.ContentKind getContentKind() {
        return this.contentKind;
    }

    @Override
    public String toSourceString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getTagString());
        this.appendSourceStringForChildren(sb);
        sb.append("{/").append(this.getCommandName()).append('}');
        return sb.toString();
    }

    @Override
    public int numChildren() {
        return this.parentMixin.numChildren();
    }

    @Override
    public SoyNode.StandaloneNode getChild(int index) {
        return this.parentMixin.getChild(index);
    }

    @Override
    public int getChildIndex(SoyNode.StandaloneNode child) {
        return this.parentMixin.getChildIndex(child);
    }

    @Override
    public List<SoyNode.StandaloneNode> getChildren() {
        return this.parentMixin.getChildren();
    }

    @Override
    public void addChild(SoyNode.StandaloneNode child) {
        this.parentMixin.addChild(child);
    }

    @Override
    public void addChild(int index, SoyNode.StandaloneNode child) {
        this.parentMixin.addChild(index, child);
    }

    @Override
    public void removeChild(int index) {
        this.parentMixin.removeChild(index);
    }

    @Override
    public void removeChild(SoyNode.StandaloneNode child) {
        this.parentMixin.removeChild(child);
    }

    @Override
    public void replaceChild(int index, SoyNode.StandaloneNode newChild) {
        this.parentMixin.replaceChild((SoyNode.StandaloneNode)index, newChild);
    }

    @Override
    public void replaceChild(SoyNode.StandaloneNode currChild, SoyNode.StandaloneNode newChild) {
        this.parentMixin.replaceChild(currChild, newChild);
    }

    @Override
    public void clearChildren() {
        this.parentMixin.clearChildren();
    }

    @Override
    public void addChildren(List<? extends SoyNode.StandaloneNode> children) {
        this.parentMixin.addChildren(children);
    }

    @Override
    public void addChildren(int index, List<? extends SoyNode.StandaloneNode> children) {
        this.parentMixin.addChildren(index, children);
    }

    @Override
    public void appendSourceStringForChildren(StringBuilder sb) {
        this.parentMixin.appendSourceStringForChildren(sb);
    }

    @Override
    public CallParamContentNode copy(CopyState copyState) {
        return new CallParamContentNode(this, copyState);
    }

    public static final class Builder
    extends CallParamNode.Builder {
        private static CallParamContentNode error() {
            return new CallParamContentNode(-1, SourceLocation.UNKNOWN, "error", null, "error");
        }

        public Builder(int id, CallParamNode.CommandTextParseResult parseResult, SourceLocation sourceLocation) {
            super(id, parseResult, sourceLocation);
        }

        public CallParamContentNode build(ErrorReporter.Checkpoint checkpoint, ErrorReporter errorReporter) {
            if (this.parseResult.valueExprUnion != null) {
                errorReporter.report(this.sourceLocation, PARAM_HAS_VALUE_BUT_IS_NOT_SELF_CLOSING, this.parseResult.originalCommantText);
            }
            if (errorReporter.errorsSince(checkpoint)) {
                return Builder.error();
            }
            return new CallParamContentNode(this.id, this.sourceLocation, this.parseResult.key, this.parseResult.contentKind, this.parseResult.originalCommantText);
        }
    }
}

