/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soyparse;

import com.google.common.base.CharMatcher;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.base.internal.Identifier;
import com.google.template.soy.base.internal.LegacyInternalSyntaxException;
import com.google.template.soy.base.internal.SoyFileKind;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.exprparse.SoyParsingContext;
import com.google.template.soy.soyparse.ForeachBuilder;
import com.google.template.soy.soyparse.ParseErrors;
import com.google.template.soy.soyparse.ParseException;
import com.google.template.soy.soyparse.RawTextBuilder;
import com.google.template.soy.soyparse.SimpleCharStream;
import com.google.template.soy.soyparse.SourceItemInfo;
import com.google.template.soy.soyparse.SoyFileParserConstants;
import com.google.template.soy.soyparse.SoyFileParserTokenManager;
import com.google.template.soy.soyparse.Token;
import com.google.template.soy.soyparse.TokenMgrError;
import com.google.template.soy.soyparse.Tokens;
import com.google.template.soy.soytree.AbstractCommandNode;
import com.google.template.soy.soytree.AbstractParentCommandNode;
import com.google.template.soy.soytree.AbstractSoyNode;
import com.google.template.soy.soytree.AliasDeclaration;
import com.google.template.soy.soytree.CallBasicNode;
import com.google.template.soy.soytree.CallDelegateNode;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.CallParamContentNode;
import com.google.template.soy.soytree.CallParamNode;
import com.google.template.soy.soytree.CallParamValueNode;
import com.google.template.soy.soytree.CommandTagAttribute;
import com.google.template.soy.soytree.CssNode;
import com.google.template.soy.soytree.DebuggerNode;
import com.google.template.soy.soytree.ForNode;
import com.google.template.soy.soytree.ForeachNode;
import com.google.template.soy.soytree.IfCondNode;
import com.google.template.soy.soytree.IfElseNode;
import com.google.template.soy.soytree.IfNode;
import com.google.template.soy.soytree.LetContentNode;
import com.google.template.soy.soytree.LetNode;
import com.google.template.soy.soytree.LetValueNode;
import com.google.template.soy.soytree.LogNode;
import com.google.template.soy.soytree.MsgFallbackGroupNode;
import com.google.template.soy.soytree.MsgHtmlTagNode;
import com.google.template.soy.soytree.MsgNode;
import com.google.template.soy.soytree.MsgPlaceholderNode;
import com.google.template.soy.soytree.MsgPluralCaseNode;
import com.google.template.soy.soytree.MsgPluralDefaultNode;
import com.google.template.soy.soytree.MsgPluralNode;
import com.google.template.soy.soytree.MsgSelectCaseNode;
import com.google.template.soy.soytree.MsgSelectDefaultNode;
import com.google.template.soy.soytree.MsgSelectNode;
import com.google.template.soy.soytree.NamespaceDeclaration;
import com.google.template.soy.soytree.PrintDirectiveNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SwitchCaseNode;
import com.google.template.soy.soytree.SwitchDefaultNode;
import com.google.template.soy.soytree.SwitchNode;
import com.google.template.soy.soytree.TemplateBasicNodeBuilder;
import com.google.template.soy.soytree.TemplateDelegateNodeBuilder;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.TemplateNodeBuilder;
import com.google.template.soy.soytree.XidNode;
import com.google.template.soy.soytree.defn.HeaderParam;
import com.google.template.soy.soytree.defn.TemplateParam;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.SoyTypeRegistry;
import com.google.template.soy.types.SoyTypes;
import com.google.template.soy.types.ast.GenericTypeNode;
import com.google.template.soy.types.ast.NamedTypeNode;
import com.google.template.soy.types.ast.RecordTypeNode;
import com.google.template.soy.types.ast.TypeNode;
import com.google.template.soy.types.ast.UnionTypeNode;
import com.google.template.soy.types.primitive.ErrorType;
import com.google.template.soy.types.primitive.NullType;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public class SoyFileParser
implements SoyFileParserConstants {
    private static final String LINE_BOUNDARY_REGEX = "\\s*?(\\n|\\r)\\s*";
    private static final Pattern LINE_BOUNDARY_PATTERN = Pattern.compile("\\s*?(\\n|\\r)\\s*");
    private static final Pattern INVALID_PRINT_PREFIX_PATTERN = Pattern.compile("^(" + Joiner.on((String)"|").join((Iterable)FluentIterable.from(Arrays.asList(tokenImage)).filter(Predicates.containsPattern((String)"^\"\\{[a-z]+\\}\"$")).transform((Function)new RegexFromTokenImageFunction())) + ")\\b.+");
    private static final Pattern INVALID_PRINT_FILE_PREFIX_PATTERN = Pattern.compile("^(namespace|(del)?template|typedef|alias)\\b.*");
    private static final Joiner NO_SEP_JOINER = Joiner.on((String)"");
    private static final SoyErrorKind UNEXPECTED_CLOSING_TAG = SoyErrorKind.of("Unexpected closing tag ''{0}''.");
    private static final SoyErrorKind FOUND_DOUBLE_BRACE = SoyErrorKind.of("Soy '{{command}}' syntax is no longer supported.  Use single braces.");
    private static final SoyErrorKind INVALID_DECLARATION = SoyErrorKind.of("Invalid declaration ''{0}''.");
    private static final SoyErrorKind INVALID_PRINT_PREFIX = SoyErrorKind.of("Command ''{0}'' cannot have arguments.");
    private static final SoyErrorKind INVALID_PRINT_FILE_COMMAND = SoyErrorKind.of("Command ''{0}'' cannot appear in templates.");
    private static final SoyErrorKind PLURAL_AND_SELECT_NOT_ALLOWED_INSIDE_PLURAL_BLOCK = SoyErrorKind.of("Tags ''plural'' and ''select'' are not allowed inside ''plural'' blocks.");
    private static final SoyErrorKind MULTIPLE_PHNAME_ATTRIBUTES_IN_COMMAND = SoyErrorKind.of("Found multiple ''phname'' attributes in command text \"{0}\".");
    private static final SoyErrorKind PRINT_COMMAND_WITH_EMPTY_TEXT = SoyErrorKind.of("Found ''print'' command with empty command text.");
    private static final SoyErrorKind INVALID_PRINT_COMMAND_TEXT = SoyErrorKind.of("Invalid ''print'' command text \"{0}\" (check the directives).");
    private static final SoyErrorKind UNEXPECTED_CONTENT_BEFORE = SoyErrorKind.of("Unexpected content before ''{0}'', expected only comments or whitespace.");
    private static final SoyErrorKind UNEXPECTED_CONTENT_AFTER = SoyErrorKind.of("Unexpected content after ''{0}'', expected only comments or whitespace.");
    private SoyTypeRegistry typeRegistry;
    private IdGenerator nodeIdGen;
    private SoyFileKind soyFileKind;
    private String filePath;
    private ErrorReporter errorReporter;
    private SoyParsingContext context;
    public SoyFileParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private int jj_gen;
    private final int[] jj_la1 = new int[56];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private static int[] jj_la1_2;
    private static int[] jj_la1_3;
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;

    public SoyFileParser(SoyTypeRegistry typeRegistry, IdGenerator nodeIdGen, Reader input, SoyFileKind soyFileKind, String filePath, ErrorReporter errorReporter) {
        this(input);
        Preconditions.checkNotNull((Object)typeRegistry);
        Preconditions.checkNotNull((Object)nodeIdGen);
        this.typeRegistry = typeRegistry;
        this.nodeIdGen = nodeIdGen;
        this.soyFileKind = soyFileKind;
        this.filePath = filePath;
        this.errorReporter = errorReporter;
    }

    public SoyFileNode parseSoyFile() {
        Preconditions.checkNotNull((Object)this.typeRegistry);
        Preconditions.checkNotNull((Object)this.nodeIdGen);
        ErrorReporter.Checkpoint checkpoint = this.errorReporter.checkpoint();
        SoyFileNode soyFileNode = null;
        try {
            soyFileNode = this.SoyFile();
        }
        catch (ParseException e) {
            ParseErrors.reportSoyFileParseException(this.errorReporter, this.filePath, e);
        }
        catch (LegacyInternalSyntaxException e) {
            ParseErrors.report(this.errorReporter, this.filePath, e);
        }
        catch (TokenMgrError e) {
            ParseErrors.reportTokenMgrError(this.errorReporter, this.filePath, e);
        }
        if (this.errorReporter.errorsSince(checkpoint)) {
            return null;
        }
        return soyFileNode;
    }

    private <T> SourceItemInfo<T> newSourceItemInfo(T parsed, Token token) {
        return this.newSourceItemInfo(parsed, token.beginLine, token.beginColumn, token.endLine, token.endColumn);
    }

    private <T> SourceItemInfo<T> newSourceItemInfo(T parsed, Token begin, Token end) {
        return this.newSourceItemInfo(parsed, begin.beginLine, begin.beginColumn, end.endLine, end.endColumn);
    }

    private <T> SourceItemInfo<T> newSourceItemInfo(T parsed, SourceItemInfo<?> begin, SourceItemInfo<?> end) {
        return new SourceItemInfo<T>(parsed, begin, end);
    }

    private <T> SourceItemInfo<T> newSourceItemInfo(T parsed, int lineNum, int columnNum, int lineNumEnd, int columnNumEnd) {
        return new SourceItemInfo<T>(this.filePath, parsed, lineNum, columnNum, lineNumEnd, columnNumEnd);
    }

    private <T> SourceItemInfo<T> newSourceItemInfo(T parsed, SourceLocation location) {
        return new SourceItemInfo<T>(parsed, location);
    }

    private <T> SourceItemInfo<T> newSourceItemInfo(T parsed, SourceLocation begin, SourceLocation end) {
        return new SourceItemInfo<T>(parsed, begin.extend(end));
    }

    private SourceLocation createSrcLoc(Token tok1, Token ... rest) {
        return Tokens.createSrcLoc(this.filePath, tok1, rest);
    }

    private void pushState(int nextState) {
        Tokens.checkLexerIsExactlyOneTokenAhead(this);
        this.token_source.pushState(nextState);
    }

    private void popState() {
        Tokens.checkLexerIsExactlyOneTokenAhead(this);
        this.token_source.popState();
    }

    private void popStateIfStateIs(int state) {
        Tokens.checkLexerIsExactlyOneTokenAhead(this);
        this.token_source.popStateIfStateIs(state);
    }

    private final SoyFileNode SoyFile() throws ParseException {
        Identifier delpackageName = null;
        NamespaceDeclaration namespace = NamespaceDeclaration.NULL;
        Object aliases = ImmutableList.of();
        AliasDeclaration alias = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 10: {
                delpackageName = this.DelPackage();
                break;
            }
            default: {
                this.jj_la1[0] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 9: {
                namespace = this.Namespace();
                break;
            }
            default: {
                this.jj_la1[1] = this.jj_gen;
            }
        }
        block12: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 8: {
                    break;
                }
                default: {
                    this.jj_la1[2] = this.jj_gen;
                    break block12;
                }
            }
            alias = this.Alias();
            if (aliases.isEmpty()) {
                aliases = new ArrayList();
            }
            aliases.add(alias);
        }
        TemplateNode.SoyFileHeaderInfo soyFileHeaderInfo = new TemplateNode.SoyFileHeaderInfo(this.errorReporter, delpackageName, namespace, (Collection<AliasDeclaration>)aliases);
        this.context = SoyParsingContext.create(this.errorReporter, soyFileHeaderInfo.namespace, soyFileHeaderInfo.aliasToNamespaceMap);
        SoyFileNode sfn = new SoyFileNode(this.nodeIdGen.genId(), this.filePath, this.soyFileKind, namespace, soyFileHeaderInfo);
        block13: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 15: 
                case 16: {
                    break;
                }
                default: {
                    this.jj_la1[3] = this.jj_gen;
                    break block13;
                }
            }
            TemplateNode template = this.Template(soyFileHeaderInfo);
            if (template == null) continue;
            sfn.addChild(template);
        }
        this.jj_consume_token(0);
        if ("" != null) {
            return sfn;
        }
        throw new Error("Missing return statement in function");
    }

    private final AliasDeclaration Alias() throws ParseException {
        Identifier alias = null;
        Token as = null;
        Token open = this.jj_consume_token(8);
        Identifier namespace = this.DottedIdent();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 75: {
                as = this.jj_consume_token(75);
                alias = this.DottedIdent();
                break;
            }
            default: {
                this.jj_la1[4] = this.jj_gen;
            }
        }
        Token close = this.jj_consume_token(68);
        if ("" != null) {
            return alias == null ? new AliasDeclaration(namespace.identifier(), this.errorReporter, this.createSrcLoc(open, close)) : new AliasDeclaration(namespace.identifier(), alias.identifier(), this.errorReporter, this.createSrcLoc(open, close));
        }
        throw new Error("Missing return statement in function");
    }

    private final NamespaceDeclaration Namespace() throws ParseException {
        Token open = this.jj_consume_token(9);
        Identifier name = this.DottedIdent();
        List<CommandTagAttribute> attributes = this.CommandAttributes();
        Token close = this.jj_consume_token(68);
        if ("" != null) {
            return new NamespaceDeclaration(name, attributes, this.errorReporter);
        }
        throw new Error("Missing return statement in function");
    }

    private final List<CommandTagAttribute> CommandAttributes() throws ParseException {
        Object attributes = ImmutableList.of();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 76: {
                    break;
                }
                default: {
                    this.jj_la1[5] = this.jj_gen;
                    break block3;
                }
            }
            CommandTagAttribute attr = this.Attribute();
            if (attributes.isEmpty()) {
                attributes = new ArrayList();
            }
            attributes.add(attr);
        }
        CommandTagAttribute.removeDuplicatesAndReportErrors((Iterable<CommandTagAttribute>)attributes, this.errorReporter);
        if ("" != null) {
            return attributes;
        }
        throw new Error("Missing return statement in function");
    }

    private final CommandTagAttribute Attribute() throws ParseException {
        Token name = this.jj_consume_token(76);
        Token eq = this.jj_consume_token(74);
        Token value = this.jj_consume_token(12);
        if ("" != null) {
            return new CommandTagAttribute(Identifier.create(name.image, this.createSrcLoc(name, new Token[0])), value.image.substring(1, value.image.length() - 1).replace("\\\"", "\""), this.createSrcLoc(value, new Token[0]));
        }
        throw new Error("Missing return statement in function");
    }

    private final Identifier DelPackage() throws ParseException {
        this.jj_consume_token(10);
        Identifier name = this.DottedIdent();
        this.jj_consume_token(68);
        if ("" != null) {
            return name;
        }
        throw new Error("Missing return statement in function");
    }

    private final TemplateNode Template(TemplateNode.SoyFileHeaderInfo soyFileHeaderInfo) throws ParseException {
        TemplateNode templateNode = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 16: {
                Token open = this.jj_consume_token(16);
                TemplateBasicNodeBuilder builder = new TemplateBasicNodeBuilder(soyFileHeaderInfo, this.errorReporter);
                try {
                    templateNode = this.TemplateHelper(builder, open);
                    this.jj_consume_token(18);
                    break;
                }
                catch (ParseException e) {
                    this.reportErrorAndSkipTo(e, 18);
                    break;
                }
                catch (AbortParsingError e) {
                    if ("" == null) break;
                    return null;
                }
            }
            case 15: {
                Token open = this.jj_consume_token(15);
                TemplateDelegateNodeBuilder builder = new TemplateDelegateNodeBuilder(soyFileHeaderInfo, this.errorReporter);
                try {
                    templateNode = this.TemplateHelper(builder, open);
                    this.jj_consume_token(19);
                    break;
                }
                catch (ParseException e) {
                    this.reportErrorAndSkipTo(e, 19);
                    break;
                }
                catch (AbortParsingError e) {
                    if ("" == null) break;
                    return null;
                }
            }
            default: {
                this.jj_la1[6] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if ("" != null) {
            return templateNode;
        }
        throw new Error("Missing return statement in function");
    }

    private final TemplateNode TemplateHelper(TemplateNodeBuilder builder, Token open) throws ParseException {
        builder.setId(this.nodeIdGen.genId());
        Identifier templateName = this.TemplateName();
        List<CommandTagAttribute> attributes = this.CommandAttributes();
        builder.setCommandValues(templateName, attributes);
        Token soyDoc = open.specialToken;
        if (soyDoc != null && soyDoc.kind == 7) {
            builder.setSoyDoc(soyDoc.image, this.createSrcLoc(soyDoc, new Token[0]));
        }
        this.pushState(3);
        Token close = this.jj_consume_token(68);
        builder.setSourceLocation(this.createSrcLoc(open, close));
        RawTextNode initialRawText = this.TemplateHeader(builder);
        List<SoyNode.StandaloneNode> templateBodyNodes = this.TemplateBlock();
        TemplateNode templateNode = builder.build();
        if (initialRawText != null) {
            templateNode.addChild(initialRawText);
        }
        templateNode.addChildren(templateBodyNodes);
        if ("" != null) {
            return templateNode;
        }
        throw new Error("Missing return statement in function");
    }

    private final Identifier TemplateName() throws ParseException {
        Identifier ident;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 77: {
                Token dot = this.jj_consume_token(77);
                Token name = this.jj_consume_token(76);
                ident = Identifier.create("." + name.image, this.createSrcLoc(dot, name));
                break;
            }
            case 76: {
                ident = this.DottedIdent();
                break;
            }
            default: {
                this.jj_la1[7] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if ("" != null) {
            return ident;
        }
        throw new Error("Missing return statement in function");
    }

    private final Identifier DottedIdent() throws ParseException {
        StringBuilder sb = null;
        Token next = null;
        Token name = this.jj_consume_token(76);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 77: {
                    break;
                }
                default: {
                    this.jj_la1[8] = this.jj_gen;
                    break block3;
                }
            }
            Token dot = this.jj_consume_token(77);
            next = this.jj_consume_token(76);
            if (sb == null) {
                sb = new StringBuilder();
                sb.append(name.image);
            }
            sb.append('.').append(next.image);
        }
        if ("" != null) {
            return sb == null ? Identifier.create(name.image, this.createSrcLoc(name, new Token[0])) : Identifier.create(sb.toString(), this.createSrcLoc(name, next));
        }
        throw new Error("Missing return statement in function");
    }

    private Token reportErrorAndSkipTo(ParseException error, int kind) throws ParseException {
        Token t;
        ParseErrors.reportSoyFileParseException(this.errorReporter, this.filePath, error);
        do {
            t = this.getNextToken();
        } while (t.kind != kind && t.kind != 0);
        return t;
    }

    private Token reportTemplateBodyErrorAndSkipTo(ParseException error, int kind) throws ParseException {
        Token t;
        ParseErrors.reportSoyFileParseException(this.errorReporter, this.filePath, error);
        do {
            t = this.getNextToken();
            if (t.kind != 18 && t.kind != 19) continue;
            throw new AbortParsingError();
        } while (t.kind != kind && t.kind != 0);
        return t;
    }

    private final String CmdText() throws ParseException {
        List<String> cmdTextParts = this.CmdTextParts();
        if ("" != null) {
            return NO_SEP_JOINER.join(cmdTextParts);
        }
        throw new Error("Missing return statement in function");
    }

    private final SourceItemInfo<String> CmdTextWithSource() throws ParseException {
        SourceItemInfo<List<String>> parts = this.CmdTextPartsWithSource();
        if ("" != null) {
            return this.newSourceItemInfo(NO_SEP_JOINER.join((Iterable)parts.parsedContent()), parts.srcLocation());
        }
        throw new Error("Missing return statement in function");
    }

    private final List<String> CmdTextParts() throws ParseException {
        SourceItemInfo<List<String>> parts = this.CmdTextPartsWithSource();
        if ("" != null) {
            return parts.parsedContent();
        }
        throw new Error("Missing return statement in function");
    }

    private final SourceItemInfo<List<String>> CmdTextPartsWithSource() throws ParseException {
        Token first = null;
        Token current = null;
        ArrayList cmdTextParts = Lists.newArrayList();
        StringBuilder currCmdTextPartSb = new StringBuilder();
        block11: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 70: 
                case 71: 
                case 86: {
                    break;
                }
                default: {
                    this.jj_la1[9] = this.jj_gen;
                    break block11;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 86: {
                    current = this.jj_consume_token(86);
                    currCmdTextPartSb.append(current.image);
                    break;
                }
                case 70: 
                case 71: {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 70: {
                            current = this.jj_consume_token(70);
                            break;
                        }
                        case 71: {
                            current = this.jj_consume_token(71);
                            break;
                        }
                        default: {
                            this.jj_la1[10] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    if (currCmdTextPartSb.length() > 0) {
                        cmdTextParts.add(currCmdTextPartSb.toString());
                        currCmdTextPartSb.setLength(0);
                    }
                    cmdTextParts.add(current.image);
                    break;
                }
                default: {
                    this.jj_la1[11] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            if (first != null) continue;
            first = current;
        }
        if (currCmdTextPartSb.length() > 0) {
            cmdTextParts.add(currCmdTextPartSb.toString());
            currCmdTextPartSb.setLength(0);
        }
        int n = cmdTextParts.size();
        for (int i = 0; i < n; ++i) {
            String cmdTextPart = (String)cmdTextParts.get(i);
            if (i == 0) {
                cmdTextPart = CharMatcher.whitespace().trimLeadingFrom((CharSequence)cmdTextPart);
            }
            if (i == n - 1) {
                cmdTextPart = CharMatcher.whitespace().trimTrailingFrom((CharSequence)cmdTextPart);
            }
            cmdTextPart = LINE_BOUNDARY_PATTERN.matcher(cmdTextPart).replaceAll(" ");
            cmdTextParts.set(i, cmdTextPart);
        }
        SourceLocation location = current == null ? this.createSrcLoc(this.getToken(0), new Token[0]) : (current == first ? this.createSrcLoc(first, new Token[0]) : this.createSrcLoc(first, current));
        if ("" != null) {
            return this.newSourceItemInfo(cmdTextParts, location);
        }
        throw new Error("Missing return statement in function");
    }

    private final void SkipWhitespace() throws ParseException {
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 92: {
                    break;
                }
                default: {
                    this.jj_la1[12] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(92);
        }
    }

    private final RawTextNode RawText() throws ParseException {
        RawTextBuilder builder = new RawTextBuilder(this.filePath, this.nodeIdGen);
        block21: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 92: 
                case 93: {
                    Token token;
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 93: {
                            token = this.jj_consume_token(93);
                            break;
                        }
                        case 92: {
                            token = this.jj_consume_token(92);
                            break;
                        }
                        default: {
                            this.jj_la1[13] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    builder.addBasic(token);
                    break;
                }
                case 32: {
                    this.jj_consume_token(32);
                    Token token = this.jj_consume_token(91);
                    builder.addLiteral(token);
                    break;
                }
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: {
                    Token token;
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 25: {
                            token = this.jj_consume_token(25);
                            break;
                        }
                        case 26: {
                            token = this.jj_consume_token(26);
                            break;
                        }
                        case 28: {
                            token = this.jj_consume_token(28);
                            break;
                        }
                        case 27: {
                            token = this.jj_consume_token(27);
                            break;
                        }
                        case 29: {
                            token = this.jj_consume_token(29);
                            break;
                        }
                        case 30: {
                            token = this.jj_consume_token(30);
                            break;
                        }
                        case 31: {
                            token = this.jj_consume_token(31);
                            break;
                        }
                        default: {
                            this.jj_la1[14] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    builder.addTextualCommand(token);
                    break;
                }
                default: {
                    this.jj_la1[15] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 92: 
                case 93: {
                    continue block21;
                }
            }
            break;
        }
        this.jj_la1[16] = this.jj_gen;
        if ("" != null) {
            return builder.build();
        }
        throw new Error("Missing return statement in function");
    }

    private final RawTextNode TemplateHeader(TemplateNodeBuilder templateBuilder) throws ParseException {
        RawTextNode whitespace;
        Object params;
        block15: {
            params = ImmutableList.of();
            whitespace = null;
            String soyDoc = null;
            block10: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 20: 
                    case 21: 
                    case 22: 
                    case 23: 
                    case 92: {
                        break;
                    }
                    default: {
                        this.jj_la1[17] = this.jj_gen;
                        break block15;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 92: {
                        RawTextBuilder builder = new RawTextBuilder(this.filePath, this.nodeIdGen);
                        block11: while (true) {
                            Token tok = this.jj_consume_token(92);
                            if (tok.specialToken != null) {
                                soyDoc = tok.specialToken.image;
                            }
                            builder.addBasic(tok);
                            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                case 92: {
                                    continue block11;
                                }
                            }
                            break;
                        }
                        this.jj_la1[18] = this.jj_gen;
                        whitespace = builder.build();
                        continue block10;
                    }
                    case 20: 
                    case 21: 
                    case 22: 
                    case 23: {
                        HeaderParam param = this.ParamDecl(soyDoc);
                        whitespace = null;
                        soyDoc = null;
                        if (params.isEmpty()) {
                            params = new ArrayList();
                        }
                        params.add(param);
                        continue block10;
                    }
                }
                break;
            }
            this.jj_la1[19] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        templateBuilder.addParams((Iterable<? extends TemplateParam>)params);
        if ("" != null) {
            return whitespace;
        }
        throw new Error("Missing return statement in function");
    }

    private final HeaderParam ParamDecl(@Nullable String desc) throws ParseException {
        Token tagBegin;
        TypeNode paramTypeNode = null;
        SoyType paramType = ErrorType.getInstance();
        boolean optional = false;
        boolean inject = false;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 20: {
                tagBegin = this.jj_consume_token(20);
                break;
            }
            case 21: {
                tagBegin = this.jj_consume_token(21);
                optional = true;
                break;
            }
            case 22: {
                tagBegin = this.jj_consume_token(22);
                inject = true;
                break;
            }
            case 23: {
                tagBegin = this.jj_consume_token(23);
                inject = true;
                optional = true;
                break;
            }
            default: {
                this.jj_la1[20] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (tagBegin.specialToken != null) {
            desc = tagBegin.specialToken.image;
        }
        Token name = this.jj_consume_token(76);
        this.jj_consume_token(73);
        try {
            paramTypeNode = this.TypeExpr();
            paramType = this.typeRegistry.getOrCreateType(paramTypeNode, this.errorReporter);
            Token tagEnd = this.jj_consume_token(68);
        }
        catch (ParseException parseException) {
            Token tagEnd = this.reportTemplateBodyErrorAndSkipTo(parseException, 68);
        }
        if (desc != null) {
            desc = desc.substring(3, desc.length() - 2).trim();
        }
        if ("" != null) {
            return new HeaderParam(name.image, this.createSrcLoc(name, new Token[0]), optional ? this.typeRegistry.getOrCreateUnionType(paramType, NullType.getInstance()) : paramType, paramTypeNode, !optional && !SoyTypes.isNullable(paramType), inject, desc);
        }
        throw new Error("Missing return statement in function");
    }

    private final List<SoyNode.StandaloneNode> TemplateBlock() throws ParseException {
        ArrayList templateBlock;
        block9: {
            templateBlock = Lists.newArrayList();
            block7: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 25: 
                    case 26: 
                    case 27: 
                    case 28: 
                    case 29: 
                    case 30: 
                    case 31: 
                    case 32: 
                    case 33: 
                    case 34: 
                    case 39: 
                    case 42: 
                    case 43: 
                    case 44: 
                    case 45: 
                    case 49: 
                    case 51: 
                    case 57: 
                    case 61: 
                    case 64: 
                    case 66: 
                    case 67: 
                    case 92: 
                    case 93: {
                        break;
                    }
                    default: {
                        this.jj_la1[21] = this.jj_gen;
                        break block9;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 25: 
                    case 26: 
                    case 27: 
                    case 28: 
                    case 29: 
                    case 30: 
                    case 31: 
                    case 32: 
                    case 92: 
                    case 93: {
                        RawTextNode rawText = this.RawText();
                        if (rawText == null) continue block7;
                        templateBlock.add(rawText);
                        continue block7;
                    }
                    case 33: 
                    case 34: 
                    case 39: 
                    case 42: 
                    case 43: 
                    case 44: 
                    case 45: 
                    case 49: 
                    case 51: 
                    case 57: 
                    case 61: 
                    case 64: 
                    case 66: 
                    case 67: {
                        SoyNode.StatementNode stmt = this.Stmt();
                        templateBlock.add(stmt);
                        continue block7;
                    }
                }
                break;
            }
            this.jj_la1[22] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        if ("" != null) {
            return templateBlock;
        }
        throw new Error("Missing return statement in function");
    }

    private final SoyNode.StatementNode Stmt() throws ParseException {
        SoyNode.StatementNode stmt;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 49: 
            case 64: 
            case 66: {
                stmt = this.NonPrintableStmt();
                break;
            }
            case 33: 
            case 34: 
            case 39: 
            case 42: 
            case 43: 
            case 44: 
            case 67: {
                stmt = this.PrintableStmt();
                break;
            }
            case 45: 
            case 51: 
            case 57: 
            case 61: {
                stmt = this.ControlFlowStmt();
                break;
            }
            default: {
                this.jj_la1[23] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if ("" != null) {
            return stmt;
        }
        throw new Error("Missing return statement in function");
    }

    private final SoyNode.StatementNode NonPrintableStmt() throws ParseException {
        AbstractCommandNode stmt;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 49: {
                stmt = this.LetStmt();
                break;
            }
            case 64: {
                stmt = this.LogStmt();
                break;
            }
            case 66: {
                stmt = this.DebuggerStmt();
                break;
            }
            default: {
                this.jj_la1[24] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if ("" != null) {
            return stmt;
        }
        throw new Error("Missing return statement in function");
    }

    private final SoyNode.StatementNode PrintableStmt() throws ParseException {
        AbstractSoyNode stmt;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 39: {
                stmt = this.MsgStmt();
                break;
            }
            case 43: {
                stmt = this.XidStmt();
                break;
            }
            case 44: {
                stmt = this.CssStmt();
                break;
            }
            case 33: 
            case 34: {
                stmt = this.CallStmt();
                break;
            }
            case 42: 
            case 67: {
                stmt = this.PrintStmt();
                break;
            }
            default: {
                this.jj_la1[25] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if ("" != null) {
            return stmt;
        }
        throw new Error("Missing return statement in function");
    }

    private final SoyNode.StatementNode ControlFlowStmt() throws ParseException {
        AbstractSoyNode stmt;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 45: {
                stmt = this.IfStmt();
                break;
            }
            case 57: {
                stmt = this.SwitchStmt();
                break;
            }
            case 61: {
                stmt = this.ForeachStmt();
                break;
            }
            case 51: {
                stmt = this.ForStmt();
                break;
            }
            default: {
                this.jj_la1[26] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if ("" != null) {
            return stmt;
        }
        throw new Error("Missing return statement in function");
    }

    private final MsgFallbackGroupNode MsgStmt() throws ParseException {
        Token tagBegin = this.jj_consume_token(39);
        String cmdText = this.CmdText();
        this.pushState(4);
        ErrorReporter.Checkpoint checkpoint = this.errorReporter.checkpoint();
        Token tagEnd = this.jj_consume_token(68);
        SourceLocation location = this.createSrcLoc(tagBegin, tagEnd);
        MsgFallbackGroupNode msgFbGrpNode = new MsgFallbackGroupNode(this.nodeIdGen.genId(), location);
        MsgNode msgNode = MsgNode.msg(this.nodeIdGen.genId(), cmdText, location).build(this.context);
        msgFbGrpNode.addChild(msgNode);
        List<SoyNode.StandaloneNode> templateBlockForMsg = this.TemplateBlockForMsg();
        msgNode.addChildren(templateBlockForMsg);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 40: {
                tagBegin = this.jj_consume_token(40);
                cmdText = this.CmdText();
                tagEnd = this.jj_consume_token(68);
                location = this.createSrcLoc(tagBegin, tagEnd);
                msgNode = MsgNode.fallbackmsg(this.nodeIdGen.genId(), cmdText, location).build(this.context);
                msgFbGrpNode.addChild(msgNode);
                templateBlockForMsg = this.TemplateBlockForMsg();
                msgNode.addChildren(templateBlockForMsg);
                break;
            }
            default: {
                this.jj_la1[27] = this.jj_gen;
            }
        }
        if (this.errorReporter.errorsSince(checkpoint) || this.getToken((int)1).kind != 41) {
            this.popStateIfStateIs(4);
        } else {
            this.popState();
        }
        this.jj_consume_token(41);
        if ("" != null) {
            return msgFbGrpNode;
        }
        throw new Error("Missing return statement in function");
    }

    private final List<SoyNode.StandaloneNode> TemplateBlockForMsg() throws ParseException {
        ArrayList templateBlock;
        int pluralOrSelectIndex;
        block28: {
            RawTextNode rawText;
            pluralOrSelectIndex = -1;
            boolean firstNodeIsWhitespace = false;
            templateBlock = Lists.newArrayList();
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 92: {
                    RawTextBuilder builder = new RawTextBuilder(this.filePath, this.nodeIdGen);
                    block20: while (true) {
                        Token tok = this.jj_consume_token(92);
                        builder.addBasic(tok);
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 92: {
                                continue block20;
                            }
                        }
                        break;
                    }
                    this.jj_la1[28] = this.jj_gen;
                    rawText = builder.build();
                    if (rawText == null) break;
                    firstNodeIsWhitespace = true;
                    templateBlock.add(rawText);
                    break;
                }
                default: {
                    this.jj_la1[29] = this.jj_gen;
                }
            }
            block21: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 25: 
                    case 26: 
                    case 27: 
                    case 28: 
                    case 29: 
                    case 30: 
                    case 31: 
                    case 32: 
                    case 33: 
                    case 34: 
                    case 42: 
                    case 53: 
                    case 55: 
                    case 67: 
                    case 88: 
                    case 92: 
                    case 93: {
                        break;
                    }
                    default: {
                        this.jj_la1[30] = this.jj_gen;
                        break block28;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 53: 
                    case 55: {
                        AbstractParentCommandNode msgPluralOrSelectNode;
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 53: {
                                msgPluralOrSelectNode = this.MsgPlural();
                                break;
                            }
                            case 55: {
                                msgPluralOrSelectNode = this.MsgSelect();
                                break;
                            }
                            default: {
                                this.jj_la1[31] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        this.SkipWhitespace();
                        if (firstNodeIsWhitespace) {
                            templateBlock.remove(0);
                            firstNodeIsWhitespace = false;
                        }
                        if (pluralOrSelectIndex == -1) {
                            pluralOrSelectIndex = templateBlock.size();
                        }
                        templateBlock.add(msgPluralOrSelectNode);
                        continue block21;
                    }
                    case 25: 
                    case 26: 
                    case 27: 
                    case 28: 
                    case 29: 
                    case 30: 
                    case 31: 
                    case 32: 
                    case 92: 
                    case 93: {
                        rawText = this.RawText();
                        if (rawText == null) continue block21;
                        templateBlock.add(rawText);
                        continue block21;
                    }
                    case 33: 
                    case 34: {
                        AbstractParentCommandNode stmt = this.CallStmt();
                        templateBlock.add(new MsgPlaceholderNode(this.nodeIdGen.genId(), (SoyNode.MsgPlaceholderInitialNode)((Object)stmt)));
                        continue block21;
                    }
                    case 42: 
                    case 67: {
                        AbstractParentCommandNode stmt = this.PrintStmt();
                        templateBlock.add(new MsgPlaceholderNode(this.nodeIdGen.genId(), (SoyNode.MsgPlaceholderInitialNode)((Object)stmt)));
                        continue block21;
                    }
                    case 88: {
                        MsgHtmlTagNode msgHtmlTag = this.MsgHtmlTag();
                        templateBlock.add(new MsgPlaceholderNode(this.nodeIdGen.genId(), msgHtmlTag));
                        continue block21;
                    }
                }
                break;
            }
            this.jj_la1[32] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        if (pluralOrSelectIndex != -1) {
            SoyNode.StandaloneNode pluralOrSelect = (SoyNode.StandaloneNode)templateBlock.get(pluralOrSelectIndex);
            for (int i = 0; i < templateBlock.size(); ++i) {
                if (i == pluralOrSelectIndex) continue;
                this.errorReporter.report(((SoyNode.StandaloneNode)templateBlock.get(i)).getSourceLocation(), i < pluralOrSelectIndex ? UNEXPECTED_CONTENT_BEFORE : UNEXPECTED_CONTENT_AFTER, pluralOrSelect instanceof MsgPluralNode ? "{plural" : "{select");
            }
            if ("" != null) {
                return ImmutableList.of((Object)pluralOrSelect);
            }
        }
        if ("" != null) {
            return templateBlock;
        }
        throw new Error("Missing return statement in function");
    }

    private final MsgPluralNode MsgPlural() throws ParseException {
        Token cmdBegin = this.jj_consume_token(53);
        String cmdText = this.CmdText();
        Token cmdEnd = this.jj_consume_token(68);
        MsgPluralNode msgPluralNode = new MsgPluralNode.Builder(this.nodeIdGen.genId(), cmdText, this.createSrcLoc(cmdBegin, cmdEnd)).build(this.context);
        try {
            List<SoyNode.StandaloneNode> templateBlock;
            this.SkipWhitespace();
            block5: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 60: {
                        break;
                    }
                    default: {
                        this.jj_la1[33] = this.jj_gen;
                        break block5;
                    }
                }
                cmdBegin = this.jj_consume_token(60);
                cmdText = this.CmdText();
                cmdEnd = this.jj_consume_token(68);
                MsgPluralCaseNode msgPluralCaseNode = new MsgPluralCaseNode.Builder(this.nodeIdGen.genId(), cmdText, this.createSrcLoc(cmdBegin, cmdEnd)).build(this.errorReporter);
                msgPluralNode.addChild(msgPluralCaseNode);
                templateBlock = this.TemplateBlockForMsg();
                if (templateBlock.size() == 1 && (templateBlock.get(0) instanceof MsgPluralNode || templateBlock.get(0) instanceof MsgSelectNode)) {
                    this.errorReporter.report(templateBlock.get(0).getSourceLocation(), PLURAL_AND_SELECT_NOT_ALLOWED_INSIDE_PLURAL_BLOCK, new Object[0]);
                }
                msgPluralCaseNode.addChildren(templateBlock);
            }
            Token defaultTag = this.jj_consume_token(59);
            MsgPluralDefaultNode msgPluralDefaultNode = new MsgPluralDefaultNode(this.nodeIdGen.genId(), this.createSrcLoc(defaultTag, new Token[0]));
            msgPluralNode.addChild(msgPluralDefaultNode);
            templateBlock = this.TemplateBlockForMsg();
            if (templateBlock.size() == 1 && (templateBlock.get(0) instanceof MsgPluralNode || templateBlock.get(0) instanceof MsgSelectNode)) {
                this.errorReporter.report(templateBlock.get(0).getSourceLocation(), PLURAL_AND_SELECT_NOT_ALLOWED_INSIDE_PLURAL_BLOCK, new Object[0]);
            }
            msgPluralDefaultNode.addChildren(templateBlock);
            this.jj_consume_token(54);
        }
        catch (ParseException e) {
            this.reportTemplateBodyErrorAndSkipTo(e, 54);
        }
        if ("" != null) {
            return msgPluralNode;
        }
        throw new Error("Missing return statement in function");
    }

    private final MsgSelectNode MsgSelect() throws ParseException {
        Token cmdBegin = this.jj_consume_token(55);
        String cmdText = this.CmdText();
        Token cmdEnd = this.jj_consume_token(68);
        MsgSelectNode msgSelectNode = new MsgSelectNode.Builder(this.nodeIdGen.genId(), cmdText, this.createSrcLoc(cmdBegin, cmdEnd)).build(this.context);
        this.SkipWhitespace();
        try {
            List<SoyNode.StandaloneNode> templateBlock;
            block5: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 60: {
                        break;
                    }
                    default: {
                        this.jj_la1[34] = this.jj_gen;
                        break block5;
                    }
                }
                cmdBegin = this.jj_consume_token(60);
                cmdText = this.CmdText();
                cmdEnd = this.jj_consume_token(68);
                MsgSelectCaseNode msgSelectCaseNode = new MsgSelectCaseNode.Builder(this.nodeIdGen.genId(), cmdText, this.createSrcLoc(cmdBegin, cmdEnd)).build(this.context);
                msgSelectNode.addChild(msgSelectCaseNode);
                templateBlock = this.TemplateBlockForMsg();
                msgSelectCaseNode.addChildren(templateBlock);
            }
            Token defaultTag = this.jj_consume_token(59);
            MsgSelectDefaultNode msgSelectDefaultNode = new MsgSelectDefaultNode(this.nodeIdGen.genId(), this.createSrcLoc(defaultTag, new Token[0]));
            msgSelectNode.addChild(msgSelectDefaultNode);
            templateBlock = this.TemplateBlockForMsg();
            msgSelectDefaultNode.addChildren(templateBlock);
            this.jj_consume_token(56);
        }
        catch (ParseException e) {
            this.reportTemplateBodyErrorAndSkipTo(e, 56);
        }
        if ("" != null) {
            return msgSelectNode;
        }
        throw new Error("Missing return statement in function");
    }

    private final MsgHtmlTagNode MsgHtmlTag() throws ParseException {
        Token htmlTagOpen = this.jj_consume_token(88);
        List<SoyNode.StandaloneNode> templateBlock = this.TemplateBlock();
        this.jj_consume_token(89);
        SourceLocation srcLoc = this.createSrcLoc(htmlTagOpen, new Token[0]);
        if (templateBlock.get(0) instanceof RawTextNode) {
            RawTextNode firstNode = (RawTextNode)templateBlock.get(0);
            RawTextNode newNode = new RawTextNode(this.nodeIdGen.genId(), "<" + firstNode.getRawText(), srcLoc.extend(firstNode.getSourceLocation()));
            templateBlock.set(0, newNode);
        } else {
            templateBlock.add(0, new RawTextNode(this.nodeIdGen.genId(), "<", srcLoc));
        }
        int lastNodeIndex = templateBlock.size() - 1;
        if (templateBlock.get(lastNodeIndex) instanceof RawTextNode) {
            RawTextNode lastNode = (RawTextNode)templateBlock.get(lastNodeIndex);
            RawTextNode newNode = new RawTextNode(this.nodeIdGen.genId(), lastNode.getRawText() + ">", lastNode.getSourceLocation().extend(srcLoc));
            templateBlock.set(lastNodeIndex, newNode);
        } else {
            templateBlock.add(new RawTextNode(this.nodeIdGen.genId(), ">", srcLoc));
        }
        if ("" != null) {
            return new MsgHtmlTagNode.Builder(this.nodeIdGen.genId(), (ImmutableList<SoyNode.StandaloneNode>)ImmutableList.copyOf(templateBlock), this.createSrcLoc(htmlTagOpen, new Token[0])).build(this.errorReporter);
        }
        throw new Error("Missing return statement in function");
    }

    private final SourceItemInfo<List<String>> PrintTag() throws ParseException {
        Token tagBegin;
        ArrayList printTagParts = Lists.newArrayList();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 42: {
                tagBegin = this.jj_consume_token(42);
                printTagParts.add("print");
                break;
            }
            case 67: {
                tagBegin = this.jj_consume_token(67);
                break;
            }
            default: {
                this.jj_la1[35] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        List<String> cmdTextParts = this.CmdTextParts();
        printTagParts.addAll(cmdTextParts);
        Token tagEnd = this.jj_consume_token(68);
        if (!printTagParts.isEmpty()) {
            if (((String)printTagParts.get(0)).startsWith("/")) {
                this.errorReporter.report(this.createSrcLoc(tagBegin, tagEnd), UNEXPECTED_CLOSING_TAG, "{" + Joiner.on((String)"").join((Iterable)printTagParts) + "}");
            } else if (((String)printTagParts.get(0)).startsWith("@")) {
                this.errorReporter.report(this.createSrcLoc(tagBegin, tagEnd), INVALID_DECLARATION, "{" + (String)printTagParts.get(0));
            } else if (((String)printTagParts.get(0)).startsWith("{")) {
                this.errorReporter.report(this.createSrcLoc(tagBegin, tagEnd), FOUND_DOUBLE_BRACE, new Object[0]);
            } else if (INVALID_PRINT_FILE_PREFIX_PATTERN.matcher((CharSequence)printTagParts.get(0)).matches()) {
                this.errorReporter.report(this.createSrcLoc(tagBegin, tagEnd), INVALID_PRINT_FILE_COMMAND, "{" + (String)printTagParts.get(0));
            } else if (INVALID_PRINT_PREFIX_PATTERN.matcher((CharSequence)printTagParts.get(0)).matches()) {
                this.errorReporter.report(this.createSrcLoc(tagBegin, tagEnd), INVALID_PRINT_PREFIX, "{" + (String)printTagParts.get(0));
            }
        }
        if ("" != null) {
            return this.newSourceItemInfo(printTagParts, tagBegin, tagEnd);
        }
        throw new Error("Missing return statement in function");
    }

    private final PrintNode PrintStmt() throws ParseException {
        String userSuppliedPhName;
        boolean isImplicit;
        Token tagBegin;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 42: {
                tagBegin = this.jj_consume_token(42);
                isImplicit = false;
                break;
            }
            case 67: {
                tagBegin = this.jj_consume_token(67);
                isImplicit = true;
                break;
            }
            default: {
                this.jj_la1[36] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        List<String> cmdTextParts = this.CmdTextParts();
        Token tagEnd = this.jj_consume_token(68);
        SourceLocation location = this.createSrcLoc(tagBegin, tagEnd);
        if (cmdTextParts.isEmpty()) {
            this.errorReporter.report(location, PRINT_COMMAND_WITH_EMPTY_TEXT, new Object[0]);
        } else if (cmdTextParts.get(0).startsWith("/")) {
            this.errorReporter.report(location, UNEXPECTED_CLOSING_TAG, "{" + Joiner.on((String)"").join(cmdTextParts) + "}");
        } else if (cmdTextParts.get(0).startsWith("@")) {
            this.errorReporter.report(location, INVALID_DECLARATION, "{" + cmdTextParts.get(0));
        } else if (cmdTextParts.get(0).startsWith("{")) {
            this.errorReporter.report(location, FOUND_DOUBLE_BRACE, new Object[0]);
        } else if (INVALID_PRINT_FILE_PREFIX_PATTERN.matcher(cmdTextParts.get(0)).matches()) {
            this.errorReporter.report(location, INVALID_PRINT_FILE_COMMAND, "{" + cmdTextParts.get(0));
        } else if (INVALID_PRINT_PREFIX_PATTERN.matcher(cmdTextParts.get(0)).matches()) {
            this.errorReporter.report(location, INVALID_PRINT_PREFIX, "{" + cmdTextParts.get(0));
        }
        String cmdText = Joiner.on((String)"").join(cmdTextParts);
        String phnameAttr = null;
        for (String cmdTextPart : cmdTextParts) {
            if (!cmdTextPart.startsWith(" phname=\"") || !cmdTextPart.endsWith("\"")) continue;
            if (phnameAttr != null) {
                this.errorReporter.report(location, MULTIPLE_PHNAME_ATTRIBUTES_IN_COMMAND, cmdText);
            }
            phnameAttr = cmdTextPart;
        }
        if (phnameAttr != null) {
            cmdTextParts.remove(phnameAttr);
            userSuppliedPhName = phnameAttr.substring(9, phnameAttr.length() - 1);
        } else {
            userSuppliedPhName = null;
        }
        String exprText = cmdTextParts.isEmpty() ? "''" : cmdTextParts.get(0).trim();
        PrintNode printNode = new PrintNode.Builder(this.nodeIdGen.genId(), isImplicit, location).exprText(exprText).userSuppliedPlaceholderName(userSuppliedPhName).build(this.context);
        String directiveName = null;
        int n = cmdTextParts.size();
        for (int i = 1; i < n; ++i) {
            String cmdTextPart = cmdTextParts.get(i);
            if (cmdTextPart.startsWith("|")) {
                if (directiveName != null) {
                    printNode.addChild(new PrintDirectiveNode.Builder(this.nodeIdGen.genId(), directiveName, "", location).build(this.context));
                }
                directiveName = cmdTextPart;
                continue;
            }
            if (cmdTextPart.startsWith(":")) {
                if (directiveName == null) {
                    throw new AssertionError();
                }
                String argsText = cmdTextPart.substring(1);
                printNode.addChild(new PrintDirectiveNode.Builder(this.nodeIdGen.genId(), directiveName, argsText, location).build(this.context));
                directiveName = null;
                continue;
            }
            if (cmdTextPart.trim().length() == 0) continue;
            this.errorReporter.report(printNode.getSourceLocation(), INVALID_PRINT_COMMAND_TEXT, cmdText);
        }
        if (directiveName != null) {
            printNode.addChild(new PrintDirectiveNode.Builder(this.nodeIdGen.genId(), directiveName, "", location).build(this.context));
        }
        if ("" != null) {
            return printNode;
        }
        throw new Error("Missing return statement in function");
    }

    private final XidNode XidStmt() throws ParseException {
        Token cmdBegin = this.jj_consume_token(43);
        String cmdText = this.CmdText();
        Token cmdEnd = this.jj_consume_token(68);
        if ("" != null) {
            return new XidNode.Builder(this.nodeIdGen.genId(), cmdText, this.createSrcLoc(cmdBegin, cmdEnd)).build(this.errorReporter);
        }
        throw new Error("Missing return statement in function");
    }

    private final CssNode CssStmt() throws ParseException {
        Token cmdBegin = this.jj_consume_token(44);
        String cmdText = this.CmdText();
        Token cmdEnd = this.jj_consume_token(68);
        if ("" != null) {
            return new CssNode.Builder(this.nodeIdGen.genId(), cmdText, this.createSrcLoc(cmdBegin, cmdEnd)).build(this.context);
        }
        throw new Error("Missing return statement in function");
    }

    private final LetNode LetStmt() throws ParseException {
        LetNode letNode;
        Token tagBegin = this.jj_consume_token(49);
        SourceItemInfo<String> cmdText = this.CmdTextWithSource();
        ErrorReporter.Checkpoint cmdTextCheckpoint = this.errorReporter.checkpoint();
        LetNode.CommandTextParseResult result = LetNode.parseCommandTextHelper(cmdText.parsedContent(), this.context, cmdText.srcLocation());
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 69: {
                Token tagEnd = this.jj_consume_token(69);
                letNode = new LetValueNode.Builder(this.nodeIdGen.genId(), result, this.createSrcLoc(tagBegin, tagEnd)).build(cmdTextCheckpoint, this.errorReporter);
                break;
            }
            case 68: {
                this.pushState(3);
                ErrorReporter.Checkpoint checkpoint = this.errorReporter.checkpoint();
                Token tagEnd = this.jj_consume_token(68);
                LetContentNode letContentNode = new LetContentNode.Builder(this.nodeIdGen.genId(), result, this.createSrcLoc(tagBegin, tagEnd)).build(cmdTextCheckpoint, this.errorReporter);
                List<SoyNode.StandaloneNode> templateBlock = this.TemplateBlock();
                letContentNode.addChildren((List<? extends SoyNode.StandaloneNode>)templateBlock);
                letNode = letContentNode;
                if (this.errorReporter.errorsSince(checkpoint) || this.getToken((int)1).kind != 50) {
                    this.popStateIfStateIs(3);
                } else {
                    this.popState();
                }
                this.jj_consume_token(50);
                break;
            }
            default: {
                this.jj_la1[37] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if ("" != null) {
            return letNode;
        }
        throw new Error("Missing return statement in function");
    }

    private final IfNode IfStmt() throws ParseException {
        Token cmdBegin = this.jj_consume_token(45);
        String cmdText = this.CmdText();
        Token cmdEnd = this.jj_consume_token(68);
        SourceLocation ifTagLocation = this.createSrcLoc(cmdBegin, cmdEnd);
        IfNode ifNode = new IfNode(this.nodeIdGen.genId(), ifTagLocation);
        IfCondNode ifCondNode = IfCondNode.ifBuilder(this.nodeIdGen.genId(), cmdText, ifTagLocation).build(this.context);
        ifNode.addChild(ifCondNode);
        List<SoyNode.StandaloneNode> templateBlock = this.TemplateBlock();
        ifCondNode.addChildren(templateBlock);
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 46: {
                    break;
                }
                default: {
                    this.jj_la1[38] = this.jj_gen;
                    break block6;
                }
            }
            cmdBegin = this.jj_consume_token(46);
            cmdText = this.CmdText();
            cmdEnd = this.jj_consume_token(68);
            SourceLocation elseIfLocation = this.createSrcLoc(cmdBegin, cmdEnd);
            ifCondNode = IfCondNode.elseifBuilder(this.nodeIdGen.genId(), cmdText, elseIfLocation).build(this.context);
            ifNode.addChild(ifCondNode);
            templateBlock = this.TemplateBlock();
            ifCondNode.addChildren(templateBlock);
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 47: {
                Token elseTag = this.jj_consume_token(47);
                IfElseNode ifElseNode = new IfElseNode(this.nodeIdGen.genId(), this.createSrcLoc(elseTag, new Token[0]));
                ifNode.addChild(ifElseNode);
                templateBlock = this.TemplateBlock();
                ifElseNode.addChildren(templateBlock);
                break;
            }
            default: {
                this.jj_la1[39] = this.jj_gen;
            }
        }
        this.jj_consume_token(48);
        if ("" != null) {
            return ifNode;
        }
        throw new Error("Missing return statement in function");
    }

    private final SwitchNode SwitchStmt() throws ParseException {
        Token cmdBegin = this.jj_consume_token(57);
        String cmdText = this.CmdText();
        Token cmdEnd = this.jj_consume_token(68);
        SwitchNode switchNode = new SwitchNode.Builder(this.nodeIdGen.genId(), cmdText, this.createSrcLoc(cmdBegin, cmdEnd)).build(this.context);
        this.SkipWhitespace();
        try {
            List<SoyNode.StandaloneNode> templateBlock;
            block8: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 60: {
                        break;
                    }
                    default: {
                        this.jj_la1[40] = this.jj_gen;
                        break block8;
                    }
                }
                cmdBegin = this.jj_consume_token(60);
                cmdText = this.CmdText();
                cmdEnd = this.jj_consume_token(68);
                SwitchCaseNode switchCaseNode = new SwitchCaseNode.Builder(this.nodeIdGen.genId(), cmdText, this.createSrcLoc(cmdBegin, cmdEnd)).build(this.context);
                switchNode.addChild(switchCaseNode);
                templateBlock = this.TemplateBlock();
                switchCaseNode.addChildren(templateBlock);
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 59: {
                    Token defaultTag = this.jj_consume_token(59);
                    SwitchDefaultNode switchDefaultNode = new SwitchDefaultNode(this.nodeIdGen.genId(), this.createSrcLoc(defaultTag, new Token[0]));
                    switchNode.addChild(switchDefaultNode);
                    templateBlock = this.TemplateBlock();
                    switchDefaultNode.addChildren(templateBlock);
                    break;
                }
                default: {
                    this.jj_la1[41] = this.jj_gen;
                }
            }
            this.jj_consume_token(58);
        }
        catch (ParseException e) {
            this.reportTemplateBodyErrorAndSkipTo(e, 58);
        }
        if ("" != null) {
            return switchNode;
        }
        throw new Error("Missing return statement in function");
    }

    private final ForeachNode ForeachStmt() throws ParseException {
        Token cmdBegin = this.jj_consume_token(61);
        String cmdText = this.CmdText();
        Token cmdEnd = this.jj_consume_token(68);
        ForeachBuilder builder = ForeachBuilder.create(this.nodeIdGen, this.context).setCommandLocation(this.createSrcLoc(cmdBegin, cmdEnd)).setCommandText(cmdText);
        List<SoyNode.StandaloneNode> templateBlock = this.TemplateBlock();
        builder.setLoopBody(templateBlock);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 62: {
                Token ifemptyTag = this.jj_consume_token(62);
                templateBlock = this.TemplateBlock();
                builder.setIfEmptyBody(this.createSrcLoc(ifemptyTag, new Token[0]), templateBlock);
                break;
            }
            default: {
                this.jj_la1[42] = this.jj_gen;
            }
        }
        this.jj_consume_token(63);
        if ("" != null) {
            return builder.build();
        }
        throw new Error("Missing return statement in function");
    }

    private final ForNode ForStmt() throws ParseException {
        Token cmdBegin = this.jj_consume_token(51);
        String cmdText = this.CmdText();
        Token cmdEnd = this.jj_consume_token(68);
        ForNode forNode = new ForNode(this.nodeIdGen.genId(), cmdText, this.createSrcLoc(cmdBegin, cmdEnd), this.context);
        List<SoyNode.StandaloneNode> templateBlock = this.TemplateBlock();
        forNode.addChildren(templateBlock);
        this.jj_consume_token(52);
        if ("" != null) {
            return forNode;
        }
        throw new Error("Missing return statement in function");
    }

    private final CallNode CallStmt() throws ParseException {
        CallNode callNode = null;
        block2 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 33: {
                Token tagBegin = this.jj_consume_token(33);
                List<String> cmdTextParts = this.CmdTextParts();
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 69: {
                        Token tagEnd = this.jj_consume_token(69);
                        callNode = this.setCommandTextAndPlaceholderName(new CallBasicNode.Builder(this.nodeIdGen.genId(), this.createSrcLoc(tagBegin, tagEnd)), cmdTextParts).build(this.context);
                        break block2;
                    }
                    case 68: {
                        Token tagEnd = this.jj_consume_token(68);
                        callNode = this.setCommandTextAndPlaceholderName(new CallBasicNode.Builder(this.nodeIdGen.genId(), this.createSrcLoc(tagBegin, tagEnd)), cmdTextParts).build(this.context);
                        try {
                            this.AddParams(callNode);
                            this.jj_consume_token(35);
                        }
                        catch (ParseException e) {
                            this.reportTemplateBodyErrorAndSkipTo(e, 35);
                        }
                        break block2;
                    }
                }
                this.jj_la1[43] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            case 34: {
                Token tagBegin = this.jj_consume_token(34);
                List<String> cmdTextParts = this.CmdTextParts();
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 69: {
                        Token tagEnd = this.jj_consume_token(69);
                        callNode = this.setCommandTextAndPlaceholderName(new CallDelegateNode.Builder(this.nodeIdGen.genId(), this.createSrcLoc(tagBegin, tagEnd)), cmdTextParts).build(this.context);
                        break block2;
                    }
                    case 68: {
                        Token tagEnd = this.jj_consume_token(68);
                        callNode = this.setCommandTextAndPlaceholderName(new CallDelegateNode.Builder(this.nodeIdGen.genId(), this.createSrcLoc(tagBegin, tagEnd)), cmdTextParts).build(this.context);
                        try {
                            this.AddParams(callNode);
                            this.jj_consume_token(36);
                        }
                        catch (ParseException e) {
                            this.reportTemplateBodyErrorAndSkipTo(e, 36);
                        }
                        break block2;
                    }
                }
                this.jj_la1[44] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[45] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if ("" != null) {
            return callNode;
        }
        throw new Error("Missing return statement in function");
    }

    private CallNode.Builder setCommandTextAndPlaceholderName(CallNode.Builder builder, List<String> cmdTextParts) throws ParseException {
        StringBuilder cmdTextSb = new StringBuilder();
        String phnameAttr = null;
        for (int i = 0; i < cmdTextParts.size(); ++i) {
            String cmdTextPart = cmdTextParts.get(i);
            if (cmdTextPart.startsWith(" phname=\"") && cmdTextPart.endsWith("\"")) {
                if (phnameAttr != null) {
                    this.errorReporter.report(builder.getSourceLocation(), MULTIPLE_PHNAME_ATTRIBUTES_IN_COMMAND, Joiner.on((String)"").join(cmdTextParts));
                }
                phnameAttr = cmdTextPart;
                continue;
            }
            cmdTextSb.append(cmdTextPart);
        }
        String userSuppliedPhName = phnameAttr != null ? phnameAttr.substring(9, phnameAttr.length() - 1) : null;
        return builder.commandText(cmdTextSb.toString()).userSuppliedPlaceholderName(userSuppliedPhName);
    }

    private final void AddParams(CallNode callNode) throws ParseException {
        this.SkipWhitespace();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 37: {
                    break;
                }
                default: {
                    this.jj_la1[46] = this.jj_gen;
                    break block3;
                }
            }
            CallParamNode callParam = this.CallParam();
            callNode.addChild(callParam);
            this.SkipWhitespace();
        }
    }

    private final CallParamNode CallParam() throws ParseException {
        CallParamNode callParamNode = null;
        Token tagBegin = this.jj_consume_token(37);
        SourceItemInfo<String> cmdText = this.CmdTextWithSource();
        ErrorReporter.Checkpoint cmdTextCheckpoint = this.errorReporter.checkpoint();
        CallParamNode.CommandTextParseResult result = CallParamNode.parseCommandTextHelper(cmdText.parsedContent(), this.context, cmdText.srcLocation());
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 69: {
                Token tagEnd = this.jj_consume_token(69);
                callParamNode = new CallParamValueNode.Builder(this.nodeIdGen.genId(), result, this.createSrcLoc(tagBegin, tagEnd)).build(cmdTextCheckpoint, this.errorReporter);
                break;
            }
            case 68: {
                this.pushState(3);
                ErrorReporter.Checkpoint checkpoint = this.errorReporter.checkpoint();
                Token tagEnd = this.jj_consume_token(68);
                CallParamContentNode cpcn = new CallParamContentNode.Builder(this.nodeIdGen.genId(), result, this.createSrcLoc(tagBegin, tagEnd)).build(cmdTextCheckpoint, this.errorReporter);
                List<SoyNode.StandaloneNode> templateBlock = this.TemplateBlock();
                cpcn.addChildren((List<? extends SoyNode.StandaloneNode>)templateBlock);
                callParamNode = cpcn;
                if (this.errorReporter.errorsSince(checkpoint) || this.getToken((int)1).kind != 38) {
                    this.popStateIfStateIs(3);
                } else {
                    this.popState();
                }
                this.jj_consume_token(38);
                break;
            }
            default: {
                this.jj_la1[47] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if ("" != null) {
            return callParamNode;
        }
        throw new Error("Missing return statement in function");
    }

    private final LogNode LogStmt() throws ParseException {
        Token open = this.jj_consume_token(64);
        LogNode logNode = new LogNode(this.nodeIdGen.genId(), this.createSrcLoc(open, new Token[0]));
        List<SoyNode.StandaloneNode> templateBlock = this.TemplateBlock();
        logNode.addChildren(templateBlock);
        this.jj_consume_token(65);
        if ("" != null) {
            return logNode;
        }
        throw new Error("Missing return statement in function");
    }

    private final DebuggerNode DebuggerStmt() throws ParseException {
        Token token = this.jj_consume_token(66);
        if ("" != null) {
            return new DebuggerNode(this.nodeIdGen.genId(), this.createSrcLoc(token, new Token[0]));
        }
        throw new Error("Missing return statement in function");
    }

    private final TypeNode TypeExpr() throws ParseException {
        TypeNode first = null;
        TypeNode next = null;
        ArrayList<TypeNode> members = null;
        first = this.PrimaryType();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 84: {
                    break;
                }
                default: {
                    this.jj_la1[48] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(84);
            next = this.PrimaryType();
            if (members == null) {
                members = new ArrayList<TypeNode>();
                members.add(first);
            }
            members.add(next);
        }
        if ("" != null) {
            return members == null ? first : UnionTypeNode.create((Iterable<TypeNode>)members);
        }
        throw new Error("Missing return statement in function");
    }

    private final TypeNode PrimaryType() throws ParseException {
        TypeNode type;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 76: {
                type = this.NamedType();
                break;
            }
            case 85: {
                type = this.UnknownType();
                break;
            }
            case 80: {
                type = this.RecordType();
                break;
            }
            default: {
                this.jj_la1[49] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if ("" != null) {
            return type;
        }
        throw new Error("Missing return statement in function");
    }

    private final TypeNode RecordType() throws ParseException {
        Object properties = ImmutableList.of();
        Token open = this.jj_consume_token(80);
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 76: {
                RecordTypeNode.Property prop = this.RecordField();
                properties = new ArrayList();
                properties.add(prop);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 82: {
                            break;
                        }
                        default: {
                            this.jj_la1[50] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(82);
                    prop = this.RecordField();
                    properties.add(prop);
                }
            }
            default: {
                this.jj_la1[51] = this.jj_gen;
            }
        }
        Token close = this.jj_consume_token(81);
        if ("" != null) {
            return RecordTypeNode.create(this.createSrcLoc(open, close), (Iterable<RecordTypeNode.Property>)properties);
        }
        throw new Error("Missing return statement in function");
    }

    private final RecordTypeNode.Property RecordField() throws ParseException {
        Token fieldName = this.jj_consume_token(76);
        this.jj_consume_token(83);
        TypeNode fieldType = this.TypeExpr();
        if ("" != null) {
            return RecordTypeNode.Property.create(this.createSrcLoc(fieldName, new Token[0]), fieldName.image, fieldType);
        }
        throw new Error("Missing return statement in function");
    }

    private final TypeNode NamedType() throws ParseException {
        Token next = null;
        Object genericArgs = ImmutableList.of();
        StringBuilder sb = null;
        Token first = this.jj_consume_token(76);
        block12: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 77: {
                    break;
                }
                default: {
                    this.jj_la1[52] = this.jj_gen;
                    break block12;
                }
            }
            this.jj_consume_token(77);
            next = this.jj_consume_token(76);
            if (sb == null) {
                sb = new StringBuilder(first.image);
            }
            sb.append('.');
            sb.append(next.image);
        }
        String ident = sb == null ? first.image : sb.toString();
        SourceLocation fullLocation = next == null ? this.createSrcLoc(first, new Token[0]) : this.createSrcLoc(first, next);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 78: {
                Token open = this.jj_consume_token(78);
                block6 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 76: 
                    case 80: 
                    case 85: {
                        TypeNode arg = this.TypeExpr();
                        genericArgs = new ArrayList();
                        genericArgs.add(arg);
                        while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                case 82: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[53] = this.jj_gen;
                                    break block6;
                                }
                            }
                            this.jj_consume_token(82);
                            arg = this.TypeExpr();
                            genericArgs.add(arg);
                        }
                    }
                    default: {
                        this.jj_la1[54] = this.jj_gen;
                    }
                }
                Token close = this.jj_consume_token(79);
                if ("" == null) break;
                return GenericTypeNode.create(fullLocation.extend(this.createSrcLoc(close, new Token[0])), ident, (Iterable<? extends TypeNode>)genericArgs);
            }
            default: {
                this.jj_la1[55] = this.jj_gen;
            }
        }
        if ("" != null) {
            return NamedTypeNode.create(fullLocation, ident);
        }
        throw new Error("Missing return statement in function");
    }

    private final TypeNode UnknownType() throws ParseException {
        Token tok = this.jj_consume_token(85);
        if ("" != null) {
            return NamedTypeNode.create(this.createSrcLoc(tok, new Token[0]), "?");
        }
        throw new Error("Missing return statement in function");
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{1024, 512, 256, 98304, 0, 0, 98304, 0, 0, 0, 0, 0, 0, 0, -33554432, -33554432, -33554432, 0xF00000, 0, 0xF00000, 0xF00000, -33554432, -33554432, 0, 0, 0, 0, 0, 0, 0, -33554432, 0, -33554432, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    }

    private static void jj_la1_init_1() {
        jj_la1_1 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 571096199, 571096199, 571096198, 131072, 7302, 0x22082000, 256, 0, 0, 10486791, 0xA00000, 10486791, 0x10000000, 0x10000000, 1024, 1024, 0, 16384, 32768, 0x10000000, 0x8000000, 0x40000000, 0, 0, 6, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    }

    private static void jj_la1_init_2() {
        jj_la1_2 = new int[]{0, 0, 0, 0, 2048, 4096, 0, 12288, 8192, 0x4000C0, 192, 0x4000C0, 0x10000000, 0x30000000, 0, 0x30000000, 0x30000000, 0x10000000, 0x10000000, 0x10000000, 0, 0x3000000D, 0x3000000D, 13, 5, 8, 0, 0, 0x10000000, 0x10000000, 822083592, 0, 822083592, 0, 0, 8, 8, 48, 0, 0, 0, 0, 0, 48, 48, 0, 0, 48, 0x100000, 0x211000, 262144, 4096, 8192, 262144, 0x211000, 16384};
    }

    private static void jj_la1_init_3() {
        jj_la1_3 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    }

    public SoyFileParser(InputStream stream) {
        this(stream, null);
    }

    public SoyFileParser(InputStream stream, String encoding) {
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new SoyFileParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 56; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 56; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public SoyFileParser(Reader stream) {
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new SoyFileParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 56; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(Reader stream) {
        if (this.jj_input_stream == null) {
            this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        } else {
            this.jj_input_stream.ReInit(stream, 1, 1);
        }
        if (this.token_source == null) {
            this.token_source = new SoyFileParserTokenManager(this.jj_input_stream);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 56; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public SoyFileParser(SoyFileParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 56; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(SoyFileParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 56; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk_f() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[103];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 56; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) != 0) {
                    la1tokens[32 + j] = true;
                }
                if ((jj_la1_2[i] & 1 << j) != 0) {
                    la1tokens[64 + j] = true;
                }
                if ((jj_la1_3[i] & 1 << j) == 0) continue;
                la1tokens[96 + j] = true;
            }
        }
        for (i = 0; i < 103; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    static {
        SoyFileParser.jj_la1_init_0();
        SoyFileParser.jj_la1_init_1();
        SoyFileParser.jj_la1_init_2();
        SoyFileParser.jj_la1_init_3();
    }

    private static final class AbortParsingError
    extends Error {
        private AbortParsingError() {
        }
    }

    static class RegexFromTokenImageFunction
    implements Function<String, String> {
        RegexFromTokenImageFunction() {
        }

        public String apply(String o) {
            return Pattern.quote(o.substring(2, o.length() - 2));
        }
    }
}

