/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soyparse;

import com.google.common.collect.ImmutableSet;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.BaseUtils;
import com.google.template.soy.base.internal.LegacyInternalSyntaxException;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.soyparse.ParseException;
import com.google.template.soy.soyparse.SoyFileParserConstants;
import com.google.template.soy.soyparse.Token;
import com.google.template.soy.soyparse.TokenMgrError;
import com.google.template.soy.soyparse.Tokens;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class ParseErrors {
    private static final Pattern EXTRACT_LOCATION = Pattern.compile("at line (\\d+), column (\\d+).");
    private static final SoyErrorKind UNEXPECTED_TOKEN_MGR_ERROR = SoyErrorKind.of("Unexpected fatal Soy error. Please file a bug with your Soy file and we''ll take a look.  {0}");
    private static final SoyErrorKind UNEXPECTED_EOF = SoyErrorKind.of("Unexpected end of file.  Did you forget to close an attribute value or a comment?");
    private static final SoyErrorKind INVALID_STRING_LITERAL = SoyErrorKind.of("Invalid string literal found in Soy command.");
    private static final SoyErrorKind UNEXPECTED_RIGHT_BRACE = SoyErrorKind.of("Unexpected ''}''; did you mean '''{'rb'}'''?");
    private static final SoyErrorKind BAD_PHNAME_VALUE = SoyErrorKind.of("Found ''phname'' attribute that is not a valid identifier");
    private static final SoyErrorKind UNEXPECTED_PARAM_DECL = SoyErrorKind.of("Unexpected parameter declaration. Param declarations must come before any code in your template.");

    private ParseErrors() {
    }

    static void reportSoyFileParseException(ErrorReporter reporter, String filePath, ParseException e) {
        Token errorToken = e.currentToken;
        if (errorToken.next != null) {
            errorToken = errorToken.next;
        }
        SourceLocation location = Tokens.createSrcLoc(filePath, errorToken, new Token[0]);
        switch (errorToken.kind) {
            case 24: {
                reporter.report(location, UNEXPECTED_RIGHT_BRACE, new Object[0]);
                return;
            }
            case 87: {
                reporter.report(location, INVALID_STRING_LITERAL, new Object[0]);
                return;
            }
            case 72: {
                reporter.report(location, BAD_PHNAME_VALUE, new Object[0]);
                return;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                reporter.report(location, UNEXPECTED_PARAM_DECL, new Object[0]);
                return;
            }
        }
        ImmutableSet.Builder expectedTokenImages = ImmutableSet.builder();
        for (int[] expected : e.expectedTokenSequences) {
            expectedTokenImages.add((Object)ParseErrors.getSoyFileParserTokenDisplayName(expected[0]));
        }
        reporter.report(location, SoyErrorKind.of("{0}"), BaseUtils.formatParseExceptionDetails(errorToken.image, (List<String>)expectedTokenImages.build().asList()));
    }

    private static String getSoyFileParserTokenDisplayName(int tokenId) {
        switch (tokenId) {
            case 12: {
                return "attribute-value";
            }
            case 15: {
                return "{deltemplate";
            }
            case 16: {
                return "{template";
            }
            case 33: {
                return "{call";
            }
            case 35: {
                return "{/call}";
            }
            case 34: {
                return "{delcall";
            }
            case 36: {
                return "{/delcall}";
            }
            case 76: {
                return "identifier";
            }
            case 0: {
                return "eof";
            }
            case 37: {
                return "{param";
            }
            case 39: {
                return "{msg";
            }
            case 40: {
                return "{fallbackmsg";
            }
            case 42: {
                return "{print";
            }
            case 43: {
                return "{xid";
            }
            case 44: {
                return "{css";
            }
            case 45: {
                return "{if";
            }
            case 46: {
                return "{elseif";
            }
            case 49: {
                return "{let";
            }
            case 51: {
                return "{for";
            }
            case 53: {
                return "{plural";
            }
            case 55: {
                return "{select";
            }
            case 57: {
                return "{switch";
            }
            case 60: {
                return "{case";
            }
            case 61: {
                return "{foreach";
            }
            case 32: {
                return "{literal";
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 93: {
                return "text";
            }
            case 92: {
                return "whitespace";
            }
            case 102: {
                throw new AssertionError((Object)"we should never expect the unexpected token");
            }
        }
        return SoyFileParserConstants.tokenImage[tokenId];
    }

    static void report(ErrorReporter reporter, String filePath, LegacyInternalSyntaxException exception) {
        SourceLocation sourceLocation = exception.getSourceLocation();
        if (!sourceLocation.isKnown()) {
            sourceLocation = new SourceLocation(filePath);
        }
        reporter.report(sourceLocation, SoyErrorKind.of("{0}"), exception.getOriginalMessage());
    }

    static void reportTokenMgrError(ErrorReporter reporter, String filePath, TokenMgrError exception) {
        Matcher line;
        String message = exception.getMessage();
        if (exception.errorCode == 0 && message.contains("<EOF>") && (line = EXTRACT_LOCATION.matcher(message)).find()) {
            int startLine = Integer.parseInt(line.group(1));
            int column = Integer.parseInt(line.group(2)) + 1;
            reporter.report(new SourceLocation(filePath, startLine, column, startLine, column), UNEXPECTED_EOF, new Object[0]);
            return;
        }
        reporter.report(new SourceLocation(filePath), UNEXPECTED_TOKEN_MGR_ERROR, message);
    }
}

