/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soyparse;

import com.google.template.soy.soyparse.SoyFileParserTokenManager;
import java.util.NoSuchElementException;

final class LexicalStateStack {
    private int[] elements = new int[16];
    private int size = 0;

    LexicalStateStack() {
    }

    void push(int element) {
        if (element < 0 || element >= SoyFileParserTokenManager.lexStateNames.length) {
            throw new IllegalArgumentException("Invalid lexical state: " + element);
        }
        int localSize = this.size;
        int[] localElements = this.elements;
        if (localSize + 1 == localElements.length) {
            localElements = this.doubleCapacity();
        }
        localElements[localSize] = element;
        this.size = localSize + 1;
    }

    int pop() {
        int localSize = this.size;
        if (localSize == 0) {
            throw new NoSuchElementException();
        }
        this.size = --localSize;
        return this.elements[localSize];
    }

    void clear() {
        this.size = 0;
    }

    int size() {
        return this.size;
    }

    int peek() {
        int localSize = this.size;
        if (localSize == 0) {
            return -1;
        }
        return this.elements[localSize - 1];
    }

    private int[] doubleCapacity() {
        int oldCapacity = this.elements.length;
        int newCapacity = oldCapacity << 1;
        if (newCapacity < 0) {
            if (oldCapacity == Integer.MAX_VALUE) {
                throw new IllegalStateException("Sorry, stack too big");
            }
            newCapacity = Integer.MAX_VALUE;
        }
        int[] newElements = new int[newCapacity];
        System.arraycopy(this.elements, 0, newElements, 0, oldCapacity);
        this.elements = newElements;
        return newElements;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        for (int i = 0; i < this.size; ++i) {
            sb.append(SoyFileParserTokenManager.lexStateNames[this.elements[i]]);
            if (i >= this.size - 1) continue;
            sb.append(", ");
        }
        sb.append(']');
        return sb.toString();
    }
}

