/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.passes.CompilerFilePass;
import com.google.template.soy.passes.Condition;
import com.google.template.soy.passes.ConditionalBranches;
import com.google.template.soy.passes.HtmlTagEntry;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.AutoescapeMode;
import com.google.template.soy.soytree.ExprUnion;
import com.google.template.soy.soytree.HtmlCloseTagNode;
import com.google.template.soy.soytree.HtmlOpenTagNode;
import com.google.template.soy.soytree.IfCondNode;
import com.google.template.soy.soytree.IfElseNode;
import com.google.template.soy.soytree.IfNode;
import com.google.template.soy.soytree.NamespaceDeclaration;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.StrictHtmlMode;
import com.google.template.soy.soytree.SwitchCaseNode;
import com.google.template.soy.soytree.SwitchDefaultNode;
import com.google.template.soy.soytree.SwitchNode;
import com.google.template.soy.soytree.TagName;
import com.google.template.soy.soytree.TemplateNode;
import java.util.ArrayDeque;
import java.util.List;

final class StrictHtmlValidationPass
extends CompilerFilePass {
    private static final SoyErrorKind STRICT_HTML_DISABLED = SoyErrorKind.of("Strict HTML mode is disabled by default. In order to use stricthtml syntax in your Soy template, explicitly pass --enabledExperimentalFeatures=stricthtml to compiler.");
    private static final SoyErrorKind STRICT_HTML_WITHOUT_AUTOESCAPE = SoyErrorKind.of("stricthtml=\"true\" must be used with autoescape=\"strict\".");
    private static final SoyErrorKind STRICT_HTML_WITH_NON_HTML = SoyErrorKind.of("stricthtml=\"true\" can only be used with kind=\"html\".");
    private static final SoyErrorKind UNEXPECTED_CLOSE_TAG = SoyErrorKind.of("Unexpected HTML close tag.");
    private static final SoyErrorKind OPEN_TAG_NOT_CLOSED = SoyErrorKind.of("Expected tag to be closed in this block.");
    private static final SoyErrorKind INVALID_SELF_CLOSING_TAG = SoyErrorKind.of("''{0}'' tag is not allowed to be self-closing.");
    private static final SoyErrorKind INVALID_CLOSE_TAG = SoyErrorKind.of("''{0}'' tag is a void element and must not specify a close tag.");
    private final boolean enabledStrictHtml;
    private final ErrorReporter errorReporter;
    private static final ImmutableSet<String> VOID_TAG_NAMES = ImmutableSet.of((Object)"area", (Object)"base", (Object)"br", (Object)"col", (Object)"command", (Object)"embed", (Object[])new String[]{"hr", "img", "input", "keygen", "link", "meta", "param", "source", "track", "wbr"});

    StrictHtmlValidationPass(ImmutableList<String> experimentalFeatures, ErrorReporter errorReporter) {
        this.enabledStrictHtml = experimentalFeatures.contains((Object)"stricthtml");
        this.errorReporter = errorReporter;
    }

    @Override
    public void run(SoyFileNode file, IdGenerator nodeIdGen) {
        NamespaceDeclaration namespace = file.getNamespaceDeclaration();
        if (namespace.getStrictHtmlMode() != StrictHtmlMode.UNSET) {
            if (!this.enabledStrictHtml && namespace.getStrictHtmlMode() == StrictHtmlMode.YES) {
                this.errorReporter.report(namespace.getStrictHtmlModeLocation(), STRICT_HTML_DISABLED, new Object[0]);
                return;
            }
            if (namespace.getDefaultAutoescapeMode() != AutoescapeMode.STRICT && namespace.getStrictHtmlMode() == StrictHtmlMode.YES) {
                this.errorReporter.report(namespace.getAutoescapeModeLocation(), STRICT_HTML_WITHOUT_AUTOESCAPE, new Object[0]);
                return;
            }
        }
        for (TemplateNode node : file.getChildren()) {
            this.checkTemplateNode(node);
        }
    }

    private void checkTemplateNode(TemplateNode node) {
        if (!this.enabledStrictHtml && node.isStrictHtml()) {
            this.errorReporter.report(node.getSourceLocation(), STRICT_HTML_DISABLED, new Object[0]);
            return;
        }
        AutoescapeMode autoescapeMode = node.getAutoescapeMode();
        if (autoescapeMode != AutoescapeMode.STRICT && node.isStrictHtml()) {
            this.errorReporter.report(node.getSourceLocation(), STRICT_HTML_WITHOUT_AUTOESCAPE, new Object[0]);
            return;
        }
        SanitizedContent.ContentKind contentKind = node.getContentKind();
        if (contentKind != SanitizedContent.ContentKind.HTML && node.isStrictHtml()) {
            this.errorReporter.report(node.getSourceLocation(), STRICT_HTML_WITH_NON_HTML, new Object[0]);
            return;
        }
        if (node.isStrictHtml()) {
            new HtmlTagVisitor(this.errorReporter).exec(node);
        }
    }

    private static final class HtmlTagVisitor
    extends AbstractSoyNodeVisitor<Void> {
        private Condition currentCondition = Condition.getEmptyCondition();
        private final ConditionalBranches openTagBranches = new ConditionalBranches();
        private final ConditionalBranches closeTagBranches = new ConditionalBranches();
        private final ArrayDeque<HtmlTagEntry> openTagStack = new ArrayDeque();
        private final ArrayDeque<HtmlTagEntry> closeTagQueue = new ArrayDeque();
        private final ErrorReporter errorReporter;

        HtmlTagVisitor(ErrorReporter errorReporter) {
            this.errorReporter = errorReporter;
        }

        @Override
        protected void visitHtmlOpenTagNode(HtmlOpenTagNode node) {
            if (node.getTagName().isStatic() && !HtmlTagVisitor.isDefinitelyVoid(node) && node.isSelfClosing()) {
                this.errorReporter.report(node.getSourceLocation(), INVALID_SELF_CLOSING_TAG, node.getTagName().getStaticTagName().getRawText());
                return;
            }
            if (!node.isSelfClosing() && !HtmlTagVisitor.isDefinitelyVoid(node)) {
                this.openTagStack.push(new HtmlTagEntry(node.getTagName()));
            }
        }

        @Override
        protected void visitHtmlCloseTagNode(HtmlCloseTagNode node) {
            if (HtmlTagVisitor.isDefinitelyVoid(node)) {
                this.errorReporter.report(node.getSourceLocation(), INVALID_CLOSE_TAG, node.getTagName().getStaticTagName().getRawText());
                return;
            }
            if (!this.openTagStack.isEmpty() && this.openTagStack.peek().hasTagName()) {
                TagName openTag = this.openTagStack.pop().getTagName();
                TagName closeTag = node.getTagName();
                HtmlTagEntry.matchOrError(openTag, closeTag, this.errorReporter);
            } else {
                this.closeTagQueue.add(new HtmlTagEntry(node.getTagName()));
            }
        }

        @Override
        protected void visitIfNode(IfNode node) {
            ConditionalBranches outerOpenTagBranches = new ConditionalBranches(this.openTagBranches);
            ConditionalBranches outerCloseTagBranches = new ConditionalBranches(this.closeTagBranches);
            this.openTagBranches.clear();
            this.closeTagBranches.clear();
            this.visitChildren(node);
            if (!this.openTagBranches.isEmpty()) {
                this.openTagStack.push(new HtmlTagEntry(this.openTagBranches));
                this.openTagBranches.clear();
            }
            if (!this.closeTagBranches.isEmpty()) {
                this.closeTagQueue.add(new HtmlTagEntry(this.closeTagBranches));
                this.closeTagBranches.clear();
            }
            this.openTagBranches.addAll(outerOpenTagBranches);
            this.closeTagBranches.addAll(outerCloseTagBranches);
        }

        @Override
        protected void visitIfCondNode(IfCondNode node) {
            Condition outerCondition = this.currentCondition.copy();
            this.currentCondition = Condition.createIfCondition(node.getExprUnion());
            this.visitBlockChildren(node, true);
            this.currentCondition = outerCondition.copy();
        }

        @Override
        protected void visitIfElseNode(IfElseNode node) {
            Condition outerCondition = this.currentCondition.copy();
            this.currentCondition = Condition.createIfCondition();
            this.visitBlockChildren(node, true);
            this.currentCondition = outerCondition.copy();
        }

        @Override
        protected void visitSwitchNode(SwitchNode node) {
            ConditionalBranches outerOpenTagBranches = new ConditionalBranches(this.openTagBranches);
            ConditionalBranches outerCloseTagBranches = new ConditionalBranches(this.closeTagBranches);
            this.openTagBranches.clear();
            this.closeTagBranches.clear();
            this.visitChildren(node);
            if (!this.openTagBranches.isEmpty()) {
                this.openTagStack.push(new HtmlTagEntry(this.openTagBranches));
                this.openTagBranches.clear();
            }
            if (!this.closeTagBranches.isEmpty()) {
                this.closeTagQueue.add(new HtmlTagEntry(this.closeTagBranches));
                this.closeTagBranches.clear();
            }
            this.openTagBranches.addAll(outerOpenTagBranches);
            this.closeTagBranches.addAll(outerCloseTagBranches);
        }

        @Override
        protected void visitSwitchCaseNode(SwitchCaseNode node) {
            Condition outerCondition = this.currentCondition.copy();
            SwitchNode parent = (SwitchNode)node.getParent();
            this.currentCondition = Condition.createSwitchCondition(new ExprUnion(parent.getExpr()), node.getAllExprUnions());
            this.visitBlockChildren(node, true);
            this.currentCondition = outerCondition.copy();
        }

        @Override
        protected void visitSwitchDefaultNode(SwitchDefaultNode node) {
            Condition outerCondition = this.currentCondition.copy();
            SwitchNode parent = (SwitchNode)node.getParent();
            this.currentCondition = Condition.createSwitchCondition(new ExprUnion(parent.getExpr()), (List<ExprUnion>)ImmutableList.of());
            this.visitBlockChildren(node, true);
            this.currentCondition = outerCondition.copy();
        }

        private void matchTagsInDeques() {
            HtmlTagEntry entry;
            while (!this.openTagStack.isEmpty() && !this.closeTagQueue.isEmpty()) {
                HtmlTagEntry closeTag;
                HtmlTagEntry openTag = this.openTagStack.pop();
                if (!openTag.hasTagName() && openTag.getBranches().isEmpty() || HtmlTagEntry.matchOrError(openTag, closeTag = this.closeTagQueue.poll(), this.errorReporter)) continue;
                return;
            }
            if (this.openTagStack.isEmpty() && this.closeTagQueue.isEmpty()) {
                return;
            }
            if (this.openTagStack.isEmpty()) {
                entry = this.closeTagQueue.poll();
                this.errorReporter.report(entry.getSourceLocation(), UNEXPECTED_CLOSE_TAG, new Object[0]);
            } else {
                entry = this.openTagStack.pop();
                this.errorReporter.report(entry.getSourceLocation(), OPEN_TAG_NOT_CLOSED, new Object[0]);
            }
        }

        @Override
        protected void visitTemplateNode(TemplateNode node) {
            ErrorReporter.Checkpoint checkpoint = this.errorReporter.checkpoint();
            this.visitChildren(node);
            if (this.errorReporter.errorsSince(checkpoint)) {
                return;
            }
            this.matchTagsInDeques();
        }

        private static boolean isDefinitelyVoid(HtmlOpenTagNode node) {
            return HtmlTagVisitor.isDefinitelyVoid(node.getTagName().getStaticTagNameAsLowerCase());
        }

        private static boolean isDefinitelyVoid(HtmlCloseTagNode node) {
            return HtmlTagVisitor.isDefinitelyVoid(node.getTagName().getStaticTagNameAsLowerCase());
        }

        private static boolean isDefinitelyVoid(Optional<String> staticTagName) {
            return VOID_TAG_NAMES.contains(staticTagName.orNull());
        }

        @Override
        protected void visitSoyNode(SoyNode node) {
            if (node instanceof SoyNode.ParentSoyNode) {
                if (node instanceof SoyNode.BlockNode) {
                    this.visitBlockChildren((SoyNode.BlockNode)node, false);
                } else {
                    this.visitChildren((SoyNode.ParentSoyNode)node);
                }
            }
        }

        private void visitBlockChildren(SoyNode.BlockNode node, boolean inControlBlock) {
            ArrayDeque<HtmlTagEntry> outerOpenTagStack = new ArrayDeque<HtmlTagEntry>();
            ArrayDeque<HtmlTagEntry> outerCloseTagQueue = new ArrayDeque<HtmlTagEntry>();
            outerOpenTagStack.addAll(this.openTagStack);
            outerCloseTagQueue.addAll(this.closeTagQueue);
            this.openTagStack.clear();
            this.closeTagQueue.clear();
            this.visitChildren(node);
            if (inControlBlock) {
                if (!this.openTagStack.isEmpty()) {
                    this.openTagBranches.add(this.currentCondition, this.openTagStack);
                }
                if (!this.closeTagQueue.isEmpty()) {
                    this.closeTagBranches.add(this.currentCondition, this.closeTagQueue);
                }
            } else {
                HtmlTagEntry.matchOrError(this.openTagStack, this.closeTagQueue, this.errorReporter);
            }
            this.openTagStack.clear();
            this.closeTagQueue.clear();
            this.openTagStack.addAll(outerOpenTagStack);
            this.closeTagQueue.addAll(outerCloseTagQueue);
        }
    }
}

