/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.basetree.SyntaxVersion;
import com.google.template.soy.basicfunctions.LengthFunction;
import com.google.template.soy.basicfunctions.ParseIntFunction;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.exprtree.AbstractExprNodeVisitor;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.exprtree.MapLiteralNode;
import com.google.template.soy.exprtree.VarRefNode;
import com.google.template.soy.passes.CompilerFilePass;
import com.google.template.soy.shared.internal.BuiltinFunction;
import com.google.template.soy.shared.restricted.SoyFunction;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyTreeUtils;
import com.google.template.soy.soytree.defn.LoopVar;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.aggregate.ListType;
import com.google.template.soy.types.primitive.AnyType;
import com.google.template.soy.types.primitive.StringType;
import java.util.Set;

final class CheckFunctionCallsPass
extends CompilerFilePass {
    private static final SoyErrorKind INCORRECT_NUM_ARGS = SoyErrorKind.of("Function ''{0}'' called with {1} arguments (expected {2}).");
    private static final SoyErrorKind INCORRECT_ARG_TYPE = SoyErrorKind.of("Function ''{0}'' called with incorrect arg type {1} (expected {2}).");
    private static final SoyErrorKind LOOP_VARIABLE_NOT_IN_SCOPE = SoyErrorKind.of("Function ''{0}'' must have a foreach loop variable as its argument.");
    private static final SoyErrorKind QUOTE_KEYS_IF_JS_REQUIRES_MAP_LITERAL_ARG = SoyErrorKind.of("Function ''quoteKeysIfJs'' called with argument of type {0} (expected map literal).");
    private static final SoyErrorKind UNKNOWN_FUNCTION = SoyErrorKind.of("Unknown function ''{0}''.");
    private final ErrorReporter errorReporter;
    private final boolean allowUnknownFunction;
    private final CheckFunctionCallsExprVisitor exprNodeVisitor = new CheckFunctionCallsExprVisitor();
    private SyntaxVersion declaredSyntaxVersion;

    CheckFunctionCallsPass(boolean allowUnknownFunctions, SyntaxVersion declaredSyntaxVersion, ErrorReporter errorReporter) {
        this.allowUnknownFunction = allowUnknownFunctions;
        this.errorReporter = errorReporter;
        this.declaredSyntaxVersion = declaredSyntaxVersion;
    }

    @Override
    public void run(SoyFileNode file, IdGenerator nodeIdGen) {
        SoyTreeUtils.execOnAllV2Exprs(file, this.exprNodeVisitor);
    }

    private final class CheckFunctionCallsExprVisitor
    extends AbstractExprNodeVisitor<Void> {
        private CheckFunctionCallsExprVisitor() {
        }

        @Override
        protected void visitExprNode(ExprNode node) {
            if (node instanceof ExprNode.ParentExprNode) {
                this.visitChildren((ExprNode.ParentExprNode)node);
            }
        }

        @Override
        protected void visitFunctionNode(FunctionNode node) {
            String fnName = node.getFunctionName();
            SoyFunction function = node.getSoyFunction();
            if (function == null) {
                if (CheckFunctionCallsPass.this.declaredSyntaxVersion != SyntaxVersion.V1_0 && !CheckFunctionCallsPass.this.allowUnknownFunction) {
                    CheckFunctionCallsPass.this.errorReporter.report(node.getSourceLocation(), UNKNOWN_FUNCTION, fnName);
                }
                return;
            }
            ErrorReporter.Checkpoint checkpoint = CheckFunctionCallsPass.this.errorReporter.checkpoint();
            this.checkNumArgs(function, node);
            if (!CheckFunctionCallsPass.this.errorReporter.errorsSince(checkpoint)) {
                if (function instanceof BuiltinFunction) {
                    this.visitNonpluginFunction((BuiltinFunction)function, node);
                } else {
                    this.visitFunction(function, node);
                }
            }
            this.visitChildren(node);
        }

        private void visitNonpluginFunction(BuiltinFunction nonpluginFn, FunctionNode node) {
            String fnName = nonpluginFn.getName();
            ExprNode firstChild = (ExprNode)Iterables.getFirst(node.getChildren(), null);
            switch (nonpluginFn) {
                case INDEX: 
                case IS_FIRST: 
                case IS_LAST: {
                    this.requireLoopVariableInScope(node, firstChild);
                    break;
                }
                case QUOTE_KEYS_IF_JS: {
                    if (firstChild instanceof MapLiteralNode) break;
                    CheckFunctionCallsPass.this.errorReporter.report(node.getSourceLocation(), QUOTE_KEYS_IF_JS_REQUIRES_MAP_LITERAL_ARG, node.getChild(0).getType().toString());
                    break;
                }
                case CHECK_NOT_NULL: {
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unrecognized nonplugin fn " + fnName));
                }
            }
        }

        private void visitFunction(SoyFunction fn, FunctionNode node) {
            if (fn instanceof LengthFunction) {
                this.checkArgType(node.getChild(0), ListType.of(AnyType.getInstance()), node);
            } else if (fn instanceof ParseIntFunction) {
                this.checkArgType(node.getChild(0), StringType.getInstance(), node);
            }
        }

        private void checkNumArgs(SoyFunction function, FunctionNode node) {
            int numArgs = node.numChildren();
            Set<Integer> arities = function.getValidArgsSizes();
            if (!arities.contains(numArgs)) {
                CheckFunctionCallsPass.this.errorReporter.report(node.getSourceLocation(), INCORRECT_NUM_ARGS, function.getName(), numArgs, Joiner.on((String)" or ").join(arities));
            }
        }

        private void requireLoopVariableInScope(FunctionNode fn, ExprNode loopVariable) {
            if (!(loopVariable instanceof VarRefNode) || !(((VarRefNode)loopVariable).getDefnDecl() instanceof LoopVar)) {
                CheckFunctionCallsPass.this.errorReporter.report(fn.getSourceLocation(), LOOP_VARIABLE_NOT_IN_SCOPE, fn.getFunctionName());
            }
        }

        private void checkArgType(ExprNode arg, SoyType expectedType, FunctionNode node) {
            SoyType.Kind argTypeKind = arg.getType().getKind();
            if (argTypeKind == SoyType.Kind.UNKNOWN || argTypeKind == SoyType.Kind.ERROR) {
                return;
            }
            if (!expectedType.isAssignableFrom(arg.getType())) {
                CheckFunctionCallsPass.this.errorReporter.report(arg.getSourceLocation(), INCORRECT_ARG_TYPE, node.getSoyFunction().getName(), arg.getType(), expectedType);
            }
        }
    }
}

