/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.dsl.CodeChunkUtils;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nullable;

public class JsCodeBuilder {
    private static final int INDENT_SIZE = 2;
    private final StringBuilder code;
    private final Deque<OutputVar> outputVars;
    private String indent;
    private final CodeChunk.RequiresCollector requireCollector = new CodeChunk.RequiresCollector(){

        @Override
        public void add(String require) {
            JsCodeBuilder.this.addGoogRequire(require, false);
        }
    };
    private final Map<String, Boolean> googRequires = new TreeMap<String, Boolean>();
    @Nullable
    protected CodeChunk.WithValue currOutputVar;
    private boolean currOutputVarIsInited;

    protected JsCodeBuilder() {
        this.code = new StringBuilder();
        this.indent = "";
        this.outputVars = new ArrayDeque<OutputVar>();
        this.currOutputVar = null;
        this.currOutputVarIsInited = false;
    }

    protected JsCodeBuilder(JsCodeBuilder parent) {
        this.code = new StringBuilder();
        this.indent = parent.indent;
        this.outputVars = parent.outputVars;
        this.currOutputVar = parent.currOutputVar;
        this.currOutputVarIsInited = parent.currOutputVarIsInited;
    }

    public void initOutputVarIfNecessary() {
        if (this.currOutputVarIsInited) {
            return;
        }
        this.appendLine("var ", this.currOutputVar.assertExpr().getText(), " = '';");
        this.setOutputVarInited();
    }

    public JsCodeBuilder addChunkToOutputVar(CodeChunk.WithValue chunk) {
        return this.addChunksToOutputVar((List<? extends CodeChunk.WithValue>)ImmutableList.of((Object)chunk));
    }

    public JsCodeBuilder addChunksToOutputVar(List<? extends CodeChunk.WithValue> codeChunks) {
        if (this.currOutputVarIsInited) {
            CodeChunk.WithValue rhs = CodeChunkUtils.concatChunks(codeChunks);
            rhs.collectRequires(this.requireCollector);
            this.appendLine(this.currOutputVar.plusEquals(rhs).getCode());
        } else {
            CodeChunk.WithValue rhs = CodeChunkUtils.concatChunksForceString(codeChunks);
            rhs.collectRequires(this.requireCollector);
            this.append(CodeChunk.declare(this.currOutputVar.singleExprOrName().getText(), rhs));
            this.setOutputVarInited();
        }
        return this;
    }

    public final JsCodeBuilder increaseIndent() {
        return this.changeIndentHelper(1);
    }

    public final JsCodeBuilder increaseIndentTwice() {
        return this.changeIndentHelper(2);
    }

    public final JsCodeBuilder decreaseIndent() {
        return this.changeIndentHelper(-1);
    }

    public final JsCodeBuilder decreaseIndentTwice() {
        return this.changeIndentHelper(-2);
    }

    private JsCodeBuilder changeIndentHelper(int chg) {
        int newIndentDepth = this.indent.length() + chg * 2;
        Preconditions.checkState((newIndentDepth >= 0 ? 1 : 0) != 0);
        this.indent = Strings.repeat((String)" ", (int)newIndentDepth);
        return this;
    }

    void setIndent(int indentCt) {
        this.indent = Strings.repeat((String)" ", (int)indentCt);
    }

    int getIndent() {
        return this.indent.length();
    }

    public JsCodeBuilder pushOutputVar(String outputVarName) {
        this.currOutputVar = CodeChunk.id(outputVarName);
        this.outputVars.push(new OutputVar(this.currOutputVar, false));
        this.currOutputVarIsInited = false;
        return this;
    }

    public JsCodeBuilder popOutputVar() {
        this.outputVars.pop();
        OutputVar top = this.outputVars.peek();
        if (top != null) {
            this.currOutputVar = top.name;
            this.currOutputVarIsInited = top.initialized;
        } else {
            this.currOutputVar = null;
            this.currOutputVarIsInited = false;
        }
        return this;
    }

    public JsCodeBuilder setOutputVarInited() {
        this.outputVars.pop();
        this.outputVars.push(new OutputVar(this.currOutputVar, true));
        this.currOutputVarIsInited = true;
        return this;
    }

    public JsCodeBuilder append(CodeChunk codeChunk) {
        codeChunk.collectRequires(this.requireCollector);
        return this.append(codeChunk.getStatementsForInsertingIntoForeignCodeAtIndent(this.indent.length()));
    }

    public JsCodeBuilder append(String ... codeFragments) {
        for (String codeFragment : codeFragments) {
            this.code.append(codeFragment);
        }
        return this;
    }

    public JsCodeBuilder appendLine(String ... codeFragments) {
        this.code.append(this.indent);
        this.append(codeFragments);
        this.code.append("\n");
        return this;
    }

    public JsCodeBuilder appendLineStart(String ... codeFragments) {
        this.code.append(this.indent);
        this.append(codeFragments);
        return this;
    }

    public JsCodeBuilder appendLineEnd(String ... codeFragments) {
        this.append(codeFragments);
        this.code.append("\n");
        return this;
    }

    public void addGoogRequire(String namespace, boolean suppressExtra) {
        Boolean old = this.googRequires.put(namespace, suppressExtra);
        if (old != null && !old.booleanValue() && suppressExtra) {
            this.googRequires.put(namespace, false);
        }
    }

    void appendGoogRequires(StringBuilder sb) {
        for (Map.Entry<String, Boolean> entry : this.googRequires.entrySet()) {
            if (entry.getValue().booleanValue()) {
                sb.append("/** @suppress {extraRequire} */\n");
            }
            sb.append("goog.require('").append(entry.getKey()).append("');\n");
        }
    }

    public String getCode() {
        return this.code.toString();
    }

    void appendCode(StringBuilder sb) {
        sb.append((CharSequence)this.code);
    }

    CodeChunk getCodeAsChunkLegacyOnly() {
        return CodeChunk.treatRawStringAsStatementLegacyOnly(this.getCode(), (Iterable<String>)ImmutableList.copyOf(this.googRequires.keySet()));
    }

    private static final class OutputVar {
        final CodeChunk.WithValue name;
        final boolean initialized;

        OutputVar(CodeChunk.WithValue name, boolean initialized) {
            this.name = name;
            this.initialized = initialized;
        }
    }
}

