/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.dsl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.jssrc.dsl.AutoValue_MapLiteral;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.dsl.FormattingContext;
import com.google.template.soy.jssrc.dsl.OutputContext;
import com.google.template.soy.jssrc.restricted.JsExpr;

abstract class MapLiteral
extends CodeChunk.WithValue {
    MapLiteral() {
    }

    abstract ImmutableList<? extends CodeChunk.WithValue> keys();

    abstract ImmutableList<? extends CodeChunk.WithValue> values();

    static MapLiteral create(ImmutableList<? extends CodeChunk.WithValue> keys, ImmutableList<? extends CodeChunk.WithValue> values) {
        Preconditions.checkArgument((keys.size() == values.size() ? 1 : 0) != 0, (Object)"Mismatch between keys and values.");
        return new AutoValue_MapLiteral(keys, values);
    }

    @Override
    public boolean isRepresentableAsSingleExpression() {
        for (CodeChunk.WithValue key : this.keys()) {
            if (key.isRepresentableAsSingleExpression()) continue;
            return false;
        }
        for (CodeChunk.WithValue value : this.values()) {
            if (value.isRepresentableAsSingleExpression()) continue;
            return false;
        }
        return true;
    }

    @Override
    public JsExpr singleExprOrName() {
        FormattingContext ctx = new FormattingContext();
        this.formatOutputExpr(ctx, OutputContext.EXPRESSION);
        return new JsExpr(ctx.toString(), Integer.MAX_VALUE);
    }

    @Override
    void doFormatOutputExpr(FormattingContext ctx, OutputContext outputContext) {
        ctx.append('{');
        for (int i = 0; i < this.keys().size(); ++i) {
            if (i > 0) {
                ctx.append(", ");
            }
            ((CodeChunk.WithValue)this.keys().get(i)).formatOutputExpr(ctx, OutputContext.EXPRESSION);
            ctx.append(": ");
            ((CodeChunk.WithValue)this.values().get(i)).formatOutputExpr(ctx, OutputContext.EXPRESSION);
        }
        ctx.append('}');
    }

    @Override
    void doFormatInitialStatements(FormattingContext ctx, boolean moreToCome) {
        for (int i = 0; i < this.keys().size(); ++i) {
            ((CodeChunk.WithValue)this.keys().get(i)).formatInitialStatements(ctx, moreToCome || i < this.keys().size() - 1);
            ((CodeChunk.WithValue)this.values().get(i)).formatInitialStatements(ctx, moreToCome || i < this.keys().size() - 1);
        }
    }

    @Override
    public void collectRequires(CodeChunk.RequiresCollector collector) {
        for (CodeChunk.WithValue key : this.keys()) {
            key.collectRequires(collector);
        }
        for (CodeChunk.WithValue value : this.values()) {
            value.collectRequires(collector);
        }
    }
}

