/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.dsl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.jssrc.dsl.AutoValue_Conditional;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.dsl.FormattingContext;
import com.google.template.soy.jssrc.dsl.IfThenPair;
import com.google.template.soy.jssrc.dsl.OutputContext;
import javax.annotation.Nullable;

abstract class Conditional
extends CodeChunk {
    Conditional() {
    }

    abstract ImmutableList<IfThenPair> conditions();

    @Nullable
    abstract CodeChunk trailingElse();

    static Conditional create(ImmutableList<IfThenPair> conditions, @Nullable CodeChunk trailingElse) {
        Preconditions.checkArgument((!conditions.isEmpty() ? 1 : 0) != 0);
        return new AutoValue_Conditional(conditions, trailingElse);
    }

    @Override
    void doFormatInitialStatements(FormattingContext ctx, boolean moreToCome) {
        this.formatIfClause(ctx);
        int numRightBracesToClose = 0;
        for (IfThenPair condition : this.conditions().subList(1, this.conditions().size())) {
            if (condition.predicate.isRepresentableAsSingleExpression()) {
                Conditional.formatElseIfClauseWithNoDependencies(condition, ctx);
                continue;
            }
            Conditional.formatElseIfClauseWithDependencies(condition, ctx);
            ++numRightBracesToClose;
        }
        this.formatElseClause(ctx);
        for (int i = 0; i < numRightBracesToClose; ++i) {
            ctx.close();
        }
        if (moreToCome) {
            ctx.endLine();
        }
    }

    @Override
    public void collectRequires(CodeChunk.RequiresCollector collector) {
        for (IfThenPair child : this.conditions()) {
            child.predicate.collectRequires(collector);
            child.consequent.collectRequires(collector);
        }
        if (this.trailingElse() != null) {
            this.trailingElse().collectRequires(collector);
        }
    }

    private void formatIfClause(FormattingContext ctx) {
        IfThenPair first = (IfThenPair)this.conditions().get(0);
        first.predicate.formatInitialStatements(ctx, true);
        ctx.append("if (");
        first.predicate.formatOutputExpr(ctx, OutputContext.EXPRESSION);
        ctx.append(") ");
        try (FormattingContext ignored = ctx.enterBlock();){
            first.consequent.formatAllStatements(ctx, false);
        }
    }

    private static void formatElseIfClauseWithNoDependencies(IfThenPair condition, FormattingContext ctx) {
        ctx.append(" else if (");
        condition.predicate.formatOutputExpr(ctx, OutputContext.EXPRESSION);
        ctx.append(") ");
        try (FormattingContext ignored = ctx.enterBlock();){
            condition.consequent.formatAllStatements(ctx, false);
        }
    }

    private static void formatElseIfClauseWithDependencies(IfThenPair condition, FormattingContext ctx) {
        ctx.append(" else ");
        try (FormattingContext ignored = ctx.enterBlock();){
            condition.predicate.formatInitialStatements(ctx, true);
            ctx.append("if (");
            condition.predicate.formatOutputExpr(ctx, OutputContext.EXPRESSION);
            ctx.append(") ");
            ctx.enterBlock();
            condition.consequent.formatAllStatements(ctx, false);
        }
    }

    private void formatElseClause(FormattingContext ctx) {
        if (this.trailingElse() == null) {
            return;
        }
        ctx.append(" else ");
        try (FormattingContext ignored = ctx.enterBlock();){
            this.trailingElse().formatAllStatements(ctx, false);
        }
        ctx.endLine();
    }

    boolean everyBranchHasAValue() {
        for (IfThenPair condition : this.conditions()) {
            if (condition.consequent instanceof CodeChunk.WithValue) continue;
            return false;
        }
        return this.trailingElse() instanceof CodeChunk.WithValue;
    }
}

