/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.dsl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.jssrc.dsl.AutoValue_Composite;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.dsl.FormattingContext;
import com.google.template.soy.jssrc.dsl.OutputContext;
import com.google.template.soy.jssrc.restricted.JsExpr;

abstract class Composite
extends CodeChunk.WithValue {
    Composite() {
    }

    abstract ImmutableList<CodeChunk> children();

    abstract String varName();

    static Composite create(ImmutableList<CodeChunk> children, String varName) {
        Preconditions.checkState((children.size() > 1 ? 1 : 0) != 0);
        return new AutoValue_Composite(children, varName);
    }

    @Override
    void doFormatInitialStatements(FormattingContext ctx, boolean moreToCome) {
        for (int i = 0; i < this.children().size(); ++i) {
            ((CodeChunk)this.children().get(i)).formatInitialStatements(ctx, moreToCome || i < this.children().size() - 1);
        }
    }

    @Override
    public void collectRequires(CodeChunk.RequiresCollector collector) {
        for (CodeChunk child : this.children()) {
            child.collectRequires(collector);
        }
    }

    @Override
    void doFormatOutputExpr(FormattingContext ctx, OutputContext outputContext) {
        if (outputContext != OutputContext.EXPRESSION) {
            return;
        }
        ctx.append(this.varName());
    }

    @Override
    public boolean isRepresentableAsSingleExpression() {
        return false;
    }

    @Override
    public JsExpr singleExprOrName() {
        return new JsExpr(this.varName(), Integer.MAX_VALUE);
    }
}

